/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.trace;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.internal.trace.ElementCounters;
import org.eclipse.net4j.trace.Element;
import org.eclipse.net4j.trace.Listener;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.om.log.RollingLog;

public class Logger
extends RollingLog
implements Listener {
    private static final Pattern INIT_PATTERN = Pattern.compile("([A-Za-z_$][A-Za-z\\d_$]+)\\[(\\d+)\\].init\\(\\)");

    public Logger(String logFile, long logSize, boolean append) {
        super(logFile, logSize, append);
    }

    @Override
    public void methodCalled(Element caller, String callingMethod, Element callee, String calledMethod) {
        this.log(caller + "." + callingMethod + "()\t" + callee + "." + calledMethod + "()");
    }

    @Override
    public void elementCreated(Element element) {
        this.log(element + ".init()");
    }

    @Override
    public void ownerChanged(Element.BufferElement element, Element oldOwner, Element newOwner) {
        this.log("\t\t" + element + ".owner = " + newOwner);
    }

    @Override
    public void threadChanged(Element.BufferElement element, Element oldThread, Element newThread) {
        String warning = oldThread != null && newThread != null ? "  (was " + oldThread + ")" : "";
        this.log("\t\t" + element + ".thread = " + newThread + warning);
    }

    @Override
    public void stateChanged(Element.BufferElement element, BufferState oldState, BufferState newState) {
        this.log("\t\t" + element + ".state = " + newState);
    }

    @Override
    public void positionChanged(Element.BufferElement element, int oldPosition, int newPosition) {
        this.log("\t\t" + element + ".position = " + newPosition);
    }

    @Override
    public void limitChanged(Element.BufferElement element, int oldLimit, int newLimit) {
        this.log("\t\t" + element + ".limit = " + newLimit);
    }

    @Override
    public void eosChanged(Element.BufferElement element, boolean newEOS) {
        this.log("\t\t" + element + ".eos = " + newEOS);
    }

    @Override
    public void ccamChanged(Element.BufferElement element, boolean newCCAM) {
        this.log("\t\t" + element + ".ccam = " + newCCAM);
    }

    protected String getThreadInfo() {
        return Element.get(Thread.currentThread()).toString();
    }

    protected void load(Properties properties) {
        ElementCounters.INSTANCE.load(properties);
    }

    protected void save(Properties properties) {
        ElementCounters.INSTANCE.save(properties);
    }

    protected void recovery(Properties properties, RollingLog.LogLine logLine) {
        String message = logLine.getMessage();
        Matcher matcher = INIT_PATTERN.matcher(message);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String id = matcher.group(2);
            properties.setProperty(type, id);
        }
    }

    public static final class Factory
    extends Listener.Factory {
        public static final String TYPE = "logger";

        public Factory() {
            super(TYPE);
        }

        @Override
        protected Logger create(Map<String, String> properties) throws ProductCreationException {
            String append;
            String logSize;
            String logFile = properties.get("_");
            if (StringUtil.isEmpty((String)logFile)) {
                logFile = "buffers";
            }
            if (StringUtil.isEmpty((String)(logSize = properties.get("size")))) {
                logSize = "100000000";
            }
            if (StringUtil.isEmpty((String)(append = properties.get("append")))) {
                append = StringUtil.TRUE;
            }
            return new Logger(logFile, Long.parseLong(logSize), Boolean.parseBoolean(append));
        }
    }
}

