/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.mem;

import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.mem.MEMStore;
import org.eclipse.emf.cdo.internal.server.mem.MEMStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.StoreChunkReader;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MEMStoreChunkReader
extends StoreChunkReader {
    public MEMStoreChunkReader(IStoreAccessor accessor, CDORevision revision, EStructuralFeature feature) {
        super(accessor, revision, feature);
    }

    @Override
    public List<IStoreChunkReader.Chunk> executeRead() {
        CDOID id = this.getRevision().getID();
        CDORevision branchVersion = this.getRevision();
        MEMStore store = this.getAccessor().getStore();
        List<IStoreChunkReader.Chunk> chunks = this.getChunks();
        for (IStoreChunkReader.Chunk chunk : chunks) {
            int startIndex = chunk.getStartIndex();
            InternalCDORevision revision = store.getRevisionByVersion(id, (CDOBranchVersion)branchVersion);
            int i = 0;
            while (i < chunk.size()) {
                Object object = revision.get(this.getFeature(), startIndex + i);
                chunk.add(i, object);
                ++i;
            }
        }
        return chunks;
    }

    @Override
    public MEMStoreAccessor getAccessor() {
        return (MEMStoreAccessor)super.getAccessor();
    }
}

