/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DistinctNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.NormalizeResultSetNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class UnionNode
extends SetOperatorNode {
    private boolean addNewNodesCalled;
    boolean tableConstructor;
    boolean topTableConstructor;

    UnionNode(ResultSetNode leftResult, ResultSetNode rightResult, boolean all, boolean tableConstructor, Properties tableProperties, ContextManager cm) throws StandardException {
        super(leftResult, rightResult, all, tableProperties, cm);
        this.tableConstructor = tableConstructor;
    }

    void markTopTableConstructor() {
        this.topTableConstructor = true;
    }

    boolean tableConstructor() {
        return this.tableConstructor;
    }

    @Override
    void rejectParameters() throws StandardException {
        if (!this.tableConstructor()) {
            super.rejectParameters();
        }
    }

    @Override
    void setTableConstructorTypes(ResultColumnList typeColumns) throws StandardException {
        SanityManager.ASSERT(this.getResultColumns().size() <= typeColumns.size(), "More columns in ResultColumnList than in base table.");
        if (this.tableConstructor()) {
            ResultSetNode rsn = this;
            while (rsn instanceof UnionNode) {
                UnionNode union = rsn;
                SanityManager.ASSERT(union.rightResultSet instanceof RowResultSetNode, "A " + union.rightResultSet.getClass().getName() + " is on the right of a union in a table constructor");
                ((RowResultSetNode)union.rightResultSet).setTableConstructorTypes(typeColumns);
                rsn = union.leftResultSet;
            }
            SanityManager.ASSERT(rsn instanceof RowResultSetNode, "A " + rsn.getClass().getName() + " is at the left end of a table constructor");
            ((RowResultSetNode)rsn).setTableConstructorTypes(typeColumns);
        }
    }

    @Override
    ResultSetNode enhanceRCLForInsert(InsertNode target, boolean inOrder, int[] colMap) throws StandardException {
        if (this.tableConstructor()) {
            this.leftResultSet = target.enhanceAndCheckForAutoincrement(this.leftResultSet, inOrder, colMap, false);
            this.rightResultSet = target.enhanceAndCheckForAutoincrement(this.rightResultSet, inOrder, colMap, false);
            if (!inOrder || this.getResultColumns().size() < target.resultColumnList.size()) {
                this.setResultColumns(this.getRCLForInsert(target, colMap));
            }
            return this;
        }
        return super.enhanceRCLForInsert(target, inOrder, colMap);
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        if (predList != null && !this.getCurrentAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predList.getOptPredicate(i))) continue;
                predList.removeOptPredicate(i);
            }
        }
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftOptPredicateList(), outerCost);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightOptPredicateList(), outerCost);
        CostEstimate costEst = this.getCostEstimate(optimizer);
        costEst.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        costEst.add(this.rightResultSet.getCostEstimate(), costEst);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, costEst);
        optimizer.considerCost(this, predList, costEst, outerCost);
        return costEst;
    }

    @Override
    void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.leftResultSet instanceof UnionNode) {
            ((UnionNode)this.leftResultSet).pushExpressions(predicateList);
        } else if (this.leftResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.leftResultSet, true);
        }
        if (this.rightResultSet instanceof UnionNode) {
            ((UnionNode)this.rightResultSet).pushExpressions(predicateList);
        } else if (this.rightResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.rightResultSet, true);
        }
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        Optimizable retOptimizable = super.modifyAccessPath(outerTables);
        if (this.addNewNodesCalled) {
            return retOptimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode retRSN = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return retRSN;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        FromTable treeTop = this;
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        if (!this.all) {
            if (!this.columnTypesAndLengthsMatch()) {
                treeTop = new NormalizeResultSetNode(treeTop, null, null, false, this.getContextManager());
            }
            treeTop = new DistinctNode(treeTop.genProjectRestrict(), false, this.tableProperties, this.getContextManager());
            ((FromTable)treeTop).setTableNumber(this.tableNumber);
            treeTop.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
            this.all = true;
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl != null) {
                treeTop = new OrderByNode(treeTop, obl, this.tableProperties, this.getContextManager());
            }
            ValueNode offset = this.qec.getOffset(i);
            ValueNode fetchFirst = this.qec.getFetchFirst(i);
            if (offset == null && fetchFirst == null) continue;
            ResultColumnList newRcl = treeTop.getResultColumns().copyListAndObjects();
            newRcl.genVirtualColumnNodes(treeTop, treeTop.getResultColumns());
            treeTop = new RowCountNode(treeTop, newRcl, offset, fetchFirst, this.qec.getHasJDBCLimitClause()[i], this.getContextManager());
        }
        return treeTop;
    }

    @Override
    public String toString() {
        return "tableConstructor: " + this.tableConstructor + "\n" + super.toString();
    }

    @Override
    public void bindExpressions(FromList fromListParam) throws StandardException {
        super.bindExpressions(fromListParam);
        if (this.topTableConstructor && !this.isInsertSource()) {
            RowResultSetNode rrsn;
            SetOperatorNode setOperator;
            DataTypeDescriptor[] types = new DataTypeDescriptor[this.leftResultSet.getResultColumns().size()];
            int numTypes = 0;
            ResultSetNode rsn = this;
            while (rsn instanceof SetOperatorNode) {
                setOperator = rsn;
                SanityManager.ASSERT(setOperator.rightResultSet instanceof RowResultSetNode, "A " + setOperator.rightResultSet.getClass().getName() + " is on the right side of a setOperator in a table constructor");
                rrsn = (RowResultSetNode)setOperator.rightResultSet;
                numTypes += this.getParamColumnTypes(types, rrsn);
                rsn = setOperator.leftResultSet;
            }
            SanityManager.ASSERT(rsn instanceof RowResultSetNode);
            if ((numTypes += this.getParamColumnTypes(types, (RowResultSetNode)rsn)) < types.length) {
                throw StandardException.newException("42Y10", new Object[0]);
            }
            rsn = this;
            while (rsn instanceof SetOperatorNode) {
                setOperator = rsn;
                rrsn = (RowResultSetNode)setOperator.rightResultSet;
                this.setParamColumnTypes(types, rrsn);
                rsn = setOperator.leftResultSet;
            }
            this.setParamColumnTypes(types, (RowResultSetNode)rsn);
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.all, "all expected to be true");
        this.assignResultSetNumber();
        this.setCostEstimate(this.getFinalCostEstimate());
        acb.pushGetResultSetFactoryExpression(mb);
        this.leftResultSet.generate(acb, mb);
        if (!this.getResultColumns().isExactTypeAndLengthMatch(this.leftResultSet.getResultColumns())) {
            acb.pushGetResultSetFactoryExpression(mb);
            mb.swap();
            this.generateNormalizationResultSet(acb, mb, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        this.rightResultSet.generate(acb, mb);
        if (!this.getResultColumns().isExactTypeAndLengthMatch(this.rightResultSet.getResultColumns())) {
            acb.pushGetResultSetFactoryExpression(mb);
            mb.swap();
            this.generateNormalizationResultSet(acb, mb, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        mb.push(this.getResultSetNumber());
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getUnionResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 5);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        CostEstimate leftCE = this.leftResultSet.getFinalCostEstimate();
        CostEstimate rightCE = this.rightResultSet.getFinalCostEstimate();
        this.setCandidateFinalCostEstimate(this.getNewCostEstimate());
        this.getCandidateFinalCostEstimate().setCost(leftCE.getEstimatedCost(), leftCE.rowCount(), leftCE.singleScanRowCount() + rightCE.singleScanRowCount());
        this.getCandidateFinalCostEstimate().add(rightCE, this.getCandidateFinalCostEstimate());
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    String getOperatorName() {
        return "UNION";
    }
}

