/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class XactContext
extends ContextImpl {
    private RawTransaction xact;
    private RawStoreFactory factory;
    private boolean abortAll;

    XactContext(ContextManager cm, String name, Xact xact, boolean abortAll, RawStoreFactory factory) {
        super(cm, name);
        this.xact = xact;
        this.abortAll = abortAll;
        this.factory = factory;
        xact.xc = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        SanityManager.ASSERT(this.getContextManager() != null);
        boolean throwAway = false;
        if (error instanceof StandardException) {
            StandardException se = (StandardException)error;
            if (this.abortAll) {
                if (se.getSeverity() < 30000) {
                    throw StandardException.newException("40XT5", error, new Object[0]);
                }
                throwAway = true;
            } else {
                if (se.getSeverity() < 30000) {
                    return;
                }
                if (se.getSeverity() >= 40000) {
                    throwAway = true;
                }
            }
        } else {
            throwAway = true;
        }
        try {
            if (this.xact != null) {
                this.xact.abort();
            }
        }
        catch (StandardException se) {
            throwAway = true;
            if (se.getSeverity() <= 40000 && se.getSeverity() >= ((StandardException)error).getSeverity()) {
                throw this.factory.markCorrupt(StandardException.newException("XSTB0.M", se, new Object[0]));
            }
        }
        finally {
            if (throwAway) {
                this.xact.close();
                this.xact = null;
            }
        }
    }

    RawTransaction getTransaction() {
        return this.xact;
    }

    RawStoreFactory getFactory() {
        return this.factory;
    }

    void substituteTransaction(Xact newTran) {
        Xact oldTran = (Xact)this.xact;
        if (oldTran.xc == this) {
            oldTran.xc = null;
        }
        this.xact = newTran;
        ((Xact)this.xact).xc = this;
    }
}

