/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBSchemaVisitor;
import org.eclipse.net4j.internal.db.ddl.DBNamedElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchemaElement;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.PositionProvider;

public abstract class DBSchemaElement
extends DBNamedElement
implements InternalDBSchemaElement {
    private static final long serialVersionUID = 1L;
    private static final IDBSchemaElement[] NO_ELEMENTS = new IDBSchemaElement[0];
    private transient IDBSchemaElement[] elements;
    private transient IDBSchemaElement wrapper;

    public DBSchemaElement(String name) {
        super(name);
    }

    protected DBSchemaElement() {
    }

    @Override
    public IDBSchemaElement getWrapper() {
        return this.wrapper;
    }

    @Override
    public final void setWrapper(IDBSchemaElement wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public final boolean equals(Object obj) {
        if (super.equals(obj)) {
            return this.getSchemaElementType() == ((IDBSchemaElement)obj).getSchemaElementType();
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return super.hashCode() ^ this.getSchemaElementType().hashCode();
    }

    @Override
    public final int compareTo(IDBSchemaElement element2) {
        int result = this.getSchemaElementType().compareTo(element2.getSchemaElementType());
        if (result == 0) {
            if (this instanceof PositionProvider && element2 instanceof PositionProvider) {
                int position1 = ((PositionProvider)this).getPosition();
                int position2 = ((PositionProvider)element2).getPosition();
                result = Integer.compare(position1, position2);
            }
            if (result == 0) {
                String name1 = this.getName();
                String name2 = element2.getName();
                InternalDBSchema schema = (InternalDBSchema)this.getSchema();
                result = schema.compareNames(name1, name2);
            }
        }
        return result;
    }

    public final boolean isEmpty() {
        return this.getElements().length == 0;
    }

    public final IDBSchemaElement[] getElements() {
        if (this.elements == null) {
            ArrayList<IDBSchemaElement> result = new ArrayList<IDBSchemaElement>();
            this.collectElements(result);
            if (result.isEmpty()) {
                this.elements = NO_ELEMENTS;
            } else {
                this.elements = result.toArray(new IDBSchemaElement[result.size()]);
                Arrays.sort(this.elements);
            }
        }
        return this.elements;
    }

    protected final void resetElements() {
        this.elements = null;
    }

    protected abstract void collectElements(List<IDBSchemaElement> var1);

    @Override
    public final <T extends IDBSchemaElement> T getElement(Class<T> type, String name) {
        InternalDBSchema schema = (InternalDBSchema)this.getSchema();
        IDBSchemaElement[] iDBSchemaElementArray = this.getElements();
        int n = iDBSchemaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBSchemaElement element = iDBSchemaElementArray[n2];
            if (type.isAssignableFrom(element.getClass()) && schema.equalNames(element.getName(), name)) {
                IDBSchemaElement result = element;
                return (T)result;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public final void accept(IDBSchemaVisitor visitor) {
        try {
            this.doAccept(visitor);
        }
        catch (IDBSchemaVisitor.StopRecursion ex) {
            return;
        }
        IDBSchemaElement[] iDBSchemaElementArray = this.getElements();
        int n = iDBSchemaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBSchemaElement element = iDBSchemaElementArray[n2];
            element.accept(visitor);
            ++n2;
        }
    }

    protected abstract void doAccept(IDBSchemaVisitor var1);

    @Override
    public void dump(Writer writer) throws IOException {
        IDBSchemaElement.SchemaElementType schemaElementType = this.getSchemaElementType();
        int level = schemaElementType.getLevel();
        int i = 0;
        while (i < level) {
            writer.append("  ");
            ++i;
        }
        writer.append(schemaElementType.toString());
        writer.append(" ");
        writer.append(this.getName());
        this.dumpAdditionalProperties(writer);
        writer.append(StringUtil.NL);
        IDBSchemaElement[] iDBSchemaElementArray = this.getElements();
        int n = iDBSchemaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBSchemaElement element = iDBSchemaElementArray[n2];
            ((InternalDBSchemaElement)element).dump(writer);
            ++n2;
        }
    }

    protected void dumpAdditionalProperties(Writer writer) throws IOException {
    }

    @Override
    public String toString() {
        String name = this.getName();
        return DBUtil.quoted(name);
    }
}

