/*
 * Copyright (c) 2009-2012, 2014-2016, 2019, 2025 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Simon McDuff - initial API and implementation
 *    Eike Stepper - maintenance
 */
package org.eclipse.emf.cdo.view;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.view.CDOView.Options;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

import java.util.Collections;
import java.util.List;

/**
 * A strategy interface to customize the {@link CDORevision revision} prefetching behavior of a {@link CDOView view}.
 *
 * @see Options#setRevisionPrefetchingPolicy(CDORevisionPrefetchingPolicy)
 * @author Simon McDuff
 * @since 2.0
 */
public interface CDORevisionPrefetchingPolicy
{
  public static final CDORevisionPrefetchingPolicy NO_PREFETCHING = new CDORevisionPrefetchingPolicy()
  {
    @Override
    public List<CDOID> loadAhead(CDORevisionManager revisionManager, CDOBranchPoint branchPoint, EObject targetObject, EStructuralFeature feature, CDOList list,
        int accessIndex, CDOID accessID)
    {
      return Collections.emptyList();
    }
  };

  /**
   * @param revisionManager
   *          Lookup availability of objects in the cache with
   *          {@link CDORevisionManager#containsRevision(CDOID, CDOBranchPoint)}.
   * @param targetObject
   *          Container of the list
   * @return Should return a list of id's to fetch.
   * @since 3.0
   */
  public List<CDOID> loadAhead(CDORevisionManager revisionManager, CDOBranchPoint branchPoint, EObject targetObject, EStructuralFeature feature, CDOList list,
      int accessIndex, CDOID accessID);
}
