/*
 * Copyright (c) 2020 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Sebastien REVOL (CEA LIST) sebastien.revol@cea.fr - Initial API and implementation
 */
package org.eclipse.emf.cdo.ecore.xml.namespace.impl;

import org.eclipse.emf.cdo.ecore.impl.EStringToStringMapEntryImpl;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;

/**
 * @author Sebastien Revol
 */
public class XMLNamespaceDocumentRootImpl extends org.eclipse.emf.ecore.xml.namespace.impl.XMLNamespaceDocumentRootImpl
{
  @Override
  public EMap<String, String> getXMLNSPrefixMap()
  {
    if (xMLNSPrefixMap == null)
    {
      // The super class implementation would pass EMF's EStringToStringMapEntryImpl,
      // but that's not compatible with CDO's replacement. So pass in CDO's version of it.
      xMLNSPrefixMap = new EcoreEMap<>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, this,
          XMLNamespacePackage.XML_NAMESPACE_DOCUMENT_ROOT__XMLNS_PREFIX_MAP);
    }

    return xMLNSPrefixMap;
  }

  @Override
  public EMap<String, String> getXSISchemaLocation()
  {
    if (xSISchemaLocation == null)
    {
      // The super class implementation would pass EMF's EStringToStringMapEntryImpl,
      // but that's not compatible with CDO's replacement. So pass in CDO's version of it.
      xSISchemaLocation = new EcoreEMap<>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, this,
          XMLNamespacePackage.XML_NAMESPACE_DOCUMENT_ROOT__XSI_SCHEMA_LOCATION);
    }

    return xSISchemaLocation;
  }
}
