/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.http;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.net4j.internal.http.HTTPClientConnector;
import org.eclipse.spi.net4j.ConnectorFactory;

public class HTTPConnectorFactory
extends ConnectorFactory {
    private static final String HTTP_SCHEME_PREFIX = "http://";
    public static final String TYPE = "http";

    public HTTPConnectorFactory() {
        super(TYPE);
    }

    public HTTPClientConnector create(String description) {
        String userID = null;
        if (!description.startsWith(HTTP_SCHEME_PREFIX)) {
            description = HTTP_SCHEME_PREFIX + description;
        }
        try {
            URL url = new URL(description);
            userID = url.getUserInfo();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        HTTPClientConnector connector = new HTTPClientConnector();
        connector.setURL(description);
        connector.setUserID(userID);
        return connector;
    }

    public String getDescriptionFor(Object object) {
        if (object instanceof HTTPClientConnector) {
            HTTPClientConnector connector = (HTTPClientConnector)((Object)object);
            return connector.getURL();
        }
        return null;
    }
}

