/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.processing.handlers;

import java.io.IOException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.AbstractPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.CommandPackage;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;

public class CommandPluginHandler {
    private Connection connection;

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void sendStepIntoCommand() throws DebugException {
        this.sendCommand(1);
    }

    public void sendStepOverCommand() throws DebugException {
        this.sendCommand(2);
    }

    public void sendStepReturnCommand() throws DebugException {
        this.sendCommand(3);
    }

    public void sendResumeCommand() throws DebugException {
        this.sendCommand(4);
    }

    public void sendSuspendCommand() throws DebugException {
        this.sendCommand(5);
    }

    public void sendTerminateCommand() throws DebugException {
        this.sendCommand(6);
    }

    private void sendCommand(int type) throws DebugException {
        try {
            this.connection.sendPackage((AbstractPackage)new CommandPackage(type));
        }
        catch (IOException e) {
            throw new DebugException(Activator.createErrorStatus("lost connection to debugger runtime process", e));
        }
    }
}

