/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.action.contributionitem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ActionRegistry;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionPlugin;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.DisposeContributionsOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionDescriptorReader;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.ProviderContributionDescriptor;
import org.eclipse.gmf.runtime.common.ui.util.ActionGroupCache;
import org.eclipse.gmf.runtime.common.ui.util.IPartSelector;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.common.ui.util.WorkbenchPartDescriptor;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public abstract class AbstractContributionItemProvider
extends AbstractProvider
implements IContributionItemProvider,
IContributionDescriptorReader {
    private ProviderContributionDescriptor contributionDescriptor;
    private Map actionCache = new HashMap();
    private ActionGroupCache actionGroupCache = new ActionGroupCache();
    private IPluginContribution pluginContribution;
    private Set partDescriptors = new HashSet();

    protected IStructuredSelection getStructuredSelection(IWorkbenchPartDescriptor partDescriptor) {
        ISelectionProvider selectionProvider;
        StructuredSelection selection = null;
        IWorkbenchPart activePart = partDescriptor.getPartPage().getActivePart();
        if (activePart != null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null && selectionProvider.getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)selectionProvider.getSelection();
        }
        return selection != null ? selection : StructuredSelection.EMPTY;
    }

    protected Object getSelectedObject(IWorkbenchPartDescriptor partDescriptor) {
        IStructuredSelection ss = this.getStructuredSelection(partDescriptor);
        if (!ss.isEmpty()) {
            return ss.getFirstElement();
        }
        return null;
    }

    public final void setContributionDescriptor(ProviderContributionDescriptor descriptor) {
        this.contributionDescriptor = descriptor;
    }

    public final void contributeToActionBars(IActionBars actionBars, IWorkbenchPartDescriptor partDescriptor) {
        this.contributeToActionBars(actionBars, partDescriptor, false);
    }

    private void contributeToActionBars(IActionBars actionBars, IWorkbenchPartDescriptor partDescriptor, boolean updateOnly) {
        this.partDescriptors.add(partDescriptor);
        for (Object c : this.contributionDescriptor.getContributionsFor(partDescriptor.getPartId(), partDescriptor.getPartClass())) {
            ProviderContributionDescriptor.AbstractPartContributionItemDescriptor item;
            if (c instanceof ProviderContributionDescriptor.PartMenuDescriptor) {
                item = (ProviderContributionDescriptor.PartMenuDescriptor)c;
                if (!updateOnly) {
                    this.contributeItem(new MenuContributionItemAdapter(item.getId(), partDescriptor), (IContributionManager)actionBars.getMenuManager(), item.getMenubarPath(), item.getMenubarGroup());
                }
                this.contributeItem(new MenuContributionItemAdapter(item.getId(), partDescriptor), (IContributionManager)actionBars.getToolBarManager(), item.getToolbarPath(), item.getToolbarGroup());
                continue;
            }
            if (c instanceof ProviderContributionDescriptor.PartMenuGroupDescriptor) {
                item = (ProviderContributionDescriptor.PartMenuGroupDescriptor)c;
                if (!updateOnly) {
                    this.contributeItem(new MenuGroupContributionItemAdapter(item.getId(), ((ProviderContributionDescriptor.PartMenuGroupDescriptor)item).isSeparator()), (IContributionManager)actionBars.getMenuManager(), item.getMenubarPath(), item.getMenubarGroup());
                }
                this.contributeItem(new MenuGroupContributionItemAdapter(item.getId(), ((ProviderContributionDescriptor.PartMenuGroupDescriptor)item).isSeparator()), (IContributionManager)actionBars.getToolBarManager(), item.getToolbarPath(), item.getToolbarGroup());
                continue;
            }
            if (c instanceof ProviderContributionDescriptor.PartActionDescriptor) {
                item = (ProviderContributionDescriptor.PartActionDescriptor)c;
                if (!updateOnly) {
                    this.contributeItem(new ActionContributionItemAdapter(item.getId(), partDescriptor, item), (IContributionManager)actionBars.getMenuManager(), item.getMenubarPath(), item.getMenubarGroup());
                }
                this.contributeItem(new ActionContributionItemAdapter(item.getId(), partDescriptor, item), (IContributionManager)actionBars.getToolBarManager(), item.getToolbarPath(), item.getToolbarGroup());
                if (!((ProviderContributionDescriptor.PartActionDescriptor)item).isGlobal()) continue;
                actionBars.setGlobalActionHandler(item.getId(), this.getAction(item.getId(), partDescriptor, item));
                continue;
            }
            if (c instanceof ProviderContributionDescriptor.PartCustomDescriptor) {
                item = (ProviderContributionDescriptor.PartCustomDescriptor)c;
                if (!updateOnly) {
                    this.contributeItem(new CustomContributionItemAdapter(item.getId(), partDescriptor), (IContributionManager)actionBars.getMenuManager(), item.getMenubarPath(), item.getMenubarGroup());
                }
                this.contributeItem(new CustomContributionItemAdapter(item.getId(), partDescriptor), (IContributionManager)actionBars.getToolBarManager(), item.getToolbarPath(), item.getToolbarGroup());
                continue;
            }
            if (!(c instanceof ProviderContributionDescriptor.PartActionGroupDescriptor)) continue;
            item = (ProviderContributionDescriptor.PartActionGroupDescriptor)c;
            this.contributeItem(new ActionGroupContributionItemAdapter(item.getId(), partDescriptor), actionBars);
        }
    }

    public final void updateActionBars(IActionBars actionBars, IWorkbenchPartDescriptor partDescriptor) {
        if (!this.partDescriptors.contains(partDescriptor)) {
            this.contributeToActionBars(actionBars, partDescriptor, true);
        }
    }

    public final void contributeToPopupMenu(IMenuManager popupMenu, IWorkbenchPart workbenchPart) {
        ISelection selection = workbenchPart.getSite().getSelectionProvider().getSelection();
        WorkbenchPartDescriptor partDescriptor = new WorkbenchPartDescriptor(workbenchPart.getSite().getId(), workbenchPart.getClass(), workbenchPart.getSite().getPage());
        for (Object c : this.contributionDescriptor.getContributionsFor(popupMenu, selection)) {
            ProviderContributionDescriptor.AbstractContributionItemDescriptor item;
            if (c instanceof ProviderContributionDescriptor.PopupMenuDescriptor) {
                item = (ProviderContributionDescriptor.PopupMenuDescriptor)c;
                this.contributeItem(new MenuContributionItemAdapter(item.getId(), (IWorkbenchPartDescriptor)partDescriptor), (IContributionManager)popupMenu, ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getPath(), ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getGroup());
                continue;
            }
            if (c instanceof ProviderContributionDescriptor.PopupMenuGroupDescriptor) {
                item = (ProviderContributionDescriptor.PopupMenuGroupDescriptor)c;
                this.contributeItem(new MenuGroupContributionItemAdapter(item.getId(), ((ProviderContributionDescriptor.PopupMenuGroupDescriptor)item).isSeparator()), (IContributionManager)popupMenu, ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getPath(), ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getGroup());
                continue;
            }
            if (c instanceof ProviderContributionDescriptor.PopupActionDescriptor) {
                item = (ProviderContributionDescriptor.PopupActionDescriptor)c;
                this.contributeItem(new ActionContributionItemAdapter(item.getId(), (IWorkbenchPartDescriptor)partDescriptor, (IPartSelector)item), (IContributionManager)popupMenu, ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getPath(), ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getGroup());
                continue;
            }
            if (c instanceof ProviderContributionDescriptor.PopupCustomDescriptor) {
                item = (ProviderContributionDescriptor.PopupCustomDescriptor)c;
                this.contributeItem(new CustomContributionItemAdapter(item.getId(), (IWorkbenchPartDescriptor)partDescriptor), (IContributionManager)popupMenu, ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getPath(), ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getGroup());
                continue;
            }
            if (c instanceof ProviderContributionDescriptor.PopupActionGroupDescriptor) {
                item = (ProviderContributionDescriptor.PopupActionGroupDescriptor)c;
                this.contributeItem(new ActionGroupContributionItemAdapter(item.getId(), (IWorkbenchPartDescriptor)partDescriptor), (IContributionManager)popupMenu, ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getPath(), ((ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor)item).getGroup());
                continue;
            }
            if (!(c instanceof ProviderContributionDescriptor.PopupPredefinedItemDescriptor) || !((ProviderContributionDescriptor.PopupPredefinedItemDescriptor)(item = (ProviderContributionDescriptor.PopupPredefinedItemDescriptor)c)).isToBeRemoved()) continue;
            this.removeExistingItem(item.getId(), ((ProviderContributionDescriptor.PopupPredefinedItemDescriptor)item).getPath(), (IContributionManager)popupMenu);
        }
    }

    public final void disposeContributions(IWorkbenchPartDescriptor partDescriptor) {
        ActionRegistry registry = (ActionRegistry)this.actionCache.get(partDescriptor);
        if (registry != null) {
            registry.dispose();
        }
        this.actionCache.remove(partDescriptor);
        this.actionGroupCache.dispose(partDescriptor);
        this.partDescriptors.remove(partDescriptor);
    }

    public final boolean provides(IOperation operation) {
        if (operation instanceof DisposeContributionsOperation) {
            IWorkbenchPartDescriptor partDescriptor = ((DisposeContributionsOperation)operation).getWorkbenchPartDescriptor();
            return this.actionCache.containsKey(partDescriptor) || this.actionGroupCache.contains(partDescriptor);
        }
        return false;
    }

    protected final IAction getAction(String actionId, IWorkbenchPartDescriptor partDescriptor) {
        IAction action;
        ActionRegistry registry = (ActionRegistry)this.actionCache.get(partDescriptor);
        if (registry == null) {
            registry = new ActionRegistry();
            this.actionCache.put(partDescriptor, registry);
        }
        if ((action = this.getActionFromRegistry(actionId, partDescriptor, registry)) == null) {
            action = this.createAction(actionId, partDescriptor);
            if (action != null) {
                if (action instanceof IDisposableAction) {
                    ((IDisposableAction)action).init();
                }
                registry.registerAction(actionId, action);
            }
        } else if (action instanceof IActionWithProgress) {
            ((IActionWithProgress)action).refresh();
        }
        return action;
    }

    protected final IAction getAction(String actionId, IWorkbenchPartDescriptor partDescriptor, IPartSelector partSelector) {
        boolean actionExistsAlready = false;
        ActionRegistry registry = (ActionRegistry)this.actionCache.get(partDescriptor);
        if (registry != null && this.getActionFromRegistry(actionId, partDescriptor, registry) != null) {
            actionExistsAlready = true;
        }
        IAction result = this.getAction(actionId, partDescriptor);
        if (actionExistsAlready && partSelector instanceof ProviderContributionDescriptor.AbstractPopupContributionItemDescriptor) {
            return result;
        }
        if (result instanceof AbstractActionHandler && partSelector != null) {
            ((AbstractActionHandler)result).setPartSelector(partSelector);
        }
        return result;
    }

    protected final ActionGroup getActionGroup(String actionGroupId, IWorkbenchPartDescriptor partDescriptor) {
        ActionGroup actionGroup = this.actionGroupCache.getActionGroup(actionGroupId, partDescriptor);
        if (actionGroup == null) {
            actionGroup = this.createActionGroup(actionGroupId, partDescriptor);
            this.actionGroupCache.addActionGroup(actionGroupId, actionGroup, partDescriptor);
        }
        return actionGroup;
    }

    protected IAction getActionFromRegistry(String actionId, IWorkbenchPartDescriptor partDescriptor, ActionRegistry registry) {
        return registry.getAction(actionId);
    }

    protected IAction createAction(String actionId, IWorkbenchPartDescriptor partDescriptor) {
        return null;
    }

    protected ActionGroup createActionGroup(String actionGroupId, IWorkbenchPartDescriptor partDescriptor) {
        return null;
    }

    protected IMenuManager createMenuManager(String menuId, IWorkbenchPartDescriptor partDescriptor) {
        return null;
    }

    protected IContributionItem createCustomContributionItem(String customId, IWorkbenchPartDescriptor partDescriptor) {
        return null;
    }

    private IMenuManager findMenuUsingPath(IContributionManager parent, String path) {
        IContributionItem item = null;
        String id = path;
        String rest = null;
        int separator = path.indexOf(47);
        if (separator != -1) {
            id = path.substring(0, separator);
            rest = path.substring(separator + 1);
        } else {
            item = parent.find(path);
            if (item instanceof IMenuManager) {
                return (IMenuManager)item;
            }
        }
        item = parent.find(id);
        if (item instanceof IMenuManager) {
            IMenuManager manager = (IMenuManager)item;
            return manager.findMenuUsingPath(rest);
        }
        return null;
    }

    private void contributeItem(IAdaptable contributionItemAdapter, IContributionManager contributionManager, String path, String group) {
        if (path == null) {
            return;
        }
        IContributionManager parent = contributionManager;
        if (path.length() > 1 && (parent = this.findMenuUsingPath(parent, path.substring(1))) == null) {
            Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The contribution item path is invalid");
            return;
        }
        if (contributionItemAdapter instanceof MenuGroupContributionItemAdapter) {
            IContributionItem contributionItem = (IContributionItem)contributionItemAdapter.getAdapter(IContributionItem.class);
            parent.add(contributionItem);
            return;
        }
        if (contributionItemAdapter instanceof ActionGroupContributionItemAdapter) {
            try {
                ActionGroup actionGroup = (ActionGroup)contributionItemAdapter.getAdapter(ActionGroup.class);
                if (parent instanceof IMenuManager) {
                    actionGroup.fillContextMenu((IMenuManager)parent);
                }
            }
            catch (IllegalArgumentException e) {
                Trace.catching((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIServicesActionPlugin.getDefault())).getClass(), (String)"Error adding contribution item", (Throwable)e);
                Log.error((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"Error adding contribution item", (Throwable)e);
            }
            return;
        }
        if (group == null) {
            return;
        }
        IContributionItem sep = parent.find(group);
        if (sep == null) {
            if (group.equals("additionsGroup")) {
                sep = new Separator(group);
                parent.add(sep);
            }
            if (sep == null) {
                Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The contribution item group is invalid");
                return;
            }
        }
        try {
            IContributionItem contributionItem = (IContributionItem)contributionItemAdapter.getAdapter(IContributionItem.class);
            if (contributionItem != null) {
                if (sep.isGroupMarker()) {
                    parent.appendToGroup(group, contributionItem);
                } else {
                    parent.insertAfter(group, contributionItem);
                }
            } else {
                Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)("Failed to create the contribution with id: " + (String)contributionItemAdapter.getAdapter(String.class)));
            }
        }
        catch (IllegalArgumentException e) {
            Trace.catching((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIServicesActionPlugin.getDefault())).getClass(), (String)"Error adding contribution item", (Throwable)e);
            Log.error((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"Error adding contribution item", (Throwable)e);
        }
    }

    private void contributeItem(IAdaptable contributionItemAdapter, IActionBars actionBars) {
        if (contributionItemAdapter instanceof ActionGroupContributionItemAdapter) {
            try {
                ActionGroup actionGroup = (ActionGroup)contributionItemAdapter.getAdapter(ActionGroup.class);
                actionGroup.fillActionBars(actionBars);
                return;
            }
            catch (IllegalArgumentException e) {
                Trace.catching((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIServicesActionPlugin.getDefault())).getClass(), (String)"Error adding contribution item", (Throwable)e);
                Log.error((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"Error adding contribution item", (Throwable)e);
            }
        }
        Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)("Failed to create the contribution with id: " + (String)contributionItemAdapter.getAdapter(String.class)));
    }

    private void removeExistingItem(String id, String path, IContributionManager contributionManager) {
        if (id == null) {
            return;
        }
        IContributionManager parent = contributionManager;
        if (path.length() > 1 && (parent = this.findMenuUsingPath(contributionManager, path.substring(1))) == null) {
            Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The contribution item path is invalid");
            return;
        }
        IContributionItem predefinedItem = parent.find(id);
        if (predefinedItem == null) {
            Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The contribution item path is invalid");
            return;
        }
        if (predefinedItem instanceof AbstractGroupMarker) {
            IContributionItem[] allItems = parent.getItems();
            int groupIndex = 0;
            while (groupIndex < allItems.length) {
                IContributionItem item = allItems[groupIndex];
                if (item.equals(predefinedItem)) break;
                ++groupIndex;
            }
            int j = groupIndex + 1;
            while (j < allItems.length) {
                IContributionItem item = allItems[j];
                if (item instanceof AbstractGroupMarker) break;
                parent.remove(item);
                ++j;
            }
        }
        parent.remove(predefinedItem);
    }

    private boolean areActivitiesEnabled() {
        if (!WorkbenchActivityHelper.isFiltering()) {
            return true;
        }
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IIdentifier id = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)this.getPluginContribution()));
        return id == null || id.isEnabled();
    }

    void setPluginContribution(IPluginContribution pluginContribution) {
        this.pluginContribution = pluginContribution;
    }

    IPluginContribution getPluginContribution() {
        return this.pluginContribution;
    }

    private class ActionContributionItemAdapter
    implements IAdaptable {
        private String actionId;
        private IWorkbenchPartDescriptor partDescriptor;
        private final IPartSelector partSelector;

        public ActionContributionItemAdapter(String actionId, IWorkbenchPartDescriptor partDescriptor, IPartSelector partSelector) {
            this.actionId = actionId;
            this.partDescriptor = partDescriptor;
            this.partSelector = partSelector;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IContributionItem.class) {
                IAction action = AbstractContributionItemProvider.this.getAction(this.actionId, this.partDescriptor, this.partSelector);
                if (action != null) {
                    return new PluginActionContributionItem(action);
                }
            } else if (adapter == String.class) {
                return this.actionId;
            }
            return null;
        }
    }

    private class ActionGroupContributionItemAdapter
    implements IAdaptable {
        private String menuId;
        private IWorkbenchPartDescriptor partDescriptor;

        public ActionGroupContributionItemAdapter(String menuId, IWorkbenchPartDescriptor partDescriptor) {
            this.menuId = menuId;
            this.partDescriptor = partDescriptor;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ActionGroup.class) {
                return AbstractContributionItemProvider.this.getActionGroup(this.menuId, this.partDescriptor);
            }
            if (adapter == String.class) {
                return this.menuId;
            }
            return null;
        }
    }

    private class CustomContributionItemAdapter
    implements IAdaptable {
        private String customId;
        private IWorkbenchPartDescriptor partDescriptor;

        public CustomContributionItemAdapter(String customId, IWorkbenchPartDescriptor partDescriptor) {
            this.customId = customId;
            this.partDescriptor = partDescriptor;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IContributionItem.class) {
                IContributionItem item = AbstractContributionItemProvider.this.createCustomContributionItem(this.customId, this.partDescriptor);
                return item;
            }
            if (adapter == String.class) {
                return this.customId;
            }
            return null;
        }
    }

    private class MenuContributionItemAdapter
    implements IAdaptable {
        private String menuId;
        private IWorkbenchPartDescriptor partDescriptor;

        public MenuContributionItemAdapter(String menuId, IWorkbenchPartDescriptor partDescriptor) {
            this.menuId = menuId;
            this.partDescriptor = partDescriptor;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IContributionItem.class) {
                IMenuManager manager = AbstractContributionItemProvider.this.createMenuManager(this.menuId, this.partDescriptor);
                if (manager != null) {
                    return new PluginMenuManager(manager);
                }
            } else if (adapter == String.class) {
                return this.menuId;
            }
            return null;
        }
    }

    private class MenuGroupContributionItemAdapter
    implements IAdaptable {
        private String groupId;
        private boolean isSeparator;

        public MenuGroupContributionItemAdapter(String groupId, boolean isSeparator) {
            this.groupId = groupId;
            this.isSeparator = isSeparator;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IContributionItem.class) {
                if (this.isSeparator) {
                    return new PluginSeparator(this.groupId);
                }
                return new PluginGroupMarker(this.groupId);
            }
            if (adapter == String.class) {
                return this.groupId;
            }
            return null;
        }
    }

    private class PluginActionContributionItem
    extends ActionContributionItem {
        public PluginActionContributionItem(IAction action) {
            super(action);
        }

        public boolean isVisible() {
            if (!AbstractContributionItemProvider.this.areActivitiesEnabled()) {
                return false;
            }
            return super.isVisible();
        }
    }

    private class PluginGroupMarker
    extends GroupMarker {
        public PluginGroupMarker(String groupName) {
            super(groupName);
        }

        public boolean isVisible() {
            if (!AbstractContributionItemProvider.this.areActivitiesEnabled()) {
                return false;
            }
            return super.isVisible();
        }
    }

    private class PluginMenuManager
    implements IMenuManager {
        private IMenuManager realMenuManager;

        public PluginMenuManager(IMenuManager menuManager) {
            this.realMenuManager = menuManager;
        }

        public void add(IAction action) {
            this.realMenuManager.add(action);
        }

        public void add(IContributionItem item) {
            this.realMenuManager.add(item);
        }

        public void addMenuListener(IMenuListener listener) {
            this.realMenuManager.addMenuListener(listener);
        }

        public void appendToGroup(String groupName, IAction action) {
            this.realMenuManager.appendToGroup(groupName, action);
        }

        public void appendToGroup(String groupName, IContributionItem item) {
            this.realMenuManager.appendToGroup(groupName, item);
        }

        public void dispose() {
            this.realMenuManager.dispose();
        }

        public void fill(Composite parent) {
            this.realMenuManager.fill(parent);
        }

        public void fill(CoolBar parent, int index) {
            this.realMenuManager.fill(parent, index);
        }

        public void fill(Menu parent, int index) {
            this.realMenuManager.fill(parent, index);
        }

        public void fill(ToolBar parent, int index) {
            this.realMenuManager.fill(parent, index);
        }

        public IContributionItem find(String id) {
            return this.realMenuManager.find(id);
        }

        public IMenuManager findMenuUsingPath(String path) {
            return this.realMenuManager.findMenuUsingPath(path);
        }

        public IContributionItem findUsingPath(String path) {
            return this.realMenuManager.findUsingPath(path);
        }

        public String getId() {
            return this.realMenuManager.getId();
        }

        public IContributionItem[] getItems() {
            return this.realMenuManager.getItems();
        }

        public IContributionManagerOverrides getOverrides() {
            return this.realMenuManager.getOverrides();
        }

        public boolean getRemoveAllWhenShown() {
            return this.realMenuManager.getRemoveAllWhenShown();
        }

        public void insertAfter(String id, IAction action) {
            this.realMenuManager.insertAfter(id, action);
        }

        public void insertAfter(String id, IContributionItem item) {
            this.realMenuManager.insertAfter(id, item);
        }

        public void insertBefore(String id, IAction action) {
            this.realMenuManager.insertBefore(id, action);
        }

        public void insertBefore(String id, IContributionItem item) {
            this.realMenuManager.insertBefore(id, item);
        }

        public boolean isDirty() {
            return this.realMenuManager.isDirty();
        }

        public boolean isDynamic() {
            return this.realMenuManager.isDynamic();
        }

        public boolean isEmpty() {
            return this.realMenuManager.isEmpty();
        }

        public boolean isEnabled() {
            return this.realMenuManager.isEnabled();
        }

        public boolean isGroupMarker() {
            return this.realMenuManager.isGroupMarker();
        }

        public boolean isSeparator() {
            return this.realMenuManager.isSeparator();
        }

        public boolean isVisible() {
            if (!AbstractContributionItemProvider.this.areActivitiesEnabled()) {
                return false;
            }
            return this.realMenuManager.isVisible();
        }

        public void markDirty() {
            this.realMenuManager.markDirty();
        }

        public void prependToGroup(String groupName, IAction action) {
            this.realMenuManager.prependToGroup(groupName, action);
        }

        public void prependToGroup(String groupName, IContributionItem item) {
            this.realMenuManager.prependToGroup(groupName, item);
        }

        public IContributionItem remove(IContributionItem item) {
            return this.realMenuManager.remove(item);
        }

        public IContributionItem remove(String id) {
            return this.realMenuManager.remove(id);
        }

        public void removeAll() {
            this.realMenuManager.removeAll();
        }

        public void removeMenuListener(IMenuListener listener) {
            this.realMenuManager.removeMenuListener(listener);
        }

        public void saveWidgetState() {
            this.realMenuManager.saveWidgetState();
        }

        public void setParent(IContributionManager parent) {
            this.realMenuManager.setParent(parent);
        }

        public void setRemoveAllWhenShown(boolean removeAll) {
            this.realMenuManager.setRemoveAllWhenShown(removeAll);
        }

        public void setVisible(boolean visible) {
            this.realMenuManager.setVisible(visible);
        }

        public void update() {
            this.realMenuManager.update();
        }

        public void update(boolean force) {
            this.realMenuManager.update(force);
        }

        public void update(String id) {
            this.realMenuManager.update(id);
        }

        public void updateAll(boolean force) {
            this.realMenuManager.updateAll(force);
        }
    }

    private class PluginSeparator
    extends Separator {
        public PluginSeparator() {
        }

        public PluginSeparator(String groupName) {
            super(groupName);
        }

        public boolean isVisible() {
            if (!AbstractContributionItemProvider.this.areActivitiesEnabled()) {
                return false;
            }
            return super.isVisible();
        }
    }
}

