/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.drop;

import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.IDropTargetContext;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;

public class DropTargetContext
implements IDropTargetContext {
    protected static final int LOCATION_EPSILON = 5;
    private final IWorkbenchPart activePart;
    protected Object target = null;
    private final Control viewerControl;
    protected Point location = null;
    protected int relativeLocation = 4;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.services.dnd.drop.DropTargetContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DropTargetContext(IWorkbenchPart anActivePart, Control aViewerControl) {
        if (!$assertionsDisabled && anActivePart == null) {
            throw new AssertionError((Object)"anActivePart cannot be null");
        }
        if (!$assertionsDisabled && aViewerControl == null) {
            throw new AssertionError((Object)"aViewerControl cannot be null");
        }
        this.activePart = anActivePart;
        this.viewerControl = aViewerControl;
    }

    public final IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    public final Object getCurrentTarget() {
        return this.target;
    }

    public final Point getCurrentLocation() {
        return this.location;
    }

    public final Control getViewerControl() {
        return this.viewerControl;
    }

    protected void setCurrentTargetAndLocation(DropTargetEvent event) {
        this.target = event.item == null ? null : event.item.getData();
        this.location = this.getViewerControl().toControl(new Point(event.x, event.y));
        if (!(event.item instanceof Item)) {
            this.relativeLocation = 4;
        } else {
            Item item = (Item)event.item;
            Rectangle bounds = null;
            if (item instanceof TreeItem) {
                bounds = ((TreeItem)item).getBounds();
            } else if (item instanceof TableItem) {
                bounds = ((TableItem)item).getBounds(0);
            }
            this.relativeLocation = bounds == null ? 4 : (this.location.y - bounds.y < 5 ? 1 : (bounds.y + bounds.height - this.location.y < 5 ? 2 : 3));
        }
    }

    protected void dragEnter(DropTargetEvent event) {
        event.detail = 0;
    }

    protected void dragOperationChanged(DropTargetEvent event) {
        event.detail = 0;
    }

    protected void dragOver(DropTargetEvent event) {
        event.detail = 0;
    }

    protected void drop(DropTargetEvent event) {
        event.detail = 0;
    }

    protected void dropAccept(DropTargetEvent event) {
        event.detail = 0;
    }

    protected void dragLeave(DropTargetEvent event) {
    }

    public final int getRelativeLocation() {
        return this.relativeLocation;
    }
}

