/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoLibraryConnectorsRegistry;
import org.eclipse.acceleo.common.internal.utils.AcceleoLibrariesEclipseUtil;
import org.eclipse.acceleo.common.internal.utils.AcceleoServicesEclipseUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.library.connector.ILibrary;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;

public class AcceleoCommonPlugin
extends Plugin {
    public static final String LIBRARIES_EXTENSION_POINT = "org.eclipse.acceleo.common.libraries";
    public static final String LIBRARY_CONNECTORS_EXTENSION_POINT = "org.eclipse.acceleo.common.library.connectors";
    public static final String PLUGIN_ID = "org.eclipse.acceleo.common";
    @Deprecated
    public static final String SERVICES_EXTENSION_POINT = "org.eclipse.acceleo.common.java.services";
    private static final String CLASS_TAG_NAME = "class";
    private static final String FILE_EXTENSION_TAG_NAME = "fileExtension";
    private static final String FILE_TAG_NAME = "file";
    private static AcceleoCommonPlugin plugin;
    private BundleContext context;
    private final AcceleoLibraryConnectorsRegistryListener librariesConnectorListener = new AcceleoLibraryConnectorsRegistryListener();
    private final AcceleoLibrariesRegistryListener librariesListener = new AcceleoLibrariesRegistryListener();

    public AcceleoCommonPlugin() {
        plugin = this;
    }

    public static AcceleoCommonPlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e, boolean blocker) {
        if (e == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("AcceleoCommonPlugin.LogNullException"));
        }
        if (AcceleoCommonPlugin.getDefault() == null) {
            e.printStackTrace();
        } else if (e instanceof CoreException) {
            AcceleoCommonPlugin.log(((CoreException)((Object)e)).getStatus());
        } else if (e instanceof NullPointerException) {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoCommonPlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, AcceleoCommonMessages.getString("AcceleoCommonPlugin.ElementNotFound"), (Throwable)e));
        } else {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoCommonPlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, AcceleoCommonMessages.getString("AcceleoCommonPlugin.JavaException"), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        if (status == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("AcceleoCommonPlugin.LogNullStatus"));
        }
        if (AcceleoCommonPlugin.getDefault() != null) {
            AcceleoCommonPlugin.getDefault().getLog().log(status);
        } else {
            System.err.println(status.getMessage());
            status.getException().printStackTrace();
        }
    }

    public static void log(String message, boolean blocker) {
        if (AcceleoCommonPlugin.getDefault() == null) {
            System.err.println(message);
        } else {
            String errorMessage;
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            if ((errorMessage = message) == null || "".equals(errorMessage)) {
                errorMessage = AcceleoCommonMessages.getString("AcceleoCommonPlugin.UnexpectedException");
            }
            AcceleoCommonPlugin.log((IStatus)new Status(severity, PLUGIN_ID, errorMessage));
        }
    }

    public static void log(String message, Exception cause, boolean blocker) {
        int severity = blocker ? 4 : 2;
        AcceleoCommonPlugin.log((IStatus)new Status(severity, PLUGIN_ID, message, (Throwable)cause));
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        AcceleoWorkspaceUtil.INSTANCE.initialize();
        this.context = bundleContext;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this.librariesConnectorListener, LIBRARY_CONNECTORS_EXTENSION_POINT);
        registry.addListener((IRegistryEventListener)this.librariesListener, LIBRARIES_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        this.context = null;
        super.stop(bundleContext);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)this.librariesConnectorListener);
        registry.removeListener((IRegistryEventListener)this.librariesListener);
        AcceleoServicesEclipseUtil.clearRegistry();
        AcceleoLibraryConnectorsRegistry.INSTANCE.clearRegistry();
        AcceleoLibrariesEclipseUtil.clearRegistry();
        AcceleoWorkspaceUtil.INSTANCE.dispose();
    }

    private void parseInitialContributions() {
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(LIBRARY_CONNECTORS_EXTENSION_POINT).getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement service = iConfigurationElementArray[n];
                try {
                    AcceleoLibraryConnectorsRegistry.INSTANCE.addLibraryConnector(service.createExecutableExtension(CLASS_TAG_NAME).getClass(), service.getAttribute(FILE_EXTENSION_TAG_NAME));
                }
                catch (CoreException e) {
                    AcceleoCommonPlugin.log((Exception)((Object)e), false);
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = registry.getExtensionPoint(LIBRARIES_EXTENSION_POINT).getExtensions();
        n3 = iExtensionArray.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement library = iConfigurationElementArray[n];
                String pathToFile = library.getAttribute(FILE_TAG_NAME);
                Class<ILibrary> libClass = AcceleoLibraryConnectorsRegistry.INSTANCE.getConnectorForResource(pathToFile);
                if (libClass != null) {
                    try {
                        ILibrary lib = libClass.newInstance();
                        lib.setURI(URI.createFileURI((String)ResourcesPlugin.getWorkspace().getRoot().getProject(extension.getContributor().getName()).getFile(pathToFile).getLocation().toString()));
                        AcceleoLibrariesEclipseUtil.addLibrary(lib);
                    }
                    catch (InstantiationException e) {
                        AcceleoCommonPlugin.log(e, true);
                    }
                    catch (IllegalAccessException e) {
                        AcceleoCommonPlugin.log(e, true);
                    }
                } else {
                    AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoCommonPlugin.MissingHandle", pathToFile), false);
                }
                ++n;
            }
            ++n4;
        }
    }

    final class AcceleoLibrariesRegistryListener
    implements IRegistryEventListener {
        AcceleoLibrariesRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    String pathToFile = service.getAttribute(AcceleoCommonPlugin.FILE_TAG_NAME);
                    Class<ILibrary> libClass = AcceleoLibraryConnectorsRegistry.INSTANCE.getConnectorForResource(pathToFile);
                    if (libClass != null) {
                        try {
                            ILibrary lib = libClass.newInstance();
                            lib.setURI(URI.createFileURI((String)ResourcesPlugin.getWorkspace().getRoot().getProject(extension.getContributor().getName()).getFile(pathToFile).getLocation().toString()));
                            AcceleoLibrariesEclipseUtil.addLibrary(lib);
                        }
                        catch (InstantiationException e) {
                            AcceleoCommonPlugin.log(e, true);
                        }
                        catch (IllegalAccessException e) {
                            AcceleoCommonPlugin.log(e, true);
                        }
                    } else {
                        AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoCommonPlugin.MissingHandle", pathToFile), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    AcceleoLibrariesEclipseUtil.removeLibrary(service.getAttribute(AcceleoCommonPlugin.FILE_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }

    final class AcceleoLibraryConnectorsRegistryListener
    implements IRegistryEventListener {
        AcceleoLibraryConnectorsRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    try {
                        AcceleoLibraryConnectorsRegistry.INSTANCE.addLibraryConnector(service.createExecutableExtension(AcceleoCommonPlugin.CLASS_TAG_NAME).getClass(), service.getAttribute(AcceleoCommonPlugin.FILE_EXTENSION_TAG_NAME));
                    }
                    catch (CoreException e) {
                        AcceleoCommonPlugin.log((Exception)((Object)e), false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement service = iConfigurationElementArray[n4];
                    AcceleoLibraryConnectorsRegistry.INSTANCE.removeLibraryConnector(service.getAttribute(AcceleoCommonPlugin.CLASS_TAG_NAME));
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }
}

