/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.relations.atlvm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreter;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.qvt.declarative.common.framework.service.Operation;
import org.eclipse.qvt.declarative.execution.ExecuteOperation;
import org.eclipse.qvt.declarative.execution.ExecutionContext;
import org.eclipse.qvt.declarative.execution.ExecutionProvider;
import org.eclipse.qvt.declarative.execution.LabelledModel;
import org.eclipse.qvt.declarative.execution.QVTRealtionsExecutionException;
import org.eclipse.qvt.declarative.relations.atlvm.utils.ASMEMFModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATLVMExecutor
implements ExecutionProvider {
    private static final String DEFAULT_DEBUGGER_PROPERTIES_LOCATION = "debugger.properties.xml";
    private static final Debugger DEFAULT_DEBUGGER = ATLVMExecutor.createDefaultDebugger();
    private static final String STEP_PROPERTY = "step";
    private static final String SHOW_SUMMARY_PROPERTY = "showSummary";
    private static final String PROFILE_PROPERTY = "profile";
    private static final String CONTINUE_AFTER_ERROR_PROPERTY = "continueAfterError";

    private static Debugger createDefaultDebugger() {
        Properties debuggerProperties = new Properties();
        URL debuggerPropertiesURL = ATLVMExecutor.class.getResource(DEFAULT_DEBUGGER_PROPERTIES_LOCATION);
        try {
            debuggerProperties.loadFromXML(debuggerPropertiesURL.openStream());
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean showSummary = Boolean.toString(true).equals(debuggerProperties.get(SHOW_SUMMARY_PROPERTY));
        boolean profile = Boolean.toString(true).equals(debuggerProperties.get(PROFILE_PROPERTY));
        boolean continueAfterError = Boolean.toString(true).equals(debuggerProperties.get(CONTINUE_AFTER_ERROR_PROPERTY));
        SimpleDebugger result = new SimpleDebugger(Boolean.toString(true).equals(debuggerProperties.get(STEP_PROPERTY)), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true, showSummary, profile, continueAfterError);
        return result;
    }

    public boolean provides(Operation operation) {
        return operation instanceof ExecuteOperation;
    }

    public List<?> execute(File executableFile, ExecutionContext parameters) throws QVTRealtionsExecutionException {
        ASM qvtrTransformation;
        HashMap<String, String> transformationParameters = new HashMap<String, String>();
        boolean isCheckOnly = parameters.getMode() == ExecutionContext.ExecutionMode.checkOnly;
        transformationParameters.put("checkOnly", Boolean.toString(isCheckOnly));
        ArrayList<ASMEMFModel> linkedModels = new ArrayList<ASMEMFModel>();
        try {
            for (LabelledModel namedModel : parameters.getSourceModels()) {
                linkedModels.add(ASMEMFModelUtils.getASMEMFModelFrom(namedModel, false));
            }
            LabelledModel directionNamedModel = parameters.getDirectionModel();
            linkedModels.add(ASMEMFModelUtils.getASMEMFModelFrom(directionNamedModel, true));
        }
        catch (Exception e) {
            String message = "Unable to load models into the ATLVM \n" + e.getMessage();
            throw new QVTRealtionsExecutionException(message);
        }
        try {
            qvtrTransformation = new ASMXMLReader().read((InputStream)new BufferedInputStream(new FileInputStream(executableFile)));
        }
        catch (FileNotFoundException e) {
            String message = "Unable to load ASM code in the ATLVM \n" + e.getMessage();
            throw new QVTRealtionsExecutionException(message);
        }
        Object result = this.execute(qvtrTransformation, linkedModels, Collections.<ASM>emptyList(), transformationParameters, DEFAULT_DEBUGGER);
        for (ASMEMFModel model : linkedModels) {
            HashMap<String, Boolean> serializationParameters = new HashMap<String, Boolean>();
            URI metamodelURI = ((ASMEMFModel)model.getMetamodel()).getExtent().getURI();
            if (metamodelURI.isFile()) {
                serializationParameters.put("SCHEMA_LOCATION", Boolean.TRUE);
            }
            try {
                model.getExtent().save(serializationParameters);
            }
            catch (IOException e) {
                String message = "Unable to save the model \n" + e.getMessage();
                throw new QVTRealtionsExecutionException(message);
            }
        }
        return Collections.singletonList(result);
    }

    protected Object execute(ASM qvtrTransformation, List<ASMEMFModel> linkedModels, List<ASM> libraries, Map<String, String> parameters, Debugger debugger) throws QVTRealtionsExecutionException {
        ASMModule asmModule = new ASMModule(qvtrTransformation);
        ASMExecEnv env = new ASMExecEnv(asmModule, debugger, true);
        env.addPermission("file.read");
        env.addPermission("file.write");
        for (ASMEMFModel model : linkedModels) {
            env.addModel(model.getMetamodel().getName(), model.getMetamodel());
            env.addModel(model.getName(), (ASMModel)model);
        }
        env.registerOperations(qvtrTransformation);
        for (ASM asm : libraries) {
            env.registerOperations(asm);
        }
        try {
            new ASMInterpreter(qvtrTransformation, asmModule, env, parameters);
        }
        catch (Exception e) {
            String message = "Problem interpreting the compiled transformation \n" + e.getMessage();
            throw new QVTRealtionsExecutionException(message);
        }
        return linkedModels.get(linkedModels.size() - 1);
    }
}

