/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.CyclicScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractScheduledRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeDomain;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativeFactory;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class CyclicScheduledRegion2Mapping
extends AbstractScheduledRegion2Mapping {
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull RecursionContext> classDatumAnalysis2recursion = new HashMap<ClassDatumAnalysis, RecursionContext>();
    private boolean allRecursionsAreUnique = false;
    private final @NonNull Map<@NonNull TypedModel, @NonNull ImperativeDomain> typedModel2domain = new HashMap<TypedModel, ImperativeDomain>();

    public CyclicScheduledRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull CyclicScheduledRegion region) {
        super(visitor, region);
        for (Node headNode : region.getHeadNodes()) {
            RecursionContext newRecursion = new RecursionContext(headNode);
            RecursionContext oldRecursion = this.classDatumAnalysis2recursion.put(newRecursion.getClassDatumAnalysis(), newRecursion);
            assert (oldRecursion == null);
        }
        for (NodeConnection accumulatedConnection : region.getIntermediateConnections()) {
            ClassDatumAnalysis classDatumAnalysis = accumulatedConnection.getClassDatumAnalysis();
            RecursionContext recursion = this.classDatumAnalysis2recursion.get(classDatumAnalysis);
            if (recursion == null) continue;
            recursion.setAccumulatedConnection(accumulatedConnection);
        }
        this.createConnectionGuardVariables();
    }

    @Override
    protected void createConnectionGuardVariables() {
        List<@NonNull NodeConnection> intermediateConnections = this.region.getIntermediateConnections();
        for (NodeConnection intermediateConnection : intermediateConnections) {
            Variable connectionVariable = (Variable)this.connection2variable.get(intermediateConnection);
            if (connectionVariable != null) continue;
            String name = intermediateConnection.getName();
            assert (name != null);
            connectionVariable = this.helper.createConnectionVariable(name, this.getConnectionSourcesType(intermediateConnection), null);
            this.connection2variable.put(intermediateConnection, connectionVariable);
            this.mapping.getGuardPattern().getVariable().add((Object)connectionVariable);
        }
    }

    @Override
    public @NonNull MappingCall createMappingCall(@NonNull List<@NonNull MappingCallBinding> mappingCallBindings) {
        MappingCall mappingCall = super.createMappingCall(mappingCallBindings);
        if (!this.allRecursionsAreUnique) {
            mappingCall.setIsInfinite(true);
        }
        return mappingCall;
    }

    @Override
    protected @NonNull OCLExpression createSelectByKind(@NonNull Node resultNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createStatements() {
        ConnectionVariable newVariable;
        MappingStatement mappingStatement = null;
        for (Region callableRegion : this.region.getCallableChildren()) {
            AbstractRegion2Mapping calledRegion2Mapping = this.visitor.getRegion2Mapping(callableRegion);
            HashMap<@NonNull Variable, @NonNull OCLExpression> guardVariable2expression = new HashMap<Variable, OCLExpression>();
            for (Node calledHeadNode : callableRegion.getHeadNodes()) {
                NodeConnection headConnection = calledHeadNode.getIncomingConnection();
                assert (headConnection != null);
                Node callingHeadNode = (Node)Iterables.get(headConnection.getSourceNodes(), (int)0);
                Variable callingHeadVariable = this.getGuardVariable(callingHeadNode);
                Variable calledHeadVariable = calledRegion2Mapping.getGuardVariable(calledHeadNode);
                guardVariable2expression.put(calledHeadVariable, (OCLExpression)PivotUtil.createVariableExp((Variable)callingHeadVariable));
            }
            for (NodeConnection intermediateConnection : callableRegion.getIntermediateConnections()) {
                RecursionContext recursion = this.classDatumAnalysis2recursion.get(intermediateConnection.getClassDatumAnalysis());
                if (recursion == null) continue;
                ConnectionVariable callingLocalVariable = recursion.getLocalVariable();
                Variable calledTailVariable = calledRegion2Mapping.getConnectionVariable(intermediateConnection);
                guardVariable2expression.put(calledTailVariable, (OCLExpression)PivotUtil.createVariableExp((Variable)callingLocalVariable));
            }
            mappingStatement = this.createCall(mappingStatement, callableRegion, guardVariable2expression);
        }
        for (RecursionContext recursion : this.classDatumAnalysis2recursion.values()) {
            ConnectionVariable accumulatedVariable = recursion.getAccumulatedVariable();
            if (accumulatedVariable == null) continue;
            ConnectionVariable localVariable = recursion.getLocalVariable();
            newVariable = recursion.getNewVariable();
            if (newVariable != null) {
                ParametersId parametersId = IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.COLLECTION.getSpecializedId(new ElementId[]{TypeId.OCL_ANY})});
                OperationId operationId = TypeId.COLLECTION.getOperationId(1, "excludingAll", parametersId);
                Operation operation = this.visitor.getEnvironmentFactory().getIdResolver().getOperation(operationId);
                VariableExp localVariableExp = PivotUtil.createVariableExp((Variable)localVariable);
                VariableExp resultVariableExp = PivotUtil.createVariableExp((Variable)accumulatedVariable);
                OperationCallExp excludingAllCallExp = PivotUtil.createOperationCallExp((OCLExpression)localVariableExp, (Operation)operation, (OCLExpression[])new OCLExpression[]{resultVariableExp});
                excludingAllCallExp.setType(localVariableExp.getType());
                excludingAllCallExp.setIsRequired(localVariableExp.isIsRequired());
                ConnectionStatement connectionStatement1 = QVTimperativeFactory.eINSTANCE.createConnectionStatement();
                connectionStatement1.setTargetVariable(newVariable);
                connectionStatement1.setValue((OCLExpression)excludingAllCallExp);
                mappingStatement = QVTimperativeUtil.addMappingStatement((MappingStatement)mappingStatement, (MappingStatement)connectionStatement1);
            } else {
                newVariable = localVariable;
            }
            ConnectionStatement connectionStatement2 = QVTimperativeFactory.eINSTANCE.createConnectionStatement();
            connectionStatement2.setTargetVariable(accumulatedVariable);
            connectionStatement2.setValue((OCLExpression)PivotUtil.createVariableExp((Variable)newVariable));
            mappingStatement = QVTimperativeUtil.addMappingStatement((MappingStatement)mappingStatement, (MappingStatement)connectionStatement2);
        }
        HashMap<@NonNull Variable, @NonNull OCLExpression> guardVariable2expression = new HashMap<Variable, OCLExpression>();
        for (RecursionContext recursion : this.classDatumAnalysis2recursion.values()) {
            Variable guardVariable = recursion.getGuardVariable();
            newVariable = recursion.getNewVariable();
            if (newVariable == null) {
                newVariable = recursion.getLocalVariable();
            }
            VariableExp localVariableExp = PivotUtil.createVariableExp((Variable)newVariable);
            guardVariable2expression.put(guardVariable, (OCLExpression)localVariableExp);
        }
        mappingStatement = this.createCall(mappingStatement, this.region, guardVariable2expression);
        this.mapping.setMappingStatement(mappingStatement);
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return this.getHeadNodes();
    }

    public @NonNull GuardPattern getGuardPattern(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        GuardPattern guardPattern;
        TypedModel typedModel = this.visitor.getQVTiTypedModel(classDatumAnalysis.getTypedModel());
        if (typedModel != null) {
            ImperativeDomain domain = this.typedModel2domain.get(typedModel);
            if (domain == null) {
                domain = QVTimperativeUtil.createImperativeDomain((TypedModel)typedModel);
                domain.setIsCheckable(true);
                this.mapping.getDomain().add((Object)domain);
                this.typedModel2domain.put(typedModel, domain);
            }
            guardPattern = domain.getGuardPattern();
        } else {
            guardPattern = this.mapping.getGuardPattern();
        }
        assert (guardPattern != null);
        return guardPattern;
    }

    @Override
    public @NonNull Variable getGuardVariable(@NonNull Node node) {
        assert (this.getHeadNodes().contains(node));
        ClassDatumAnalysis classDatumAnalysis = node.getClassDatumAnalysis();
        RecursionContext recursion = this.classDatumAnalysis2recursion.get(classDatumAnalysis);
        assert (recursion != null);
        return recursion.getGuardVariable();
    }

    private @NonNull List<@NonNull Node> getHeadNodes() {
        return this.region.getHeadNodes();
    }

    private class RecursionContext {
        private final @NonNull ClassDatumAnalysis classDatumAnalysis;
        private final int index;
        private NodeConnection accumulatedConnection;
        private final @NonNull Variable guardVariable;
        private final @NonNull ConnectionVariable localVariable;
        private @Nullable ConnectionVariable newVariable;
        private ConnectionVariable accumulatedVariable;

        public RecursionContext(Node headNode) {
            this.classDatumAnalysis = headNode.getClassDatumAnalysis();
            this.index = CyclicScheduledRegion2Mapping.this.classDatumAnalysis2recursion.size();
            GuardPattern guardPattern = CyclicScheduledRegion2Mapping.this.getGuardPattern(this.classDatumAnalysis);
            Class elementType = this.classDatumAnalysis.getCompleteClass().getPrimaryClass();
            this.guardVariable = PivotUtil.createVariable((String)CyclicScheduledRegion2Mapping.this.getSafeName(headNode), (Type)elementType, (boolean)false, null);
            guardPattern.getVariable().add((Object)this.guardVariable);
            Iterable<@NonNull NodeConnection> outgoingConnections = headNode.getOutgoingPassedConnections();
            assert (Iterables.size(outgoingConnections) == 1);
            NodeConnection outgoingConnection = (NodeConnection)Iterables.get(outgoingConnections, (int)0);
            NodeConnection incomingConnection = headNode.getIncomingPassedConnection();
            assert (incomingConnection != null);
            CyclicScheduledRegion2Mapping.this.connection2variable.put(incomingConnection, this.guardVariable);
            Type asType = CyclicScheduledRegion2Mapping.this.getConnectionSourcesType(incomingConnection);
            String localName = "\u00ablocal" + (this.index > 0 ? Integer.toString(this.index) : "") + "\u00bb";
            this.localVariable = CyclicScheduledRegion2Mapping.this.helper.createConnectionVariable(localName, asType, null);
            CyclicScheduledRegion2Mapping.this.mapping.getBottomPattern().getVariable().add((Object)this.localVariable);
            CyclicScheduledRegion2Mapping.this.connection2variable.put(outgoingConnection, this.localVariable);
            if (asType instanceof CollectionType && ((CollectionType)asType).isUnique()) {
                String newName = "\u00abnew" + (this.index > 0 ? Integer.toString(this.index) : "") + "\u00bb";
                ConnectionVariable newVariable2 = this.newVariable = CyclicScheduledRegion2Mapping.this.helper.createConnectionVariable(newName, asType, null);
                CyclicScheduledRegion2Mapping.this.mapping.getBottomPattern().getVariable().add((Object)newVariable2);
                CyclicScheduledRegion2Mapping.this.connection2variable.put(outgoingConnection, newVariable2);
            } else {
                CyclicScheduledRegion2Mapping.this.allRecursionsAreUnique = false;
            }
        }

        public @Nullable NodeConnection getAccumulatedConnection() {
            return this.accumulatedConnection;
        }

        public @Nullable ConnectionVariable getAccumulatedVariable() {
            return this.accumulatedVariable;
        }

        public @NonNull ClassDatumAnalysis getClassDatumAnalysis() {
            return this.classDatumAnalysis;
        }

        public @NonNull Variable getGuardVariable() {
            return this.guardVariable;
        }

        public @NonNull ConnectionVariable getLocalVariable() {
            return this.localVariable;
        }

        public @Nullable ConnectionVariable getNewVariable() {
            return this.newVariable;
        }

        public void setAccumulatedConnection(@NonNull NodeConnection accumulatedConnection) {
            this.accumulatedConnection = accumulatedConnection;
            NodeConnection intermediateConnection = accumulatedConnection;
            ConnectionVariable accumulatedVariable2 = this.accumulatedVariable = CyclicScheduledRegion2Mapping.this.createConnectionVariable(intermediateConnection);
            CyclicScheduledRegion2Mapping.this.mapping.getGuardPattern().getVariable().add((Object)accumulatedVariable2);
            CyclicScheduledRegion2Mapping.this.connection2variable.put(intermediateConnection, accumulatedVariable2);
        }
    }
}

