/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtext.util.ReplaceRegion;

public class ReconcilerReplaceRegion
extends ReplaceRegion
implements IRegion {
    private long modificationStamp;
    private List<DocumentEvent> events;

    public ReconcilerReplaceRegion(int offset, int length, String text) {
        super(offset, length, text);
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    public void setModificationStamp(long docModificationStampAfter) {
        this.modificationStamp = docModificationStampAfter;
    }

    public void addDocumentEvent(DocumentEvent event) {
        if (this.events == null) {
            this.events = Lists.newArrayList();
        }
        this.events.add(event);
    }

    public List<DocumentEvent> getDocumentEvents() {
        return this.events == null ? Collections.emptyList() : this.events;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ReconcilerReplaceRegion other = (ReconcilerReplaceRegion)((Object)object);
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getText() == null ? other.getText() != null : !this.getText().equals(other.getText())) {
            return false;
        }
        return this.modificationStamp == other.modificationStamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getOffset();
        result = 31 * result + this.getLength();
        result = 31 * result + (this.getText() == null ? 0 : this.getText().hashCode());
        result = 31 * result + (int)(this.modificationStamp % Integer.MAX_VALUE);
        return result;
    }

    public String toString() {
        return "ReconcilerReplaceRegion [" + this.getOffset() + ":" + this.getLength() + "] '" + this.getText() + "' modificationStamp:" + this.getModificationStamp();
    }

    public static Builder builder(String text) {
        return new Builder(text);
    }

    public static class Builder {
        private StringBuilder text;
        private boolean isEmpty;
        private int currentOffset;
        private int currentLength;
        private int currentReplacementOffset;
        private int currentReplacementLength;

        protected Builder(String text) {
            this.text = new StringBuilder(text);
            this.isEmpty = true;
        }

        public Builder add(int nextOffset, int nextLength, String nextReplacement) {
            if (this.isEmpty) {
                this.isEmpty = false;
                this.currentOffset = nextOffset;
                this.currentLength = nextLength;
                this.currentReplacementOffset = nextOffset;
                this.currentReplacementLength = nextReplacement.length();
                this.text.replace(nextOffset, nextOffset + nextLength, nextReplacement);
            } else {
                int currentEnd = this.currentOffset + this.currentReplacementLength;
                int nextEnd = nextOffset + nextLength;
                int newOffset = Math.min(this.currentOffset, nextOffset);
                int newLength = nextLength;
                int prefixSize = 0;
                int postfixSize = 0;
                if (nextOffset >= this.currentOffset) {
                    prefixSize = nextOffset - this.currentOffset;
                    if (nextEnd <= currentEnd) {
                        newLength = this.currentLength;
                        postfixSize = currentEnd - nextEnd;
                    } else {
                        newLength = nextOffset < currentEnd ? this.currentLength + nextLength - (currentEnd - nextOffset) : this.currentLength + (nextOffset - currentEnd) + nextLength;
                    }
                } else if (nextEnd <= this.currentOffset) {
                    newLength = nextLength + (this.currentOffset - nextEnd) + this.currentLength;
                    postfixSize = currentEnd - nextEnd;
                } else if (nextEnd <= currentEnd) {
                    newLength = this.currentLength + nextLength - (nextEnd - this.currentOffset);
                    postfixSize = currentEnd - nextEnd;
                } else {
                    newLength = nextLength + this.currentLength - this.currentReplacementLength;
                }
                this.currentOffset = newOffset;
                this.currentLength = newLength;
                this.text.replace(nextOffset, nextOffset + nextLength, nextReplacement);
                this.currentReplacementOffset = nextOffset - prefixSize;
                this.currentReplacementLength = nextReplacement.length() + prefixSize + postfixSize;
            }
            return this;
        }

        public ReconcilerReplaceRegion create() {
            String currentReplacement = this.text.substring(this.currentReplacementOffset, this.currentReplacementOffset + this.currentReplacementLength);
            return new ReconcilerReplaceRegion(this.currentOffset, this.currentLength, currentReplacement);
        }
    }
}

