/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.typesystem.conformance.SuperTypeAcceptor;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithNonNullResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndNonNullResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class LightweightTypeReference {
    private ITypeReferenceOwner owner;

    protected LightweightTypeReference(ITypeReferenceOwner owner) {
        this.owner = (ITypeReferenceOwner)Preconditions.checkNotNull((Object)owner, (Object)"owner");
    }

    public List<LightweightTypeReference> getTypeArguments() {
        return Collections.emptyList();
    }

    public boolean isResolved() {
        return true;
    }

    public ITypeReferenceOwner getOwner() {
        return this.owner;
    }

    protected TypesFactory getTypesFactory() {
        return this.getOwner().getServices().getTypesFactory();
    }

    protected CommonTypeComputationServices getServices() {
        return this.getOwner().getServices();
    }

    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (this.isResolved()) {
            return true;
        }
        return owner == this.getOwner();
    }

    protected <T> List<T> expose(@Nullable List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public abstract JvmTypeReference toTypeReference();

    public final JvmTypeReference toJavaCompliantTypeReference() {
        return this.toJavaCompliantTypeReference(IVisibilityHelper.ALL);
    }

    public abstract boolean isVisible(IVisibilityHelper var1);

    public abstract JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper var1);

    protected JvmTypeReference toJavaCompliantTypeReference(List<LightweightTypeReference> types, IVisibilityHelper visibilityHelper) {
        LightweightTypeReference type = this.getServices().getTypeConformanceComputer().getCommonSuperType(types, this.getOwner());
        if (type == null) {
            return this.getOwner().getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)this.getOwner().getContextResourceSet(), new JvmTypeReference[0]);
        }
        return type.toJavaCompliantTypeReference(visibilityHelper);
    }

    @Nullable
    protected List<LightweightTypeReference> getNonInterfaceTypes(List<LightweightTypeReference> components) {
        ArrayList nonInterfaceTypes = null;
        for (LightweightTypeReference component : components) {
            if (component.isInterfaceType()) continue;
            if (nonInterfaceTypes == null) {
                nonInterfaceTypes = Collections.singletonList(component);
                continue;
            }
            if (nonInterfaceTypes.size() == 1) {
                nonInterfaceTypes = Lists.newArrayList(nonInterfaceTypes);
                nonInterfaceTypes.add(component);
                continue;
            }
            nonInterfaceTypes.add(component);
        }
        return nonInterfaceTypes;
    }

    @Nullable
    public abstract JvmType getType();

    public LightweightTypeReference getWrapperTypeIfPrimitive() {
        return this;
    }

    public LightweightTypeReference getPrimitiveIfWrapperType() {
        return this;
    }

    public List<JvmType> getRawTypes() {
        return this.getServices().getRawTypeHelper().getAllRawTypes(this, this.getOwner().getContextResourceSet());
    }

    public LightweightTypeReference getRawTypeReference() {
        return this.getServices().getRawTypeHelper().getRawTypeReference(this, this.getOwner().getContextResourceSet());
    }

    public LightweightTypeReference getUpperBoundSubstitute() {
        return this;
    }

    public LightweightTypeReference getLowerBoundSubstitute() {
        return this;
    }

    public LightweightTypeReference getInvariantBoundSubstitute() {
        return this;
    }

    public final boolean isRawType() {
        return this.isRawType(Sets.newHashSetWithExpectedSize((int)1));
    }

    protected boolean isRawType(Set<JvmType> seenTypes) {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAny() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isValidHint() {
        return !this.isAny() && !this.isPrimitiveVoid();
    }

    @Nullable
    public LightweightTypeReference tryConvertToListType() {
        return null;
    }

    @Nullable
    public LightweightTypeReference getComponentType() {
        return null;
    }

    public List<LightweightTypeReference> getSuperTypes() {
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor();
        return this.getSuperTypes(substitutor);
    }

    @Nullable
    public LightweightTypeReference getSuperType(JvmType rawType) {
        return null;
    }

    public List<LightweightTypeReference> getAllSuperTypes() {
        ArrayList result = Lists.newArrayList();
        HashMultiset distances = HashMultiset.create((int)7);
        HashMultiset counterPerType = HashMultiset.create((int)7);
        this.collectSuperTypes(new SuperTypeAcceptor((Multiset)counterPerType, (Multiset)distances, result){
            int counter = 0;
            private final /* synthetic */ Multiset val$counterPerType;
            private final /* synthetic */ Multiset val$distances;
            private final /* synthetic */ List val$result;
            {
                this.val$counterPerType = multiset;
                this.val$distances = multiset2;
                this.val$result = list;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(LightweightTypeReference superType, int distance) {
                JvmType type = superType.getType();
                this.val$counterPerType.add((Object)type, this.counter++);
                if (this.val$distances.contains((Object)type)) {
                    int currentCount = this.val$distances.count((Object)type);
                    if (currentCount >= distance + 1) return false;
                    this.val$distances.setCount((Object)type, distance + 1);
                    return true;
                } else {
                    this.val$result.add(superType);
                    this.val$distances.add((Object)type, distance + 1);
                }
                return true;
            }
        });
        Collections.sort(result, new Comparator<LightweightTypeReference>((Multiset)distances, (Multiset)counterPerType){
            private final /* synthetic */ Multiset val$distances;
            private final /* synthetic */ Multiset val$counterPerType;
            {
                this.val$distances = multiset;
                this.val$counterPerType = multiset2;
            }

            @Override
            public int compare(@Nullable LightweightTypeReference o1, @Nullable LightweightTypeReference o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException();
                }
                JvmType type1 = o1.getType();
                JvmType type2 = o2.getType();
                if (type1 == null) {
                    return 1;
                }
                if (type2 == null) {
                    return -1;
                }
                int distanceCompare = Ints.compare((int)this.val$distances.count((Object)type1), (int)this.val$distances.count((Object)type2));
                if (distanceCompare != 0) {
                    return distanceCompare;
                }
                return Ints.compare((int)this.val$counterPerType.count((Object)type1), (int)this.val$counterPerType.count((Object)type2));
            }
        });
        return result;
    }

    protected TypeParameterSubstitutor<?> createSubstitutor() {
        DeclaratorTypeArgumentCollector collector = new DeclaratorTypeArgumentCollector();
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping = collector.getTypeParameterMapping(this);
        UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(mapping, this.getOwner());
        return substitutor;
    }

    protected abstract List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> var1);

    public void collectSuperTypes(SuperTypeAcceptor acceptor) {
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"LightweightTypeReference#collectSuperTypes");
        try {
            task.start();
            TypeParameterSubstitutor<?> substitutor = this.createSubstitutor();
            List<LightweightTypeReference> superTypes = this.getSuperTypes(substitutor);
            this.collectSuperTypes(1, superTypes, substitutor, acceptor, Sets.newHashSet((Object[])new JvmType[]{this.getType()}));
        }
        finally {
            task.stop();
        }
    }

    protected void collectSuperTypes(int level, List<LightweightTypeReference> references, TypeParameterSubstitutor<?> substitutor, SuperTypeAcceptor acceptor, Set<JvmType> seenTypes) {
        for (LightweightTypeReference reference : references) {
            if (!acceptor.accept(reference, level) || !seenTypes.add(reference.getType())) continue;
            this.collectSuperTypes(level + 1, reference.getSuperTypes(substitutor), substitutor, acceptor, seenTypes);
        }
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isWrapper() {
        return false;
    }

    public boolean isPrimitiveVoid() {
        return this.isType(Void.TYPE);
    }

    public boolean isAssignableFrom(LightweightTypeReference reference) {
        TypeConformanceComputationArgument argument = new TypeConformanceComputationArgument();
        return this.isAssignableFrom(reference, argument);
    }

    public boolean isAssignableFrom(LightweightTypeReference reference, TypeConformanceComputationArgument argument) {
        TypeConformanceResult result = this.internalIsAssignableFrom(reference, argument);
        return result.isConformant();
    }

    public TypeConformanceResult internalIsAssignableFrom(LightweightTypeReference reference, TypeConformanceComputationArgument argument) {
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"LightweightTypeReference#internalIsAssignableFrom");
        try {
            TypeConformanceResult result;
            task.start();
            TypeConformanceComputer conformanceCompouter = this.getOwner().getServices().getTypeConformanceComputer();
            TypeConformanceResult typeConformanceResult = result = conformanceCompouter.isConformant(this, reference, argument);
            return typeConformanceResult;
        }
        finally {
            task.stop();
        }
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        if (this.isType(clazz)) {
            return true;
        }
        JvmType type = this.findType(clazz);
        if (type == null) {
            return false;
        }
        return this.isAssignableFrom(type);
    }

    public boolean isAssignableFrom(JvmType type) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        ParameterizedTypeReference other = new ParameterizedTypeReference(this.getOwner(), type);
        boolean result = this.isAssignableFrom(other);
        return result;
    }

    public boolean isSubtypeOf(Class<?> clazz) {
        if (this.isType(clazz)) {
            return true;
        }
        JvmType type = this.findType(clazz);
        if (type == null) {
            return false;
        }
        return this.isSubtypeOf(type);
    }

    public boolean isSubtypeOf(JvmType type) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        ParameterizedTypeReference other = new ParameterizedTypeReference(this.getOwner(), type);
        boolean result = other.isAssignableFrom(this);
        return result;
    }

    public LightweightTypeReference copyInto(ITypeReferenceOwner owner) {
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"LightweightTypeReference.copyInto");
        try {
            task.start();
            if (this.isOwnedBy(owner)) {
                LightweightTypeReference lightweightTypeReference = this;
                return lightweightTypeReference;
            }
            LightweightTypeReference lightweightTypeReference = this.doCopyInto(owner);
            return lightweightTypeReference;
        }
        finally {
            task.stop();
        }
    }

    protected abstract LightweightTypeReference doCopyInto(ITypeReferenceOwner var1);

    public final String toString() {
        return this.getSimpleName();
    }

    public abstract String getSimpleName();

    public abstract String getIdentifier();

    public abstract String getJavaIdentifier();

    @Nullable
    protected JvmType findType(Class<?> type) {
        return this.getServices().getTypeReferences().findDeclaredType(type, (Notifier)this.getOwner().getContextResourceSet());
    }

    protected JvmType findNonNullType(Class<?> type) {
        JvmType result = this.findType(type);
        if (result == null) {
            throw new IllegalStateException("Cannot find type " + type);
        }
        return result;
    }

    public abstract boolean isType(Class<?> var1);

    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitTypeReference(this);
    }

    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitTypeReference(this, param);
    }

    @Nullable
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitTypeReference(this);
    }

    @Nullable
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitTypeReference(this, param);
    }

    public <Result> Result accept(TypeReferenceVisitorWithNonNullResult<Result> visitor) {
        Result result = this.accept((TypeReferenceVisitorWithResult<Result>)visitor);
        if (result == null) {
            throw new IllegalStateException("result may not be null");
        }
        return result;
    }

    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndNonNullResult<Param, Result> visitor, Param param) {
        Result result = this.accept((TypeReferenceVisitorWithParameterAndResult<Param, Result>)visitor, param);
        if (result == null) {
            throw new IllegalStateException("result may not be null");
        }
        return result;
    }

    public CompoundTypeReference toMultiType(LightweightTypeReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference may not be null");
        }
        CompoundTypeReference result = new CompoundTypeReference(reference.getOwner(), false);
        result.addComponent(this.copyInto(result.getOwner()));
        result.addComponent(reference);
        return result;
    }

    public boolean isFunctionType() {
        return this.getFunctionTypeKind() != FunctionTypeKind.NONE;
    }

    protected boolean isInterfaceType() {
        return false;
    }

    public FunctionTypeKind getFunctionTypeKind() {
        return FunctionTypeKind.NONE;
    }

    @Nullable
    public FunctionTypeReference getAsFunctionTypeReference() {
        return null;
    }

    @Nullable
    public FunctionTypeReference tryConvertToFunctionTypeReference(boolean rawType) {
        return null;
    }

    @Nullable
    public ArrayTypeReference tryConvertToArray() {
        return null;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean isMultiType() {
        return false;
    }

    public LightweightTypeReference toJavaType() {
        return this;
    }

    public List<LightweightTypeReference> getMultiTypeComponents() {
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdentifierFunction
    implements Function<LightweightTypeReference, String> {
        public String apply(@Nullable LightweightTypeReference reference) {
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            return reference.getIdentifier();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaIdentifierFunction
    implements Function<LightweightTypeReference, String> {
        public String apply(@Nullable LightweightTypeReference reference) {
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            return reference.getJavaIdentifier();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleNameFunction
    implements Function<LightweightTypeReference, String> {
        public String apply(@Nullable LightweightTypeReference reference) {
            if (reference == null) {
                throw new NullPointerException("reference");
            }
            return reference.getSimpleName();
        }
    }
}

