/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;
import org.eclipse.xtext.validation.ConfigurableIssueCodesProvider;

@Singleton
public class XtendPreferenceStoreInitializer
implements IPreferenceStoreInitializer,
IPropertyChangeListener {
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    private ConfigurableIssueCodesProvider issueCodes;

    public void initialize(IPreferenceStoreAccess preferenceStoreAccess) {
        this.preferenceStoreAccess = preferenceStoreAccess;
        this.setupIssueCodesDefaults(preferenceStoreAccess);
        IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        preferenceStoreAccess.getWritablePreferenceStore().setDefault("subWordNavigation", preferenceStore.getBoolean("subWordNavigation"));
    }

    private void setupIssueCodesDefaults(IPreferenceStoreAccess preferenceStoreAccess) {
        for (PreferenceKey prefKey : this.issueCodes.getConfigurableIssueCodes().values()) {
            preferenceStoreAccess.getWritablePreferenceStore().setDefault(prefKey.getId(), prefKey.getDefaultValue());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.preferenceStoreAccess == null) {
            return;
        }
        if ("subWordNavigation".equalsIgnoreCase(event.getProperty())) {
            this.preferenceStoreAccess.getWritablePreferenceStore().setValue("subWordNavigation", Boolean.valueOf(event.getNewValue().toString()).booleanValue());
        }
    }
}

