/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.labeling.XtendJvmLabelProvider;
import org.eclipse.xtend.ide.outline.AbstractMultiModeOutlineTreeProvider;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendOutlineJvmTreeProvider
extends AbstractMultiModeOutlineTreeProvider {
    @Inject
    XtendJvmLabelProvider xtendJvmLableProvider;

    @Override
    public void internalCreateChildren(DocumentRootNode parentNode, EObject modelElement) {
        String primaryPackage = null;
        if (modelElement instanceof XtendFile) {
            primaryPackage = this.getOutlineNodeFactory().createPackageAndImporNodes(parentNode, (XtendFile)modelElement);
        }
        EList contents = modelElement.eResource().getContents();
        for (EObject eObject : contents) {
            HashSet processedFeatures = Sets.newHashSet();
            if (!(eObject instanceof JvmDeclaredType)) continue;
            JvmDeclaredType jvmDeclaredType = (JvmDeclaredType)eObject;
            String packageName = jvmDeclaredType.getPackageName();
            EObjectNode typeNode = this.createNodeForType((IOutlineNode)parentNode, jvmDeclaredType, (Set<JvmMember>)processedFeatures, 0);
            if (this.isShowInherited() || packageName == null || packageName.equals(primaryPackage) || !(typeNode.getText() instanceof StyledString)) continue;
            typeNode.setText((Object)((StyledString)typeNode.getText()).append(new StyledString(" - " + packageName, StyledString.QUALIFIER_STYLER)));
        }
    }

    protected void internalCreateChildren(IOutlineNode parentNode, EObject modelElement) {
        if (modelElement instanceof JvmDeclaredType) {
            HashSet processedFeatures = Sets.newHashSet();
            this.createFeatureNodesForType(parentNode, (JvmDeclaredType)modelElement, (JvmDeclaredType)modelElement, processedFeatures, 0);
        } else {
            super.internalCreateChildren(parentNode, modelElement);
        }
    }

    @Override
    protected void createInheritedFeatureNodes(IOutlineNode parentNode, JvmDeclaredType baseType, Set<JvmMember> processedFeatures, int inheritanceDepth, JvmTypeReference superType) {
        if (superType.getType() instanceof JvmDeclaredType) {
            JvmDeclaredType superClass = (JvmDeclaredType)superType.getType();
            if (Object.class.getName().equals(superClass.getQualifiedName())) {
                inheritanceDepth += 10;
            }
            this.createFeatureNodesForType(parentNode, superClass, baseType, processedFeatures, inheritanceDepth + 1);
        }
    }

    @Override
    protected void createNodeForType(IOutlineNode parentNode, EObject someType, Set<JvmMember> processedFeatures, int inheritanceDepth) {
        EObject jvmElement;
        if (someType instanceof JvmDeclaredType) {
            JvmDeclaredType jvmType = (JvmDeclaredType)someType;
            super.createNodeForType(parentNode, jvmType, processedFeatures, inheritanceDepth);
        } else if (someType instanceof XtendTypeDeclaration && (jvmElement = this.getAssociations().getPrimaryJvmElement(someType)) instanceof JvmDeclaredType) {
            super.createNodeForType(parentNode, (JvmDeclaredType)jvmElement, processedFeatures, inheritanceDepth);
        }
    }

    protected ILabelProvider getLabelProvider() {
        return this.xtendJvmLableProvider;
    }
}

