/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.quickoutline;

import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.xtext.ui.editor.outline.quickoutline.QuickOutlinePopup;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;

public interface IQuickOutlineContribution
extends IPreferenceStoreInitializer {
    public void register(QuickOutlinePopup var1, IMenuManager var2);

    public void deregister(QuickOutlinePopup var1);

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface All {
    }

    public static class Composite
    implements IQuickOutlineContribution {
        private List<IQuickOutlineContribution> contributions;

        @Inject
        protected void initialize(Injector injector) {
            this.contributions = Lists.newArrayList();
            List bindings = injector.findBindingsByType(TypeLiteral.get(IQuickOutlineContribution.class));
            for (Binding binding : bindings) {
                this.contributions.add((IQuickOutlineContribution)injector.getInstance(binding.getKey()));
            }
        }

        public void initialize(IPreferenceStoreAccess access) {
            for (IQuickOutlineContribution contribution : this.contributions) {
                contribution.initialize(access);
            }
        }

        public void register(QuickOutlinePopup quickOutline, IMenuManager dialogMenu) {
            for (IQuickOutlineContribution contribution : this.contributions) {
                contribution.register(quickOutline, dialogMenu);
            }
            TreeViewer treeViewer = quickOutline.getTreeViewer();
            if (!treeViewer.getTree().isDisposed()) {
                treeViewer.refresh();
            }
        }

        public void deregister(QuickOutlinePopup quickOutline) {
            for (IQuickOutlineContribution contribution : this.contributions) {
                contribution.deregister(quickOutline);
            }
        }
    }
}

