/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gitlab.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

public final class GitlabConfiguration
implements Serializable {
    private static final long serialVersionUID = 3705325855842441295L;
    private static final GitlabTaskSchema SCHEMA = GitlabTaskSchema.getDefault();
    private final String repositoryURL;
    private BigInteger userID;
    private JsonElement userDetails;
    private Map<Integer, GitlabProjectDetail> projectIDsMap = new HashMap<Integer, GitlabProjectDetail>();
    private Map<String, JsonElement> groupsDetailsMap = new HashMap<String, JsonElement>();

    public GitlabConfiguration(String repositoryURL) {
        this.repositoryURL = repositoryURL;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public BigInteger getUserID() {
        return this.userID;
    }

    public void setUserID(BigInteger userID) {
        this.userID = userID;
    }

    public JsonElement getUserDetails() {
        return this.userDetails;
    }

    public void setUserDetails(JsonElement userDetails) {
        this.userDetails = userDetails;
    }

    public void addProject(JsonElement project, JsonElement lables, JsonElement milestones) {
        GitlabProjectDetail gitlabProject = new GitlabProjectDetail(project.getAsJsonObject(), lables.getAsJsonArray(), milestones.getAsJsonArray());
        this.projectIDsMap.put(project.getAsJsonObject().get("id").getAsInt(), gitlabProject);
    }

    public Set<Integer> getProjectIDs() {
        return this.projectIDsMap.keySet();
    }

    public JsonObject getProductWithID(Integer key) {
        return this.projectIDsMap.get((Object)key).project;
    }

    public JsonElement getGroupDetail(String group) {
        return this.groupsDetailsMap.get(group);
    }

    public Set<String> getGroupNames() {
        return this.groupsDetailsMap.keySet();
    }

    public void addGroup(JsonElement group) {
        this.groupsDetailsMap.put(group.getAsJsonObject().get("full_path").getAsString(), group);
    }

    public boolean updateProductOptions(@NonNull TaskData taskData) {
        TaskAttribute typeAttrib;
        TaskAttribute taskAttribute;
        if (taskData == null) {
            return false;
        }
        TaskAttribute attributeProduct = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.PRODUCT.getKey());
        TaskAttribute attributeLabels = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.TASK_LABELS.getKey());
        TaskAttribute attributeMilestone = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.TASK_MILESTONE.getKey());
        if (attributeProduct == null) {
            return false;
        }
        for (GitlabProjectDetail gitlabProjectDetail : this.projectIDsMap.values()) {
            JsonObject productObject = gitlabProjectDetail.getProject();
            if (attributeProduct == null) continue;
            attributeProduct.putOption(productObject.get("id").getAsString(), productObject.get("name_with_namespace").getAsString());
        }
        if (attributeProduct.getValue() != null && !attributeProduct.getValue().isBlank()) {
            for (String string : this.projectIDsMap.get(Integer.parseInt(attributeProduct.getValue())).getLabelNames()) {
                attributeLabels.putOption(string, string);
            }
        }
        if (attributeProduct.getValue() != null && !attributeProduct.getValue().isBlank()) {
            for (Map.Entry entry : this.projectIDsMap.get(Integer.parseInt(attributeProduct.getValue())).getMilestones().entrySet()) {
                attributeMilestone.putOption((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject().get("title").getAsString());
            }
        }
        if ((taskAttribute = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.PRIORITY.getKey())) != null) {
            taskAttribute.putOption("CRITICAL", "critical");
            taskAttribute.putOption("HIGH", "high");
            taskAttribute.putOption("MEDIUM", "Medium");
            taskAttribute.putOption("LOW", "low");
            taskAttribute.putOption("UNKNOWN", "unknown");
        }
        if ((typeAttrib = taskData.getRoot().getMappedAttribute(GitlabConfiguration.SCHEMA.ISSUE_TYPE.getKey())) != null) {
            typeAttrib.putOption("issue", "Issue");
            typeAttrib.putOption("incident", "Incident");
        }
        return true;
    }

    public boolean updateQueryOptions(@NonNull TaskData taskData) {
        TaskAttribute searchinAttrib;
        TaskAttribute stateAttrib;
        if (taskData == null) {
            return false;
        }
        TaskAttribute attributeGroups = taskData.getRoot().getMappedAttribute("GROUP");
        if (attributeGroups != null) {
            Set<String> groups = this.getGroupNames();
            for (String string : groups) {
                attributeGroups.putOption(string, string);
            }
        }
        if ((stateAttrib = taskData.getRoot().getMappedAttribute("STATE")) != null) {
            stateAttrib.putOption("opened", "Opened");
            stateAttrib.putOption("closed", "Closed");
            stateAttrib.putOption("", "All");
        }
        if ((searchinAttrib = taskData.getRoot().getMappedAttribute("SEARCH_IN")) != null) {
            searchinAttrib.putOption("title", "Title");
            searchinAttrib.putOption("description", "Description");
            searchinAttrib.putOption("", "Title and Description");
        }
        return this.updateProductOptions(taskData);
    }

    public String getGroupID(String path) {
        Optional<Object> groupId = Optional.ofNullable(this.groupsDetailsMap.get(path)).map(ma -> ma.getAsJsonObject().get("id").getAsString());
        if (groupId.isPresent()) {
            return (String)groupId.get();
        }
        return "";
    }

    public void addValidOperations(TaskData bugReport) {
        TaskAttribute attributeStatus = bugReport.getRoot().getMappedAttribute("task.common.status");
        String attributeStatusValue = attributeStatus.getValue();
        TaskAttribute operationAttribute = bugReport.getRoot().getAttribute("task.common.operation");
        if (operationAttribute == null) {
            operationAttribute = bugReport.getRoot().createAttribute("task.common.operation");
        }
        TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)attributeStatusValue, (String)attributeStatusValue);
        TaskAttribute attribute = bugReport.getRoot().createAttribute("task.common.operation-opened");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)attributeStatusValue, (String)attributeStatusValue);
        attribute = bugReport.getRoot().createAttribute("task.common.operation-closed");
        if (attributeStatusValue.equals("closed")) {
            TaskOperation.applyTo((TaskAttribute)attribute, (String)"reopen", (String)"Reopen");
        } else {
            TaskOperation.applyTo((TaskAttribute)attribute, (String)"close", (String)"Close");
        }
    }

    private class GitlabProjectDetail {
        private JsonObject project;
        private Map<String, JsonElement> labelsHash = new HashMap<String, JsonElement>();
        private Map<String, JsonElement> milestonesHash = new HashMap<String, JsonElement>();

        public GitlabProjectDetail(JsonObject project, JsonArray labels, JsonArray milestones) {
            JsonObject jsonObject;
            this.project = project;
            for (JsonElement jsonElement : labels) {
                jsonObject = (JsonObject)jsonElement;
                this.labelsHash.put(jsonObject.get("name").getAsString(), (JsonElement)jsonObject);
            }
            for (JsonElement jsonElement : milestones) {
                jsonObject = (JsonObject)jsonElement;
                this.milestonesHash.put(jsonObject.get("id").getAsString(), (JsonElement)jsonObject);
            }
        }

        public JsonObject getProject() {
            return this.project;
        }

        public Set<String> getLabelNames() {
            return this.labelsHash.keySet();
        }

        public Map<String, JsonElement> getMilestones() {
            return this.milestonesHash;
        }
    }
}

