/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentSizeFormatter;

public class AttachmentSizeFormatterTest
extends TestCase {
    public void testInvalidString() {
        AttachmentSizeFormatter formatter = AttachmentSizeFormatter.getInstance();
        AttachmentSizeFormatterTest.assertEquals((String)"-", (String)formatter.format(null));
        AttachmentSizeFormatterTest.assertEquals((String)"-", (String)formatter.format("x"));
    }

    public void testNotAValidNumber() {
        AttachmentSizeFormatter formatter = AttachmentSizeFormatter.getInstance();
        AttachmentSizeFormatterTest.assertEquals((String)"-", (String)formatter.format("-5"));
        AttachmentSizeFormatterTest.assertEquals((String)"-", (String)formatter.format("1.0"));
    }

    public void testByteFormatter() {
        AttachmentSizeFormatter formatter = new AttachmentSizeFormatter(Locale.ENGLISH);
        AttachmentSizeFormatterTest.assertEquals((String)"1 byte", (String)formatter.format("1"));
        AttachmentSizeFormatterTest.assertEquals((String)"2 bytes", (String)formatter.format("2"));
        AttachmentSizeFormatterTest.assertEquals((String)"1023 bytes", (String)formatter.format("1023"));
    }

    public void testKBFormatter() {
        AttachmentSizeFormatter formatterEnglish = new AttachmentSizeFormatter(Locale.ENGLISH);
        AttachmentSizeFormatterTest.assertEquals((String)"1.00 KB", (String)formatterEnglish.format("1024"));
        AttachmentSizeFormatterTest.assertEquals((String)"1024.00 KB", (String)formatterEnglish.format("1048575"));
        AttachmentSizeFormatter formatterGerman = new AttachmentSizeFormatter(Locale.GERMAN);
        AttachmentSizeFormatterTest.assertEquals((String)"1,00 KB", (String)formatterGerman.format("1024"));
        AttachmentSizeFormatterTest.assertEquals((String)"1024,00 KB", (String)formatterGerman.format("1048575"));
    }

    public void testMBFormatter() {
        AttachmentSizeFormatter formatterEnglish = new AttachmentSizeFormatter(Locale.ENGLISH);
        AttachmentSizeFormatterTest.assertEquals((String)"1.00 MB", (String)formatterEnglish.format("1048576"));
        AttachmentSizeFormatterTest.assertEquals((String)"1024.00 MB", (String)formatterEnglish.format("1073741823"));
        AttachmentSizeFormatter formatterGerman = new AttachmentSizeFormatter(Locale.GERMAN);
        AttachmentSizeFormatterTest.assertEquals((String)"1,00 MB", (String)formatterGerman.format("1048576"));
        AttachmentSizeFormatterTest.assertEquals((String)"1024,00 MB", (String)formatterGerman.format("1073741823"));
    }

    public void testGBFormatter() {
        AttachmentSizeFormatter formatterEnglish = new AttachmentSizeFormatter(Locale.ENGLISH);
        AttachmentSizeFormatterTest.assertEquals((String)"1.00 GB", (String)formatterEnglish.format("1073741824"));
        AttachmentSizeFormatter formatterGerman = new AttachmentSizeFormatter(Locale.GERMAN);
        AttachmentSizeFormatterTest.assertEquals((String)"1,00 GB", (String)formatterGerman.format("1073741824"));
    }
}

