/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.textassist.snippets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.textassist.TextAssist;
import org.eclipse.nebula.widgets.opal.textassist.TextAssistContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextAssistSnippet {
    private static boolean useSingleClick = false;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout());
        TextAssistContentProvider contentProvider = new TextAssistContentProvider(){
            private final String[] EUROZONE = new String[]{"Austria", "Belgium", "Cyprus", "Estonia", "Finland", "France", "Germany", "Greece", "Ireland", "Italy", "Luxembourg", "Malta", "Netherlands", "Portugal", "Slovakia", "Slovenia", "Spain"};

            public List<String> getContent(String entry) {
                ArrayList<String> returnedList = new ArrayList<String>();
                String[] stringArray = this.EUROZONE;
                int n = this.EUROZONE.length;
                int n2 = 0;
                while (n2 < n) {
                    String country = stringArray[n2];
                    if (country.toLowerCase().matches(".*?" + entry.toLowerCase() + ".*?")) {
                        returnedList.add(country);
                    }
                    ++n2;
                }
                return returnedList;
            }
        };
        Label lblTextAssist = new Label((Composite)shell, 0);
        lblTextAssist.setText("Text field with text assist:");
        TextAssist textAssist = new TextAssist((Composite)shell, 2052);
        textAssist.setLayoutData((Object)new GridData(150, -1));
        textAssist.setContentProvider(contentProvider);
        new Label((Composite)shell, 0);
        Label lblSimpleText = new Label((Composite)shell, 0);
        lblSimpleText.setText("Simple Text field:");
        Text text = new Text((Composite)shell, 2052);
        text.setLayoutData((Object)new GridData(150, -1));
        new Label((Composite)shell, 0);
        Button button = new Button((Composite)shell, 8);
        button.setText("Force focus on Text Assist Field");
        button.addListener(13, e -> {
            boolean bl = textAssist.setFocus();
        });
        new Label((Composite)shell, 0);
        Button singleClickButton = new Button((Composite)shell, 32);
        singleClickButton.setText("Use single click to select an entry");
        singleClickButton.addListener(13, e -> {
            useSingleClick = !useSingleClick;
            textAssist.setUseSingleClick(useSingleClick);
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

