/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ctreecombo.snippets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.ctreecombo.CTreeCombo;
import org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem;
import org.eclipse.nebula.widgets.ctreecombo.snippets.Country;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CTreeComboSnippet {
    private static Font boldFont;
    private static Map<String, Image> images;
    private static Color darkRed;
    private static Color darkBlue;
    private static Color darkGreen;
    private static List<Country> modelList;
    private static Text listenerResults;
    private static Group listenerGroup;

    static {
        images = new HashMap<String, Image>();
    }

    private static List<Country> loadModel() {
        ArrayList<Country> items = new ArrayList<Country>();
        items.add(new Country("Austria", "Thomas Schindl"));
        items.add(new Country("France", "Laurent Caron", "Nicolas Richeton"));
        items.add(new Country("Germany", "Dirk Fauth", "Johannes Faltermeier"));
        items.add(new Country("Italy", "Mirko Paturzo"));
        items.add(new Country("Netherlands", "Wim Jongman"));
        items.add(new Country("Norway", "Hallvard Traetteberg"));
        items.add(new Country("UK", "Jonah Graham", "Matthew Gerring", "Peter Chang"));
        items.add(new Country("USA", "Donald Dunne"));
        return items;
    }

    private static void loadSingleDataset(CTreeCombo ctc) {
        for (Country country : modelList) {
            CTreeComboItem item = new CTreeComboItem(ctc, 0);
            item.setText(country.getName());
            for (String commiter : country.getCommiters()) {
                CTreeComboItem commiterItem = new CTreeComboItem(item, 0);
                commiterItem.setText(commiter);
            }
        }
    }

    private static void loadSingleDatasetWithColorsAndFonts(CTreeCombo ctc) {
        int index = 0;
        for (Country country : modelList) {
            CTreeComboItem item = new CTreeComboItem(ctc, 0);
            item.setText(country.getName());
            if (index % 3 == 0) {
                item.setForeground(darkBlue);
            } else if (index % 3 == 1) {
                item.setForeground(darkGreen);
            } else {
                item.setForeground(darkRed);
            }
            int j = 0;
            while (j < country.getCommiters().size()) {
                String commiter = country.getCommiters().get(j);
                CTreeComboItem commiterItem = new CTreeComboItem(item, 0);
                commiterItem.setText(commiter);
                if (j % 2 == 0) {
                    commiterItem.setFont(boldFont);
                }
                ++j;
            }
            ++index;
        }
    }

    private static void loadSingleDatasetWithImages(CTreeCombo ctc) {
        for (Country country : modelList) {
            CTreeComboItem item = new CTreeComboItem(ctc, 0);
            item.setText(country.getName());
            String key = country.getName().toLowerCase();
            item.setImage(images.get(key));
            for (String commiter : country.getCommiters()) {
                CTreeComboItem commiterItem = new CTreeComboItem(item, 0);
                commiterItem.setText(commiter);
            }
        }
    }

    public static void main(String[] args) {
        String[] countries;
        Display display = new Display();
        boldFont = new Font((Device)display, "Arial", 8, 3);
        String[] stringArray = countries = new String[]{"austria", "france", "germany", "italy", "netherlands", "norway", "unitedkingdom", "usa"};
        int n = countries.length;
        int n2 = 0;
        while (n2 < n) {
            String country = stringArray[n2];
            Image img = ImageDescriptor.createFromFile(CTreeComboSnippet.class, (String)("flags/" + country + ".png")).createImage();
            images.put(country, img);
            ++n2;
        }
        darkRed = Display.getCurrent().getSystemColor(4);
        darkBlue = Display.getCurrent().getSystemColor(10);
        darkGreen = Display.getCurrent().getSystemColor(6);
        modelList = CTreeComboSnippet.loadModel();
        Shell shell = new Shell(display);
        shell.setText("CTreeCombo Snippet (pure SWT)");
        shell.setSize(600, 400);
        shell.setLayout((Layout)new GridLayout());
        Group group = new Group((Composite)shell, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        group.setText("Sample Group");
        listenerGroup = new Group((Composite)shell, 0);
        listenerGroup.setLayout((Layout)new GridLayout(1, false));
        listenerGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        listenerGroup.setText("Listener Results");
        listenerResults = new Text((Composite)listenerGroup, 2050);
        GridData gd = new GridData(4, -1, true, false);
        gd.heightHint = 30;
        listenerResults.setLayoutData((Object)gd);
        Label label = new Label((Composite)group, 0);
        label.setText("No image, no font:");
        CTreeCombo ctc = new CTreeCombo((Composite)group, 2056);
        ctc.setLayoutData((Object)new GridData(200, -1));
        CTreeComboSnippet.loadSingleDataset(ctc);
        ctc.addSelectionListener((SelectionListener)new ItemSelected(ctc, "Sample1"));
        label = new Label((Composite)group, 0);
        label.setText("Combo with images");
        ctc = new CTreeCombo((Composite)group, 2056);
        ctc.setLayoutData((Object)new GridData(200, -1));
        CTreeComboSnippet.loadSingleDatasetWithImages(ctc);
        ctc.addSelectionListener((SelectionListener)new ItemSelected(ctc, "Sample2"));
        label = new Label((Composite)group, 0);
        label.setText("Colors && Fonts :");
        ctc = new CTreeCombo((Composite)group, 2056);
        ctc.setLayoutData((Object)new GridData(200, -1));
        CTreeComboSnippet.loadSingleDatasetWithColorsAndFonts(ctc);
        ctc.addSelectionListener((SelectionListener)new ItemSelected(ctc, "Sample3"));
        label = new Label((Composite)group, 0);
        label.setText("Not readonly");
        ctc = new CTreeCombo((Composite)group, 2048);
        ctc.setLayoutData((Object)new GridData(200, -1));
        CTreeComboSnippet.loadSingleDatasetWithColorsAndFonts(ctc);
        ctc.addSelectionListener((SelectionListener)new ItemSelected(ctc, "Sample4"));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        boldFont.dispose();
        for (Image img : images.values()) {
            img.dispose();
        }
        darkRed.dispose();
        darkBlue.dispose();
        darkGreen.dispose();
        display.dispose();
    }

    private static class ItemSelected
    extends SelectionAdapter {
        private final CTreeCombo ctc;
        private final String text;

        public ItemSelected(CTreeCombo ctc, String text) {
            this.ctc = ctc;
            this.text = text;
        }

        public void widgetSelected(SelectionEvent e) {
            listenerGroup.setText("Listener Results - (" + this.text + ")");
            listenerResults.setText(this.ctc.getText() == null ? "null" : this.ctc.getText());
        }
    }
}

