/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;

final class ScalePiece
implements PrintPiece {
    private final Device device;
    private final PrintPiece target;
    private final double scale;
    private final Point size;
    private Transform oldTransform;
    private Transform transform;

    ScalePiece(Device device, PrintPiece target, double scale, int maxWidth, int maxHeight) {
        Util.notNull(device, target);
        this.device = device;
        this.target = target;
        this.scale = scale;
        Point targetSize = target.getSize();
        this.size = new Point(Math.min((int)Math.ceil((double)targetSize.x * scale), maxWidth), Math.min((int)Math.ceil((double)targetSize.y * scale), maxHeight));
    }

    @Override
    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    private Transform getOldTransform() {
        if (this.oldTransform == null) {
            this.oldTransform = new Transform(this.device);
        }
        return this.oldTransform;
    }

    private Transform getTransform() {
        if (this.transform == null) {
            this.transform = new Transform(this.device);
        }
        return this.transform;
    }

    @Override
    public void paint(GC gc, int x, int y) {
        Transform oldTransform = this.getOldTransform();
        gc.getTransform(oldTransform);
        Transform transform = this.getTransform();
        gc.getTransform(transform);
        transform.translate((float)x, (float)y);
        transform.scale((float)this.scale, (float)this.scale);
        gc.setTransform(transform);
        this.target.paint(gc, 0, 0);
        gc.setTransform(oldTransform);
    }

    @Override
    public void dispose() {
        if (this.oldTransform != null) {
            this.oldTransform.dispose();
            this.oldTransform = null;
        }
        if (this.transform != null) {
            this.transform.dispose();
            this.transform = null;
        }
        this.target.dispose();
    }
}

