/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail.cursor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorLayer;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;

public class CursorTimingsLayer
extends FreeformLayer {
    private Point fConnectionsLocation;

    public CursorTimingsLayer() {
        this.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.setVisible(false);
    }

    public void validate() {
        for (Object connection : this.getChildren()) {
            ((CursorConnection)((Object)connection)).updateDistance();
        }
        super.validate();
    }

    public void showTimingsFor(CursorFigure cursorFigure, MouseEvent me) {
        this.removeAll();
        List<CursorFigure> cursors = this.getAllCursors();
        cursors.remove(cursorFigure);
        Collections.sort(cursors, (o1, o2) -> (int)(Math.abs(cursorFigure.getEventTime() - o1.getEventTime()) - Math.abs(cursorFigure.getEventTime() - o2.getEventTime())));
        Dimension distance = new Dimension(20, me.y);
        for (CursorFigure cursor : cursors) {
            this.add((IFigure)new CursorConnection(cursorFigure, cursor, distance));
            distance.expand(20, 30);
        }
        this.fConnectionsLocation = me.getLocation();
        this.setVisible(true);
    }

    public void hideTimings() {
        this.removeAll();
        this.setVisible(false);
    }

    private List<CursorFigure> getAllCursors() {
        ArrayList<CursorFigure> cursors = new ArrayList<CursorFigure>();
        CursorLayer cursorLayer = RootFigure.getFigure((IFigure)this, CursorLayer.class);
        for (Object cursor : cursorLayer.getChildren()) {
            if (!(cursor instanceof CursorFigure)) continue;
            cursors.add((CursorFigure)cursor);
        }
        return cursors;
    }

    public void moveTimingsTo(Point targetLocation) {
        Dimension offset = targetLocation.getDifference(this.fConnectionsLocation);
        if (offset.height() != 0) {
            this.fConnectionsLocation = targetLocation;
            for (Object connection : this.getChildren()) {
                if (!(connection instanceof PolylineConnection)) continue;
                CursorAnchor sourceAnchor = (CursorAnchor)((PolylineConnection)connection).getSourceAnchor();
                sourceAnchor.translatePixelsFromTop(offset.height());
                CursorAnchor targetAnchor = (CursorAnchor)((PolylineConnection)connection).getTargetAnchor();
                targetAnchor.translatePixelsFromTop(offset.height());
            }
            this.revalidate();
        }
    }

    private class CursorAnchor
    extends ChopboxAnchor {
        private int fPixelsFromTop;

        public CursorAnchor(CursorFigure cursor, int pixelsFromTop) {
            super((IFigure)cursor);
            this.setPixelsFromTop(pixelsFromTop);
        }

        public void setPixelsFromTop(int pixelsFromTop) {
            this.fPixelsFromTop = pixelsFromTop;
        }

        public void translatePixelsFromTop(int offset) {
            this.fPixelsFromTop += offset;
        }

        protected Rectangle getBox() {
            Rectangle box = super.getBox().getCopy();
            box.performTranslate(box.width() / 2, 0);
            box.setWidth(1);
            box.setY(box.y() + this.fPixelsFromTop);
            box.setHeight(1);
            return box;
        }
    }

    private class CursorConnection
    extends PolylineConnection {
        private final CursorFigure fSorce;
        private final CursorFigure fTarget;
        private final CursorLabel fCursorLabel;

        public CursorConnection(CursorFigure sorce, CursorFigure target, Dimension distance) {
            this.fSorce = sorce;
            this.fTarget = target;
            this.setForegroundColor(ColorConstants.yellow);
            this.setLineStyle(3);
            this.setSourceAnchor((ConnectionAnchor)new CursorAnchor(sorce, distance.height()));
            this.setTargetAnchor((ConnectionAnchor)new CursorAnchor(target, distance.height()));
            this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            this.fCursorLabel = new CursorLabel(this.getDistanceAsText(sorce, target));
            this.add((IFigure)this.fCursorLabel, (Object)new CursorConnectionLocator(this, distance.width()));
        }

        public void updateDistance() {
            this.fCursorLabel.setText(this.getDistanceAsText(this.fSorce, this.fTarget));
        }

        private String getDistanceAsText(CursorFigure cursorA, CursorFigure cursorB) {
            double eventTime = Math.abs(cursorA.getEventTime() - cursorB.getEventTime());
            ITimelineStyleProvider styleProvider = RootFigure.getRootFigure((IFigure)CursorTimingsLayer.this).getStyleProvider();
            return styleProvider.getTimeLabel(eventTime, TimeUnit.NANOSECONDS);
        }

        protected void outlineShape(Graphics g) {
            g.drawPolyline(this.getPoints());
        }

        public PointList getPoints() {
            PointList originalPoints = super.getPoints();
            if (originalPoints.size() == 2) {
                Point targetPoint = originalPoints.getLastPoint();
                Rectangle layerBounds = CursorTimingsLayer.this.getBounds();
                if (targetPoint.x() < layerBounds.x()) {
                    targetPoint.setX(layerBounds.x());
                    originalPoints.setPoint(targetPoint, 1);
                } else if (targetPoint.x() > layerBounds.right()) {
                    targetPoint.setX(layerBounds.right());
                    originalPoints.setPoint(targetPoint, 1);
                }
            }
            return originalPoints;
        }
    }

    private class CursorConnectionLocator
    extends ConnectionLocator {
        private final int fDistance;

        public CursorConnectionLocator(PolylineConnection connection, int distance) {
            super((Connection)connection, 2);
            this.fDistance = distance;
        }

        protected Point getLocation(PointList points) {
            IFigure cursorLabel = (IFigure)this.getConnection().getChildren().get(1);
            Dimension labelSize = cursorLabel.getPreferredSize();
            Point firstPoint = points.getFirstPoint();
            Point lastPoint = points.getLastPoint();
            int direction = lastPoint.x() > firstPoint.x() ? 1 : -1;
            Point point = super.getLocation(points);
            point.translate((labelSize.width() / 2 + this.fDistance) * direction, 0);
            return point;
        }
    }

    private class CursorLabel
    extends RoundedRectangle {
        private static final int VERTICAL_INDENT = 2;
        private static final int HORIZONTAL_INDENT = 5;

        public CursorLabel(String text) {
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setForegroundColor(ColorConstants.yellow);
            this.setBackgroundColor(ColorConstants.yellow);
            this.setOpaque(true);
            this.setCornerDimensions(new Dimension(5, 5));
            this.setBorder((Border)new MarginBorder(2, 5, 2, 5));
            Label label = new Label(text);
            label.setForegroundColor(ColorConstants.black);
            this.add((IFigure)label);
        }

        public void setText(String text) {
            Label label = (Label)this.getChildren().get(0);
            label.setText(text);
        }

        public Dimension getPreferredSize(int w, int h) {
            Dimension dimension = super.getPreferredSize(w, h);
            if (dimension.width > 150) {
                dimension = super.getPreferredSize(150, -1);
            }
            return dimension;
        }
    }
}

