/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.undo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.visualization.internal.xygraph.undo.SaveStateCommand;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;

public class ZoomCommand
extends SaveStateCommand {
    private final List<Axis> xAxisList;
    private final List<Axis> yAxisList;
    private final List<Range> beforeXRangeList = new ArrayList<Range>();
    private final List<Range> beforeYRangeList = new ArrayList<Range>();
    private final List<Range> afterXRangeList = new ArrayList<Range>();
    private final List<Range> afterYRangeList = new ArrayList<Range>();

    public ZoomCommand(String name, List<Axis> xAxisList, List<Axis> yAxisList) {
        super(name);
        this.xAxisList = xAxisList;
        this.yAxisList = yAxisList;
        this.saveOriginalState();
    }

    private void saveOriginalState() {
        if (this.xAxisList != null) {
            for (Axis axis : this.xAxisList) {
                this.beforeXRangeList.add(axis.getRange());
            }
        }
        for (Axis axis : this.yAxisList) {
            this.beforeYRangeList.add(axis.getRange());
        }
    }

    @Override
    public void redo() {
        int i = 0;
        if (this.xAxisList != null) {
            for (Axis axis : this.xAxisList) {
                axis.setRange(this.afterXRangeList.get(i));
                ++i;
            }
        }
        i = 0;
        for (Axis axis : this.yAxisList) {
            axis.setRange(this.afterYRangeList.get(i));
            ++i;
        }
    }

    @Override
    public void undo() {
        int i = 0;
        if (this.xAxisList != null) {
            for (Axis axis : this.xAxisList) {
                axis.setRange(this.beforeXRangeList.get(i));
                ++i;
            }
        }
        i = 0;
        for (Axis axis : this.yAxisList) {
            axis.setRange(this.beforeYRangeList.get(i));
            ++i;
        }
    }

    @Override
    public void saveState() {
        if (this.xAxisList != null) {
            for (Axis axis : this.xAxisList) {
                this.afterXRangeList.add(axis.getRange());
            }
        }
        for (Axis axis : this.yAxisList) {
            this.afterYRangeList.add(axis.getRange());
        }
    }
}

