/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.directorywatcher;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.metadata.expression.CompoundIterator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;

public class CachingArtifactRepository
implements IFileArtifactRepository {
    private static final String NULL = "";
    private final IArtifactRepository innerRepo;
    private final Set<IArtifactDescriptor> descriptorsToAdd = new HashSet<IArtifactDescriptor>();
    private final Map<IArtifactKey, List<IArtifactDescriptor>> artifactMap = new HashMap<IArtifactKey, List<IArtifactDescriptor>>();
    private final Set<IArtifactDescriptor> descriptorsToRemove = new HashSet<IArtifactDescriptor>();
    private final Map<String, String> propertyChanges = new HashMap<String, String>();

    protected CachingArtifactRepository(IArtifactRepository innerRepo) {
        this.innerRepo = innerRepo;
    }

    public void save() {
        this.innerRepo.executeBatch(monitor -> {
            this.savePropertyChanges();
            this.saveAdditions();
            this.saveRemovals();
        }, null);
    }

    void saveRemovals() {
        for (IArtifactDescriptor desc : this.descriptorsToRemove) {
            this.innerRepo.removeDescriptor(desc);
        }
        this.descriptorsToRemove.clear();
    }

    void saveAdditions() {
        if (this.descriptorsToAdd.isEmpty()) {
            return;
        }
        this.innerRepo.addDescriptors(this.descriptorsToAdd.toArray(new IArtifactDescriptor[this.descriptorsToAdd.size()]));
        this.descriptorsToAdd.clear();
        this.artifactMap.clear();
    }

    void savePropertyChanges() {
        Iterator<String> iterator = this.propertyChanges.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String value = this.propertyChanges.get(key = iterator.next());
            this.innerRepo.setProperty(key, value == NULL ? null : value);
        }
        this.propertyChanges.clear();
    }

    private void mapDescriptor(IArtifactDescriptor descriptor) {
        IArtifactKey key = descriptor.getArtifactKey();
        List<IArtifactDescriptor> descriptors = this.artifactMap.get(key);
        if (descriptors == null) {
            descriptors = new ArrayList<IArtifactDescriptor>();
            this.artifactMap.put(key, descriptors);
        }
        descriptors.add(descriptor);
    }

    private void unmapDescriptor(IArtifactDescriptor descriptor) {
        IArtifactKey key = descriptor.getArtifactKey();
        List<IArtifactDescriptor> descriptors = this.artifactMap.get(key);
        if (descriptors == null) {
            this.descriptorsToRemove.add(descriptor);
            return;
        }
        descriptors.remove(descriptor);
        if (descriptors.isEmpty()) {
            this.artifactMap.remove(key);
        }
    }

    public synchronized void addDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)descriptors.length);
            IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                ((ArtifactDescriptor)descriptor).setRepository((IArtifactRepository)this);
                this.descriptorsToAdd.add(descriptor);
                this.mapDescriptor(descriptor);
                subMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public final synchronized void addDescriptors(IArtifactDescriptor[] descriptors) {
        this.addDescriptors(descriptors, (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized void addDescriptor(IArtifactDescriptor toAdd, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            ((ArtifactDescriptor)toAdd).setRepository((IArtifactRepository)this);
            this.descriptorsToAdd.add(toAdd);
            this.mapDescriptor(toAdd);
            subMonitor.worked(1);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public final synchronized void addDescriptor(IArtifactDescriptor toAdd) {
        this.addDescriptor(toAdd, (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        List<IArtifactDescriptor> result = this.artifactMap.get(key);
        if (result == null) {
            return this.innerRepo.getArtifactDescriptors(key);
        }
        result = new ArrayList<IArtifactDescriptor>(result);
        result.addAll(Arrays.asList(this.innerRepo.getArtifactDescriptors(key)));
        return result.toArray(new IArtifactDescriptor[result.size()]);
    }

    public synchronized boolean contains(IArtifactDescriptor descriptor) {
        return this.descriptorsToAdd.contains(descriptor) || this.innerRepo.contains(descriptor);
    }

    public synchronized boolean contains(IArtifactKey key) {
        return this.artifactMap.containsKey(key) || this.innerRepo.contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.innerRepo.getArtifact(descriptor, destination, monitor);
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.innerRepo.getRawArtifact(descriptor, destination, monitor);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
        return null;
    }

    public final synchronized void removeAll(IProgressMonitor monitor) {
        try {
            IArtifactDescriptor[] toRemove;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            IArtifactDescriptor[] iArtifactDescriptorArray = toRemove = this.descriptorsToAdd.toArray(new IArtifactDescriptor[this.descriptorsToAdd.size()]);
            int n = toRemove.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor toRemove1 = iArtifactDescriptorArray[n2];
                this.doRemoveArtifact(toRemove1);
                ++n2;
            }
            subMonitor.worked(1);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public synchronized void removeAll() {
        this.removeAll((IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized void removeDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            this.doRemoveArtifact(descriptor);
            subMonitor.worked(1);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public final synchronized void removeDescriptor(IArtifactDescriptor descriptor) {
        this.removeDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized void removeDescriptor(IArtifactKey key, IProgressMonitor monitor) {
        try {
            IArtifactDescriptor[] toRemove = this.getArtifactDescriptors(key);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)toRemove.length);
            IArtifactDescriptor[] iArtifactDescriptorArray = toRemove;
            int n = toRemove.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor toRemove1 = iArtifactDescriptorArray[n2];
                this.doRemoveArtifact(toRemove1);
                subMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public final synchronized void removeDescriptor(IArtifactKey key) {
        this.removeDescriptor(key, (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized void removeDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)descriptors.length);
            IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                this.doRemoveArtifact(descriptor);
                subMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public final synchronized void removeDescriptors(IArtifactDescriptor[] descriptors) {
        this.removeDescriptors(descriptors, (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized void removeDescriptors(IArtifactKey[] keys, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)keys.length);
            IArtifactKey[] iArtifactKeyArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactKey key = iArtifactKeyArray[n2];
                this.removeDescriptor(key);
                subMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Deprecated
    public final synchronized void removeDescriptors(IArtifactKey[] keys) {
        this.removeDescriptors(keys, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean doRemoveArtifact(IArtifactDescriptor descriptor) {
        boolean result = this.descriptorsToAdd.remove(descriptor);
        if (result) {
            this.unmapDescriptor(descriptor);
        }
        this.descriptorsToRemove.add(descriptor);
        return result;
    }

    public String getDescription() {
        return this.innerRepo.getDescription();
    }

    public URI getLocation() {
        return this.innerRepo.getLocation();
    }

    public String getName() {
        return this.innerRepo.getName();
    }

    public Map<String, String> getProperties() {
        return this.innerRepo.getProperties();
    }

    public String getProperty(String key) {
        return this.innerRepo.getProperty(key);
    }

    public String getProvider() {
        return this.innerRepo.getProvider();
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.innerRepo.getProvisioningAgent();
    }

    public String getType() {
        return this.innerRepo.getType();
    }

    public String getVersion() {
        return this.innerRepo.getVersion();
    }

    public boolean isModifiable() {
        return this.innerRepo.isModifiable();
    }

    public String setProperty(String key, String value, IProgressMonitor monitor) {
        try {
            String result = this.getProperties().get(key);
            this.propertyChanges.put(key, value == null ? NULL : value);
            String string = result;
            return string;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public final String setProperty(String key, String value) {
        return this.setProperty(key, value, (IProgressMonitor)new NullProgressMonitor());
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)this.innerRepo.getAdapter(adapter);
    }

    public File getArtifactFile(IArtifactKey key) {
        if (this.innerRepo instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)this.innerRepo).getArtifactFile(key);
        }
        return null;
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        if (this.innerRepo instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)this.innerRepo).getArtifactFile(descriptor);
        }
        return null;
    }

    public IArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        return this.innerRepo.createArtifactDescriptor(key);
    }

    public IArtifactKey createArtifactKey(String classifier, String id, Version version) {
        return this.innerRepo.createArtifactKey(classifier, id, version);
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        Collection<List<IArtifactDescriptor>> descs = this.artifactMap.values();
        IQueryable cached = (query, monitor) -> query.perform((Iterator)new CompoundIterator(descs.iterator()));
        return QueryUtil.compoundQueryable((IQueryable)cached, (IQueryable)this.innerRepo.descriptorQueryable());
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        Iterator<IArtifactKey> keyIterator = this.artifactMap.keySet().iterator();
        IQueryable cached = (q, mon) -> q.perform(keyIterator);
        IQueryable compound = QueryUtil.compoundQueryable((IQueryable)cached, (IQueryable)this.innerRepo);
        return compound.query(query, monitor);
    }

    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (OperationCanceledException oce) {
            return new Status(8, "org.eclipse.equinox.p2.directorywatcher", oce.getMessage(), (Throwable)oce);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.equinox.p2.directorywatcher", e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

