/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;

public class SiteBundle {
    private String arch;
    private URL base;
    private List<String> categoryNames;
    private String bundleId;
    private String bundleVersion;
    private String label;
    private String nl;
    private String os;
    private String patch;
    private static final boolean resolved = false;
    private SiteModel site;
    private String type;
    private URL url;
    private String urlString;
    private String ws;

    public static boolean sameURL(URL url1, URL url2) {
        if (url1 == url2) {
            return true;
        }
        if (url1 == null ^ url2 == null) {
            return false;
        }
        boolean isFile1 = "file".equalsIgnoreCase(url1.getProtocol());
        boolean isFile2 = "file".equalsIgnoreCase(url2.getProtocol());
        if (isFile1 && isFile2) {
            File file1 = new File(url1.getFile());
            File file2 = new File(url2.getFile());
            return file1.equals(file2);
        }
        if (isFile1 ^ isFile2) {
            return false;
        }
        return SiteBundle.getExternalForm(url1).equals(SiteBundle.getExternalForm(url2));
    }

    private static String getExternalForm(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm == null) {
            return "";
        }
        if ((externalForm = externalForm.trim()).endsWith("/")) {
            externalForm = externalForm.substring(0, externalForm.length() - 1);
        }
        return externalForm.toLowerCase();
    }

    public void addCategoryName(String categoryName) {
        if (this.categoryNames == null) {
            this.categoryNames = new ArrayList<String>();
        }
        if (!this.categoryNames.contains(categoryName)) {
            this.categoryNames.add(categoryName);
        }
    }

    private void delayedResolve() {
        try {
            this.url = new URL(this.base, this.urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SiteBundle)) {
            return false;
        }
        SiteBundle that = (SiteBundle)object;
        if (this.bundleId == null ? that.bundleId != null : !this.bundleId.equals(that.bundleId)) {
            return false;
        }
        if (this.bundleVersion == null ? that.bundleVersion != null : !this.bundleVersion.equals(that.bundleVersion)) {
            return false;
        }
        if (this.label == null ? that.label != null : !this.label.equals(that.label)) {
            return false;
        }
        return SiteBundle.sameURL(this.getURL(), that.getURL());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.bundleVersion == null ? 0 : this.bundleVersion.hashCode());
        if (this.getURL() == null) {
            return result;
        }
        if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
            File f = new File(this.getURL().getFile());
            if (f != null) {
                result = 31 * result + f.hashCode();
            }
        } else {
            result = 31 * result + SiteBundle.getExternalForm(this.getURL()).hashCode();
        }
        return result;
    }

    public String[] getCategoryNames() {
        if (this.categoryNames == null) {
            return new String[0];
        }
        return this.categoryNames.toArray(new String[0]);
    }

    public String getBundleIdentifier() {
        return this.bundleId;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public String getNL() {
        return this.nl;
    }

    public String getOS() {
        return this.os;
    }

    public String getOSArch() {
        return this.arch;
    }

    public String getPatch() {
        return this.patch;
    }

    public SiteModel getSiteModel() {
        return this.site;
    }

    public String getType() {
        return this.type;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public String getURLString() {
        return this.urlString;
    }

    public String getWS() {
        return this.ws;
    }

    public void resolve(URL resolveBase, URL bundleURL) throws MalformedURLException {
        this.base = resolveBase;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setCategoryNames(String[] categoryNames) {
        this.categoryNames = categoryNames == null ? null : new ArrayList<String>(Arrays.asList(categoryNames));
    }

    public void setBundleIdentifier(String bundleId) {
        this.bundleId = bundleId;
    }

    public void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setNL(String nl) {
        this.nl = nl;
    }

    public void setOS(String os) {
        this.os = os;
    }

    public void setPatch(String patch) {
        this.patch = patch;
    }

    public void setSiteModel(SiteModel site) {
        this.site = site;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setURLString(String urlString) {
        this.urlString = urlString;
        this.url = null;
    }

    public void setWS(String ws) {
        this.ws = ws;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().toString() + " :");
        buffer.append(" at ");
        if (this.url != null) {
            buffer.append(this.url.toExternalForm());
        }
        return buffer.toString();
    }
}

