/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.oauth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OAuthCredentialsPersistence {
    private static final String PROPERTY_PERSISTENCE = "org.eclipse.userstorage.oauth.persistence";
    private static final String KEY_SEPARATOR = "/";
    private static final String KEY_TOKEN = "token:";
    private static final String KEY_EMAIL = "email:";
    private File location;

    public static OAuthCredentialsPersistence standard() {
        if (System.getProperty(PROPERTY_PERSISTENCE) != null && !Boolean.getBoolean(PROPERTY_PERSISTENCE)) {
            return null;
        }
        return new OAuthCredentialsPersistence(OAuthCredentialsPersistence.getPersistenceFile());
    }

    private static File getPersistenceFile() {
        IPath path = Platform.getStateLocation((Bundle)FrameworkUtil.getBundle(OAuthCredentialsPersistence.class));
        return path.append(PROPERTY_PERSISTENCE).toFile();
    }

    public OAuthCredentialsPersistence(File location) {
        this.location = location;
    }

    public LinkedAccount[] getLinkedAccounts() {
        if (!this.location.exists()) {
            return new LinkedAccount[0];
        }
        HashMap<String, String> tokens = new HashMap<String, String>();
        HashMap<String, String> emails = new HashMap<String, String>();
        Properties properties = this.load();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith(KEY_TOKEN)) {
                tokens.put(key.substring(KEY_TOKEN.length()), value);
            }
            if (!key.startsWith(KEY_EMAIL)) continue;
            emails.put(key.substring(KEY_EMAIL.length()), value);
        }
        ArrayList<LinkedAccount> accounts = new ArrayList<LinkedAccount>();
        for (Map.Entry entry : tokens.entrySet()) {
            String[] components = ((String)entry.getKey()).split(KEY_SEPARATOR);
            accounts.add(new LinkedAccount(StringUtil.decodeURI((String)components[0]), StringUtil.decodeURI((String)components[1]), (String)emails.get(entry.getKey())));
        }
        return accounts.toArray(new LinkedAccount[accounts.size()]);
    }

    public void removeLinkedAccounts(List<LinkedAccount> toRemove) {
        for (LinkedAccount account : toRemove) {
            this.removeAccountToken(account.clientId, account.authURI);
        }
    }

    public String getAccountToken(String clientId, String authURI) {
        if (!this.location.exists()) {
            return null;
        }
        Properties properties = this.load();
        return (String)properties.get(KEY_TOKEN + StringUtil.encodeURI((String)clientId) + KEY_SEPARATOR + StringUtil.encodeURI((String)authURI));
    }

    public void putAccountToken(String clientId, String authURI, String token, String email) {
        Properties properties = this.load();
        properties.put(KEY_TOKEN + StringUtil.encodeURI((String)clientId) + KEY_SEPARATOR + StringUtil.encodeURI((String)authURI), token);
        if (email != null && email.length() > 0) {
            properties.put(KEY_EMAIL + StringUtil.encodeURI((String)clientId) + KEY_SEPARATOR + StringUtil.encodeURI((String)authURI), email);
        }
        this.save(properties);
    }

    public boolean removeAccountToken(String clientId, String authURI) {
        if (!this.location.exists()) {
            return false;
        }
        Properties properties = this.load();
        Object found = properties.remove(KEY_TOKEN + StringUtil.encodeURI((String)clientId) + KEY_SEPARATOR + StringUtil.encodeURI((String)authURI));
        properties.remove(KEY_EMAIL + StringUtil.encodeURI((String)clientId) + KEY_SEPARATOR + StringUtil.encodeURI((String)authURI));
        this.save(properties);
        return found != null;
    }

    private Properties load() {
        Properties properties;
        block15: {
            properties = new Properties();
            if (this.location.exists()) {
                FileInputStream input = null;
                try {
                    try {
                        input = new FileInputStream(this.location);
                        properties.loadFromXML(input);
                    }
                    catch (IOException iOException) {
                        try {
                            if (input != null) {
                                ((InputStream)input).close();
                            }
                            break block15;
                        }
                        catch (IOException iOException2) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            ((InputStream)input).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private void save(Properties properties) {
        block14: {
            FileOutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(this.location);
                    properties.storeToXML(output, "credentials");
                    ((OutputStream)output).close();
                }
                catch (IOException iOException) {
                    try {
                        if (output != null) {
                            ((OutputStream)output).close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        ((OutputStream)output).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    ((OutputStream)output).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public class LinkedAccount {
        public String clientId;
        public String authURI;
        public String email;

        public LinkedAccount(String clientId, String authURI, String email) {
            this.authURI = authURI;
            this.clientId = clientId;
            this.email = email;
        }
    }
}

