/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.dialogs.ImportTypeDialog;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.CopyResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileStoreStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class CopyFilesAndFoldersOperation {
    private MultiStatus errorStatus;
    private Shell messageShell;
    private boolean canceled = false;
    private boolean createVirtualFoldersAndLinks = false;
    private boolean createLinks = false;
    private String relativeVariable = null;
    private boolean alwaysOverwrite = false;
    private String[] modelProviderIds;

    static IPath getAutoNewNameFor(IPath originalName, IWorkspace workspace) {
        String resourceName = originalName.lastSegment();
        IPath leadupSegment = originalName.removeLastSegments(1);
        boolean isFile = !originalName.hasTrailingSeparator();
        String newName = CopyFilesAndFoldersOperation.computeNewName(resourceName, isFile);
        while (true) {
            IPath pathToTry = leadupSegment.append(newName);
            if (!workspace.getRoot().exists(pathToTry)) {
                return pathToTry;
            }
            newName = CopyFilesAndFoldersOperation.computeNewName(newName, isFile);
        }
    }

    private static String computeNewName(String str, boolean isFile) {
        Pattern p;
        Matcher m;
        int lastIndexOfDot = str.lastIndexOf(46);
        String fileExtension = "";
        String fileNameNoExtension = str;
        if (isFile && lastIndexOfDot > 0) {
            fileExtension = str.substring(lastIndexOfDot);
            fileNameNoExtension = str.substring(0, lastIndexOfDot);
        }
        if ((m = (p = Pattern.compile("[0-9]+$")).matcher(fileNameNoExtension)).find()) {
            String numberStr;
            BigDecimal newNumber = null;
            try {
                newNumber = new BigDecimal(m.group()).add(new BigDecimal(1));
                numberStr = m.replaceFirst(newNumber.toPlainString());
            }
            catch (NumberFormatException numberFormatException) {
                numberStr = m.replaceFirst("2");
            }
            return String.valueOf(numberStr) + fileExtension;
        }
        return String.valueOf(fileNameNoExtension) + "2" + fileExtension;
    }

    public CopyFilesAndFoldersOperation(Shell shell) {
        this.messageShell = shell;
    }

    protected boolean canPerformAutoRename() {
        return true;
    }

    protected String getDeepCheckQuestion(IResource source) {
        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_deepCopyQuestion, (Object)source.getFullPath().makeRelative());
    }

    IStatus checkExist(IFileStore[] stores) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        IFileStore[] iFileStoreArray = stores;
        int n = stores.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore store = iFileStoreArray[n2];
            if (!store.fetchInfo().exists()) {
                String message = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)store.getName());
                Status status = new Status(4, "org.eclipse.ui", 0, message, null);
                multiStatus.add((IStatus)status);
            }
            ++n2;
        }
        return multiStatus;
    }

    IStatus checkExist(IResource[] resources) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource != null && !resource.isVirtual()) {
                IFileInfo info;
                URI location = resource.getLocationURI();
                String message = null;
                if (!(location == null || (info = IDEResourceInfoUtils.getFileInfo(location)) != null && info.exists())) {
                    message = resource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_missingLinkTarget, (Object)resource.getName()) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)resource.getName());
                }
                if (message != null) {
                    Status status = new Status(4, "org.eclipse.ui", 0, message, null);
                    multiStatus.add((IStatus)status);
                }
            }
            ++n2;
        }
        return multiStatus;
    }

    private int checkOverwrite(final IResource source, final IResource destination) {
        final int[] result = new int[1];
        Runnable query = new Runnable(){

            @Override
            public void run() {
                String message;
                int[] resultId = new int[]{2, 4, 3, 1};
                String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                if (destination.getType() == 2) {
                    if (CopyFilesAndFoldersOperation.this.homogenousResources(source, destination)) {
                        message = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteMergeQuestion, (Object)destination.getFullPath().makeRelative());
                    } else {
                        message = destination.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteNoMergeLinkQuestion, (Object)destination.getFullPath().makeRelative()) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteNoMergeNoLinkQuestion, (Object)destination.getFullPath().makeRelative());
                        resultId = new int[]{2, 3, 1};
                        labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                } else {
                    Object[] bindings = new String[]{IDEResourceInfoUtils.getLocationText(destination), IDEResourceInfoUtils.getDateStringValue(destination), IDEResourceInfoUtils.getLocationText(source), IDEResourceInfoUtils.getDateStringValue(source)};
                    message = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteWithDetailsQuestion, (Object[])bindings);
                }
                MessageDialog dialog = new MessageDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceExists, null, message, 3, 0, labels){

                    protected int getShellStyle() {
                        return super.getShellStyle() | 0x10000000;
                    }
                };
                dialog.open();
                result[0] = dialog.getReturnCode() == -1 ? 1 : resultId[dialog.getReturnCode()];
            }
        };
        this.messageShell.getDisplay().syncExec(query);
        return result[0];
    }

    private void collectExistingReadonlyFiles(IPath destinationPath, IResource[] copyResources, ArrayList<IFile> existing) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] iResourceArray = copyResources;
        int n = copyResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IPath newDestinationPath = destinationPath.append(resource.getName());
            IResource newDestination = workspaceRoot.findMember(newDestinationPath);
            if (newDestination != null) {
                IFolder folder = this.getFolder(newDestination);
                if (folder != null) {
                    IFolder sourceFolder = this.getFolder(resource);
                    if (sourceFolder != null) {
                        try {
                            this.collectExistingReadonlyFiles(newDestinationPath, sourceFolder.members(), existing);
                        }
                        catch (CoreException exception) {
                            this.recordError(exception);
                        }
                    }
                } else {
                    IFile file = this.getFile(newDestination);
                    if (file != null) {
                        IFile sourceFile;
                        if (file.isReadOnly()) {
                            existing.add(file);
                        }
                        if (this.getValidateConflictSource() && (sourceFile = this.getFile(resource)) != null) {
                            existing.add(sourceFile);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    @Deprecated
    protected void copy(IResource[] resources, IPath destination, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_CopyResourcesTask, (int)resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            SubMonitor iterationMonitor = subMonitor.split(1).setWorkRemaining(100);
            IPath destinationPath = destination.append(resource.getName());
            IWorkspace workspace = resource.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IResource existing = workspaceRoot.findMember(destinationPath);
            if (resource.getType() == 2 && existing != null) {
                if (this.homogenousResources(resource, existing)) {
                    IResource[] children = ((IContainer)resource).members();
                    this.copy(children, destinationPath, (IProgressMonitor)iterationMonitor.split(100));
                } else {
                    this.delete(existing, (IProgressMonitor)iterationMonitor.split(10));
                    resource.copy(destinationPath, 32, (IProgressMonitor)iterationMonitor.split(90));
                }
            } else if (existing != null) {
                if (this.homogenousResources(resource, existing)) {
                    this.copyExisting(resource, existing, (IProgressMonitor)iterationMonitor.split(100));
                } else {
                    this.delete(existing, (IProgressMonitor)iterationMonitor.split(10));
                    iterationMonitor.setWorkRemaining(100);
                    if ((this.createLinks || this.createVirtualFoldersAndLinks) && !resource.isLinked() && !resource.isVirtual()) {
                        if (resource.getType() == 1) {
                            IFile file = workspaceRoot.getFile(destinationPath);
                            file.createLink(this.createRelativePath(resource.getLocationURI(), (IResource)file), 0, (IProgressMonitor)iterationMonitor.split(100));
                        } else {
                            IFolder folder = workspaceRoot.getFolder(destinationPath);
                            if (this.createVirtualFoldersAndLinks) {
                                folder.create(8192, true, (IProgressMonitor)iterationMonitor.split(1));
                                IResource[] members = ((IContainer)resource).members();
                                if (members.length > 0) {
                                    this.copy(members, destinationPath, (IProgressMonitor)iterationMonitor.split(99));
                                }
                            } else {
                                folder.createLink(this.createRelativePath(resource.getLocationURI(), (IResource)folder), 0, (IProgressMonitor)iterationMonitor.split(100));
                            }
                        }
                    } else {
                        resource.copy(destinationPath, 32, (IProgressMonitor)iterationMonitor.split(100));
                    }
                }
            }
            ++n2;
        }
    }

    private URI createRelativePath(URI locationURI, IResource resource) {
        IPath result;
        if (this.relativeVariable == null) {
            return locationURI;
        }
        IPath location = URIUtil.toPath((URI)locationURI);
        try {
            result = URIUtil.toPath((URI)resource.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)location), true, this.relativeVariable));
        }
        catch (CoreException coreException) {
            return locationURI;
        }
        return URIUtil.toURI((IPath)result);
    }

    private void copyExisting(IResource source, IResource existing, IProgressMonitor monitor) throws CoreException {
        IFile sourceFile;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IFile existingFile = this.getFile(existing);
        if (existingFile != null && (sourceFile = this.getFile(source)) != null) {
            existingFile.setContents(sourceFile.getContents(), 2, (IProgressMonitor)subMonitor.split(1));
        }
    }

    public IResource[] copyResources(IResource[] resources, IContainer destination) {
        return this.copyResources(resources, destination, true);
    }

    public IResource[] copyResourcesInCurrentThread(IResource[] resources, IContainer destination, IProgressMonitor monitor) {
        return this.copyResources(resources, destination, false);
    }

    private IResource[] copyResources(final IResource[] resources, IContainer destination, boolean fork) {
        final IPath destinationPath = destination.getFullPath();
        final IResource[][] copiedResources = new IResource[1][0];
        IStatus resourceStatus = this.checkExist(resources);
        if (resourceStatus.getSeverity() != 0) {
            this.displayError(resourceStatus);
            return copiedResources[0];
        }
        String errorMsg = this.validateDestination(destination, resources);
        if (errorMsg != null) {
            this.displayError(errorMsg);
            return copiedResources[0];
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CopyFilesAndFoldersOperation.this.copyResources(resources, destinationPath, copiedResources, monitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(fork, true, op);
        }
        catch (InterruptedException interruptedException) {
            return copiedResources[0];
        }
        catch (InvocationTargetException e) {
            this.display(e);
        }
        if (this.errorStatus != null) {
            this.displayError((IStatus)this.errorStatus);
            this.errorStatus = null;
        }
        return copiedResources[0];
    }

    protected boolean isMove() {
        return false;
    }

    private void display(InvocationTargetException e) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, MessageFormat.format((String)"Exception in {0}.performCopy(): {1}", (Object[])new Object[]{this.getClass().getName(), e.getTargetException()}), null));
        this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)e.getTargetException().getMessage()));
    }

    public void copyFiles(URI[] uris, IContainer destination) {
        IFileStore[] stores = this.buildFileStores(uris);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, true, null);
    }

    public void copyFilesInCurrentThread(URI[] uris, IContainer destination, IProgressMonitor monitor) {
        IFileStore[] stores = this.buildFileStores(uris);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, false, monitor);
    }

    private IFileStore[] buildFileStores(URI[] uris) {
        IFileStore[] stores = new IFileStore[uris.length];
        int i = 0;
        while (i < uris.length) {
            IFileStore store;
            try {
                store = EFS.getStore((URI)uris[i]);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "org.eclipse.ui.ide");
                this.reportFileInfoNotFound(uris[i].toString());
                return null;
            }
            if (store == null) {
                this.reportFileInfoNotFound(uris[i].toString());
                return null;
            }
            stores[i] = store;
            ++i;
        }
        return stores;
    }

    public void copyOrLinkFiles(String[] fileNames, IContainer destination, int dropOperation) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean targetIsVirtual = destination.isVirtual();
        String dndPreference = store.getString(targetIsVirtual ? "IMPORT_FILES_AND_FOLDERS_VIRTUAL_FOLDER_MODE" : "IMPORT_FILES_AND_FOLDERS_MODE");
        int mode = 0;
        String variable = null;
        if (ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking")) {
            mode = 1;
        } else if (dndPreference.equals("prompt")) {
            ImportTypeDialog dialog = new ImportTypeDialog(this.messageShell, dropOperation, fileNames, destination);
            dialog.setResource((IResource)destination);
            if (dialog.open() == 0) {
                mode = dialog.getSelection();
                variable = dialog.getVariable();
            }
        } else if (dndPreference.equals("MOVE_COPY")) {
            mode = 1;
        } else if (dndPreference.equals("LINK")) {
            mode = 4;
        } else if (dndPreference.equals("LINK_AND_VIRTUAL_FOLDER")) {
            mode = 2;
        }
        switch (mode) {
            case 1: {
                this.copyFiles(fileNames, destination);
                break;
            }
            case 2: {
                if (variable != null) {
                    this.setRelativeVariable(variable);
                }
                this.createVirtualFoldersAndLinks(fileNames, destination);
                break;
            }
            case 4: {
                if (variable != null) {
                    this.setRelativeVariable(variable);
                }
                this.linkFiles(fileNames, destination);
                break;
            }
        }
    }

    public void copyFiles(String[] fileNames, IContainer destination) {
        IFileStore[] stores = this.buildFileStores(fileNames);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, true, null);
    }

    public void copyFilesInCurrentThread(String[] fileNames, IContainer destination, IProgressMonitor monitor) {
        IFileStore[] stores = this.buildFileStores(fileNames);
        if (stores == null) {
            return;
        }
        this.copyFileStores(destination, stores, false, monitor);
    }

    private IFileStore[] buildFileStores(String[] fileNames) {
        IFileStore[] stores = new IFileStore[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            IFileStore store = IDEResourceInfoUtils.getFileStore(fileNames[i]);
            if (store == null) {
                this.reportFileInfoNotFound(fileNames[i]);
                return null;
            }
            stores[i] = store;
            ++i;
        }
        return stores;
    }

    private void reportFileInfoNotFound(final String fileName) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), (String)NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_infoNotFound, (Object)fileName), null);
            }
        });
    }

    private void copyFileStores(IContainer destination, final IFileStore[] stores, boolean fork, IProgressMonitor monitor) {
        IStatus fileStatus = this.checkExist(stores);
        if (fileStatus.getSeverity() != 0) {
            this.displayError(fileStatus);
            return;
        }
        String errorMsg = this.validateImportDestinationInternal(destination, stores);
        if (errorMsg != null) {
            this.displayError(errorMsg);
            return;
        }
        final IPath destinationPath = destination.getFullPath();
        if (fork) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                @Override
                public void execute(IProgressMonitor monitor) {
                    CopyFilesAndFoldersOperation.this.copyFileStores(stores, destinationPath, monitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException exception) {
                this.display(exception);
            }
        } else {
            this.copyFileStores(stores, destinationPath, monitor);
        }
        if (this.errorStatus != null) {
            this.displayError((IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    private void displayError(final IStatus status) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), null, (IStatus)status);
            }
        });
    }

    IResource createLinkedResourceHandle(IContainer destination, IResource source) {
        IWorkspace workspace = destination.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IPath linkPath = destination.getFullPath().append(source.getName());
        Object linkHandle = source.getType() == 2 ? workspaceRoot.getFolder(linkPath) : workspaceRoot.getFile(linkPath);
        return linkHandle;
    }

    boolean delete(IResource resource, IProgressMonitor monitor) {
        boolean force = false;
        if (resource.getType() == 4) {
            IProject project = (IProject)resource;
            try {
                project.delete(true, force, monitor);
            }
            catch (CoreException e) {
                this.recordError(e);
                return false;
            }
        }
        int flags = 2;
        if (force) {
            flags |= 1;
        }
        try {
            resource.delete(flags, monitor);
        }
        catch (CoreException e) {
            this.recordError(e);
            return false;
        }
        return true;
    }

    private void displayError(final String message) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), (String)message);
            }
        });
    }

    protected IFile getFile(IResource resource) {
        return (IFile)Adapters.adapt((Object)resource, IFile.class);
    }

    @Deprecated
    protected File[] getFiles(String[] fileNames) {
        File[] files = new File[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            files[i] = new File(fileNames[i]);
            ++i;
        }
        return files;
    }

    protected IFolder getFolder(IResource resource) {
        return (IFolder)Adapters.adapt((Object)resource, IFolder.class);
    }

    private IPath getNewNameFor(final IPath originalName, final IWorkspace workspace) {
        final IResource resource = workspace.getRoot().findMember(originalName);
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        final String[] returnValue = new String[]{""};
        this.messageShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String string) {
                        if (resource.getName().equals(string)) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                        }
                        IStatus status = workspace.validateName(string, resource.getType());
                        if (!status.isOK()) {
                            return status.getMessage();
                        }
                        if (workspace.getRoot().exists(prefix.append(string))) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                        }
                        return null;
                    }
                };
                final String initial = CopyFilesAndFoldersOperation.getAutoNewNameFor(originalName, workspace).lastSegment().toString();
                InputDialog dialog = new InputDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object)resource.getName()), initial, validator){

                    protected Control createContents(Composite parent) {
                        Control contents = super.createContents(parent);
                        int lastIndexOfDot = initial.lastIndexOf(46);
                        if (resource instanceof IFile && lastIndexOfDot > 0) {
                            this.getText().setSelection(0, lastIndexOfDot);
                        }
                        return contents;
                    }
                };
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }
        });
        if (returnValue[0] == null) {
            throw new OperationCanceledException();
        }
        return prefix.append(returnValue[0]);
    }

    protected String getOperationTitle() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_operationTitle;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyFailedTitle;
    }

    protected boolean getValidateConflictSource() {
        return false;
    }

    protected boolean homogenousResources(IResource source, IResource destination) {
        boolean isSourceLinked = source.isLinked();
        boolean isDestinationLinked = destination.isLinked();
        return isSourceLinked && isDestinationLinked || !isSourceLinked && !isDestinationLinked;
    }

    private boolean isAccessible(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return ((IProject)resource).isOpen();
            }
        }
        return false;
    }

    boolean isDestinationSameAsSource(IResource[] sourceResources, IContainer destination) {
        IPath destinationLocation = destination.getLocation();
        IResource[] iResourceArray = sourceResources;
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getParent().equals((Object)destination)) {
                return true;
            }
            if (destinationLocation != null) {
                IPath sourceLocation = resource.getLocation();
                IPath destinationResource = destinationLocation.append(resource.getName());
                if (sourceLocation != null && sourceLocation.isPrefixOf(destinationResource)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean performCopy(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        try {
            AbstractWorkspaceOperation op = this.getUndoableCopyOrMoveOperation(resources, destination);
            op.setModelProviderIds(this.getModelProviderIds());
            if (op instanceof CopyResourcesOperation) {
                CopyResourcesOperation copyMoveOp = (CopyResourcesOperation)op;
                copyMoveOp.setCreateVirtualFolders(this.createVirtualFoldersAndLinks);
                copyMoveOp.setCreateLinks(this.createLinks);
                copyMoveOp.setRelativeVariable(this.relativeVariable);
            }
            op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter(this.messageShell));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                this.recordError((CoreException)e.getCause());
            } else {
                IDEWorkbenchPlugin.log(e.getMessage(), e);
                this.displayError(e.getMessage());
            }
            return false;
        }
        return true;
    }

    private boolean performCopyWithAutoRename(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        IWorkspace workspace = resources[0].getWorkspace();
        IPath[] destinationPaths = new IPath[resources.length];
        try {
            int i = 0;
            while (i < resources.length) {
                IResource source = resources[i];
                destinationPaths[i] = destination.append(source.getName());
                if (source.getType() != 1) {
                    destinationPaths[i] = destinationPaths[i].addTrailingSeparator();
                }
                if (workspace.getRoot().exists(destinationPaths[i])) {
                    destinationPaths[i] = this.getNewNameFor(destinationPaths[i], workspace);
                }
                ++i;
            }
            CopyResourcesOperation op = new CopyResourcesOperation(resources, destinationPaths, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle);
            op.setModelProviderIds(this.getModelProviderIds());
            op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter(this.messageShell));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                this.recordError((CoreException)e.getCause());
            } else {
                IDEWorkbenchPlugin.log(e.getMessage(), e);
                this.displayError(e.getMessage());
            }
            return false;
        }
        return true;
    }

    private void performFileImport(IFileStore[] stores, IContainer target, IProgressMonitor monitor) {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                if (CopyFilesAndFoldersOperation.this.alwaysOverwrite) {
                    return "ALL";
                }
                final String[] returnCode = new String[]{"CANCEL"};
                final String msg = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteQuestion, (Object)pathString);
                final String[] options = new String[]{IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteButtonLabel, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteAllButtonLabel, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_dontOverwriteButtonLabel, IDialogConstants.CANCEL_LABEL};
                CopyFilesAndFoldersOperation.this.messageShell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog dialog = new MessageDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_question, null, msg, 3, 0, options){

                            protected int getShellStyle() {
                                return super.getShellStyle() | 0x10000000;
                            }
                        };
                        dialog.open();
                        int returnVal = dialog.getReturnCode();
                        String[] returnCodes = new String[]{"YES", "ALL", "NO", "CANCEL"};
                        returnCode[0] = returnVal == -1 ? "CANCEL" : returnCodes[returnVal];
                    }
                });
                if (returnCode[0] == "ALL") {
                    CopyFilesAndFoldersOperation.this.alwaysOverwrite = true;
                } else if (returnCode[0] == "CANCEL") {
                    CopyFilesAndFoldersOperation.this.canceled = true;
                }
                return returnCode[0];
            }
        };
        ImportOperation op = new ImportOperation(target.getFullPath(), stores[0].getParent(), FileStoreStructureProvider.INSTANCE, query, Arrays.asList(stores));
        op.setContext(this.messageShell);
        op.setCreateContainerStructure(false);
        op.setVirtualFolders(this.createVirtualFoldersAndLinks);
        op.setCreateLinks(this.createLinks);
        op.setRelativeVariable(this.relativeVariable);
        try {
            op.run(monitor);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                this.displayError(((CoreException)e.getTargetException()).getStatus());
            } else {
                this.display(e);
            }
            return;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            if (this.errorStatus == null) {
                this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), null);
            }
            this.errorStatus.merge(status);
        }
    }

    private void recordError(CoreException error) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), (Throwable)error);
        }
        this.errorStatus.merge(error.getStatus());
    }

    public String validateDestination(IContainer destination, IResource[] sourceResources) {
        if (!this.isAccessible((IResource)destination)) {
            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationAccessError;
        }
        IContainer firstParent = null;
        URI destinationLocation = destination.getLocationURI();
        IResource[] iResourceArray = sourceResources;
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            String linkedResourceMessage;
            IResource sourceResource = iResourceArray[n2];
            if (firstParent == null) {
                firstParent = sourceResource.getParent();
            } else if (!firstParent.equals((Object)sourceResource.getParent())) {
                return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_parentNotEqual;
            }
            if (!(!destination.isVirtual() || sourceResource.isLinked() || sourceResource.isVirtual() || this.createLinks || this.createVirtualFoldersAndLinks)) {
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sourceCannotBeCopiedIntoAVirtualFolder, (Object)sourceResource.getName());
            }
            URI sourceLocation = sourceResource.getLocationURI();
            if (sourceLocation == null) {
                if (sourceResource.isLinked()) {
                    return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_missingPathVariable, (Object)sourceResource.getName());
                }
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)sourceResource.getName());
            }
            if (!destination.isVirtual()) {
                if (sourceLocation.equals(destinationLocation)) {
                    return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sameSourceAndDest, (Object)sourceResource.getName());
                }
                if (new Path(sourceLocation.toString()).isPrefixOf((IPath)new Path(destinationLocation.toString()))) {
                    return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationDescendentError;
                }
            }
            if ((linkedResourceMessage = this.validateLinkedResource(destination, sourceResource)) != null) {
                return linkedResourceMessage;
            }
            ++n2;
        }
        return null;
    }

    private boolean validateEdit(IContainer destination, IResource[] sourceResources) {
        ArrayList<IFile> copyFiles = new ArrayList<IFile>();
        this.collectExistingReadonlyFiles(destination.getFullPath(), sourceResources, copyFiles);
        if (copyFiles.size() > 0) {
            IFile[] files = copyFiles.toArray(new IFile[copyFiles.size()]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateEdit(files, (Object)this.messageShell);
            this.canceled = !status.isOK();
            return status.isOK();
        }
        return true;
    }

    public String validateImportDestination(IContainer destination, String[] sourceNames) {
        IFileStore[] stores = new IFileStore[sourceNames.length];
        int i = 0;
        while (i < sourceNames.length) {
            IFileStore store = IDEResourceInfoUtils.getFileStore(sourceNames[i]);
            if (store == null) {
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_infoNotFound, (Object)sourceNames[i]);
            }
            stores[i] = store;
            ++i;
        }
        return this.validateImportDestinationInternal(destination, stores);
    }

    private String validateImportDestinationInternal(IContainer destination, IFileStore[] sourceStores) {
        if (!this.isAccessible((IResource)destination)) {
            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationAccessError;
        }
        if (!destination.isVirtual()) {
            IFileStore destinationStore;
            try {
                destinationStore = EFS.getStore((URI)destination.getLocationURI());
            }
            catch (CoreException exception) {
                IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception);
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)exception.getLocalizedMessage());
            }
            IFileStore[] iFileStoreArray = sourceStores;
            int n = sourceStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore fileStore = iFileStoreArray[n2];
                IFileStore parentFileStore = fileStore.getParent();
                if (fileStore != null) {
                    if (destinationStore.equals(fileStore) || parentFileStore != null && destinationStore.equals(parentFileStore)) {
                        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_importSameSourceAndDest, (Object)fileStore.getName());
                    }
                    if (fileStore.isParentOf(destinationStore)) {
                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationDescendentError;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private String validateLinkedResource(IContainer destination, IResource source) {
        IResource linkHandle;
        if (!source.isLinked() || source.isVirtual()) {
            return null;
        }
        IWorkspace workspace = destination.getWorkspace();
        IStatus locationStatus = workspace.validateLinkLocationURI(linkHandle = this.createLinkedResourceHandle(destination, source), source.getRawLocationURI());
        if (locationStatus.getSeverity() == 4) {
            return locationStatus.getMessage();
        }
        IPath sourceLocation = source.getLocation();
        if (!source.getProject().equals((Object)destination.getProject()) && source.getType() == 2 && sourceLocation != null) {
            try {
                IResource[] iResourceArray = destination.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (sourceLocation.equals((Object)resource.getLocation()) && source.getName().equals(resource.getName())) {
                        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sameSourceAndDest, (Object)source.getName());
                    }
                    ++n2;
                }
            }
            catch (CoreException exception) {
                this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)exception.getMessage()));
            }
        }
        return null;
    }

    private IResource[] validateNoNameCollisions(IContainer destination, IResource[] sourceResources) {
        IPath destinationPath;
        IResource resource;
        ArrayList<IResource> copyItems = new ArrayList<IResource>();
        IWorkspaceRoot workspaceRoot = destination.getWorkspace().getRoot();
        int overwrite = 3;
        IResource[] iResourceArray = sourceResources;
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            destinationPath = destination.getFullPath().append(resource.getName());
            IPath sourcePath = resource.getFullPath();
            IResource newResource = workspaceRoot.findMember(destinationPath);
            if (newResource != null && destinationPath.isPrefixOf(sourcePath)) {
                this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteProblem, (Object)destinationPath, (Object)sourcePath));
                this.canceled = true;
                return null;
            }
            ++n2;
        }
        iResourceArray = sourceResources;
        n = sourceResources.length;
        n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            destinationPath = destination.getFullPath().append(resource.getName());
            IResource newResource = workspaceRoot.findMember(destinationPath);
            if (newResource != null) {
                if (overwrite != 4 || newResource.getType() == 2 && !this.homogenousResources(resource, (IResource)destination)) {
                    overwrite = this.checkOverwrite(resource, newResource);
                }
                if (overwrite == 2 || overwrite == 4) {
                    copyItems.add(resource);
                } else if (overwrite == 1) {
                    this.canceled = true;
                    return null;
                }
            } else {
                copyItems.add(resource);
            }
            ++n2;
        }
        return copyItems.toArray(new IResource[copyItems.size()]);
    }

    private void copyResources(IResource[] resources, IPath destinationPath, IResource[][] copiedResources, IProgressMonitor mon) {
        IResource[] copyResources = resources;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        subMonitor.setTaskName(this.getOperationTitle());
        subMonitor.worked(10);
        boolean copyWithAutoRename = false;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.exists(destinationPath)) {
            IContainer container = (IContainer)root.findMember(destinationPath);
            if (this.isDestinationSameAsSource(copyResources, container) && this.canPerformAutoRename()) {
                copyWithAutoRename = true;
            } else {
                if ((copyResources = this.validateNoNameCollisions(container, copyResources)) == null) {
                    if (this.canceled) {
                        return;
                    }
                    this.displayError(IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameCollision);
                    return;
                }
                if (!this.validateEdit(container, copyResources)) {
                    return;
                }
            }
        }
        this.errorStatus = null;
        if (copyResources.length > 0) {
            if (copyWithAutoRename) {
                this.performCopyWithAutoRename(copyResources, destinationPath, (IProgressMonitor)subMonitor.split(90));
            } else {
                this.performCopy(copyResources, destinationPath, (IProgressMonitor)subMonitor.split(90));
            }
        }
        copiedResources[0] = copyResources;
    }

    private void copyFileStores(IFileStore[] stores, IPath destinationPath, IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.exists(destinationPath)) {
            IContainer container = (IContainer)root.findMember(destinationPath);
            this.performFileImport(stores, container, monitor);
        }
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    public void createVirtualFoldersAndLinks(String[] fileNames, IContainer destination) {
        IFileStore[] stores = this.buildFileStores(fileNames);
        if (stores == null) {
            return;
        }
        this.createVirtualFoldersAndLinks = true;
        this.copyFileStores(destination, stores, true, null);
    }

    public void linkFiles(String[] fileNames, IContainer destination) {
        IFileStore[] stores = this.buildFileStores(fileNames);
        if (stores == null) {
            return;
        }
        this.createLinks = true;
        this.copyFileStores(destination, stores, true, null);
    }

    public void setVirtualFolders(boolean value) {
        this.createVirtualFoldersAndLinks = value;
    }

    public void setCreateLinks(boolean value) {
        this.createLinks = value;
    }

    public void setRelativeVariable(String variable) {
        this.relativeVariable = variable;
    }

    protected AbstractWorkspaceOperation getUndoableCopyOrMoveOperation(IResource[] resources, IPath destinationPath) {
        return new CopyResourcesOperation(resources, destinationPath, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle);
    }
}

