/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.ui.FirstChildLayout;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SearchField
extends Composite {
    private final FilteredTree filteredTree;

    public SearchField(Composite parent, final FilterHandler filterHandler) {
        super(parent, 0);
        this.setLayout(new FirstChildLayout());
        final PatternFilter patternFilter = new PatternFilter(){

            public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                if (SearchField.this.filteredTree != null) {
                    Text filterControl = SearchField.this.filteredTree.getFilterControl();
                    String filter = filterControl.getText();
                    filterHandler.handleFilter(filter);
                }
                return new Object[0];
            }
        };
        this.filteredTree = new FilteredTree(this, 0, patternFilter, true){

            protected void init(int treeStyle, PatternFilter filter) {
                ReflectUtil.setValue((String)"patternFilter", (Object)((Object)this), (Object)filter);
                this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
                this.createControl(SearchField.this, treeStyle);
                Job refreshJob = new Job("Refresh Filter"){

                    protected IStatus run(IProgressMonitor monitor) {
                        UIUtil.syncExec(new Runnable(){

                            public void run() {
                                patternFilter.filter((Viewer)treeViewer, null, null);
                                String text = this.getFilterString();
                                this.updateToolbar(text != null && text.length() > 0 && (initialText == null || !initialText.equals(text)));
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setSystem(true);
                ReflectUtil.setValue((String)"refreshJob", (Object)((Object)this), (Object)refreshJob);
                this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
                this.setFont(SearchField.this.getFont());
            }

            protected void createControl(Composite xxx, int treeStyle) {
                super.createControl((Composite)SearchField.this, treeStyle);
                Tree tree = this.treeViewer.getTree();
                tree.setParent((Composite)SearchField.this);
                tree.setLayoutData((Object)new GridData(0, 0));
                this.treeComposite.dispose();
                this.treeComposite = null;
            }
        };
        final Text filterControl = this.filteredTree.getFilterControl();
        filterControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27 && !"".equals(filterControl.getText())) {
                    filterControl.setText("");
                    e.doit = false;
                }
            }
        });
        filterControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000002) {
                    SearchField.this.finishFilter();
                    e.doit = false;
                }
            }
        });
    }

    public final PatternFilter getPatternFilter() {
        return this.filteredTree.getPatternFilter();
    }

    public final Text getFilterControl() {
        return this.filteredTree.getFilterControl();
    }

    public final void setInitialText(String text) {
        this.filteredTree.setInitialText(text);
    }

    public final boolean getEnabled() {
        return this.filteredTree.getEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.filteredTree.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.getFilterControl().setFocus();
    }

    protected void finishFilter() {
    }

    public static interface FilterHandler {
        public void handleFilter(String var1);
    }
}

