/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractApplication {
    protected boolean removeAddedRepositories = true;
    protected List<RepositoryDescriptor> sourceRepositories = new ArrayList<RepositoryDescriptor>();
    protected List<URI> artifactReposToRemove = new ArrayList<URI>();
    protected List<URI> metadataReposToRemove = new ArrayList<URI>();
    protected List<IInstallableUnit> sourceIUs = new ArrayList<IInstallableUnit>();
    private final List<RepositoryDescriptor> destinationRepos = new ArrayList<RepositoryDescriptor>();
    protected IArtifactRepository destinationArtifactRepository = null;
    protected IMetadataRepository destinationMetadataRepository = null;
    private CompositeMetadataRepository compositeMetadataRepository = null;
    private CompositeArtifactRepository compositeArtifactRepository = null;
    protected IProvisioningAgent agent;

    public AbstractApplication() {
        try {
            this.setupAgent();
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
    }

    public AbstractApplication(IProvisioningAgent agent) {
        this.agent = agent;
    }

    private void setupAgent() throws ProvisionException {
        ServiceReference providerRef;
        BundleContext bundleContext = Activator.getBundleContext();
        if (bundleContext == null) {
            return;
        }
        ServiceReference agentRef = bundleContext.getServiceReference(IProvisioningAgent.class);
        if (agentRef != null) {
            this.agent = (IProvisioningAgent)bundleContext.getService(agentRef);
            if (this.agent != null) {
                return;
            }
        }
        if ((providerRef = bundleContext.getServiceReference(IProvisioningAgentProvider.class)) == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)bundleContext.getService(providerRef);
        if (provider == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        this.agent = provider.createAgent(null);
        bundleContext.ungetService(providerRef);
    }

    public void setSourceIUs(List<IInstallableUnit> ius) {
        this.sourceIUs = ius;
    }

    protected void finalizeRepositories() {
        if (this.removeAddedRepositories) {
            IArtifactRepositoryManager artifactRepositoryManager = this.getArtifactRepositoryManager();
            for (URI uri : this.artifactReposToRemove) {
                artifactRepositoryManager.removeRepository(uri);
            }
            IMetadataRepositoryManager metadataRepositoryManager = this.getMetadataRepositoryManager();
            for (URI uri : this.metadataReposToRemove) {
                metadataRepositoryManager.removeRepository(uri);
            }
        }
        this.metadataReposToRemove = null;
        this.artifactReposToRemove = null;
        this.compositeArtifactRepository = null;
        this.compositeMetadataRepository = null;
        this.destinationArtifactRepository = null;
        this.destinationMetadataRepository = null;
    }

    protected IMetadataRepositoryManager getMetadataRepositoryManager() {
        return (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
    }

    protected IArtifactRepositoryManager getArtifactRepositoryManager() {
        return (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
    }

    public void initializeRepos(IProgressMonitor progress) throws ProvisionException {
        IArtifactRepositoryManager artifactRepositoryManager = this.getArtifactRepositoryManager();
        IMetadataRepositoryManager metadataRepositoryManager = this.getMetadataRepositoryManager();
        URI curLocation = null;
        for (RepositoryDescriptor repo : this.sourceRepositories) {
            try {
                curLocation = repo.getRepoLocation();
                if (repo.isBoth()) {
                    this.addRepository((IRepositoryManager)artifactRepositoryManager, curLocation, 0, this.artifactReposToRemove, progress);
                    this.addRepository((IRepositoryManager)metadataRepositoryManager, curLocation, 0, this.metadataReposToRemove, progress);
                    continue;
                }
                if (repo.isArtifact()) {
                    this.addRepository((IRepositoryManager)artifactRepositoryManager, curLocation, 0, this.artifactReposToRemove, progress);
                    continue;
                }
                if (repo.isMetadata()) {
                    this.addRepository((IRepositoryManager)metadataRepositoryManager, curLocation, 0, this.metadataReposToRemove, progress);
                    continue;
                }
                throw new ProvisionException(NLS.bind((String)Messages.unknown_repository_type, (Object)repo.getRepoLocation()));
            }
            catch (ProvisionException e) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidSource, (Object)curLocation), (Throwable)e);
                }
                if (e.getStatus().getCode() == 1000 && repo.isOptional()) continue;
                throw e;
            }
        }
        this.processDestinationRepos(artifactRepositoryManager, metadataRepositoryManager);
    }

    protected <T> IRepository<T> addRepository(IRepositoryManager<T> manager, URI location, int flags, List<URI> repoList, IProgressMonitor monitor) throws ProvisionException {
        if (!manager.contains(location)) {
            repoList.add(location);
        }
        return manager.loadRepository(location, flags, monitor);
    }

    private void processDestinationRepos(IArtifactRepositoryManager artifactRepositoryManager, IMetadataRepositoryManager metadataRepositoryManager) throws ProvisionException {
        this.destinationArtifactRepository = (IArtifactRepository)this.initializeDestinationRepo((IRepositoryManager)artifactRepositoryManager, RepositoryDescriptor::isArtifact);
        this.destinationMetadataRepository = (IMetadataRepository)this.initializeDestinationRepo((IRepositoryManager)metadataRepositoryManager, RepositoryDescriptor::isMetadata);
        if (this.destinationMetadataRepository == null && this.destinationArtifactRepository == null) {
            throw new ProvisionException(Messages.AbstractApplication_no_valid_destinations);
        }
    }

    private <T> IRepository<T> initializeDestinationRepo(IRepositoryManager<T> repositoryManager, Predicate<RepositoryDescriptor> typeFilter) throws ProvisionException {
        Optional<RepositoryDescriptor> descriptor = this.destinationRepos.stream().filter(typeFilter).findFirst();
        if (descriptor.isPresent()) {
            return this.initializeDestination(descriptor.get(), repositoryManager);
        }
        return null;
    }

    public IMetadataRepository getDestinationMetadataRepository() {
        return this.destinationMetadataRepository;
    }

    public IArtifactRepository getDestinationArtifactRepository() {
        return this.destinationArtifactRepository;
    }

    protected <T> IRepository<T> initializeDestination(RepositoryDescriptor toInit, IRepositoryManager<T> mgr) throws ProvisionException {
        List<URI> repoList;
        String repositoryType;
        if (mgr instanceof IMetadataRepositoryManager) {
            repositoryType = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
            repoList = this.metadataReposToRemove;
        } else if (mgr instanceof IArtifactRepositoryManager) {
            repositoryType = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
            repoList = this.artifactReposToRemove;
        } else {
            throw new AssertionError((Object)("Unsupported repository type: " + String.valueOf(mgr.getClass())));
        }
        try {
            IRepository<T> repository = this.addRepository(mgr, toInit.getRepoLocation(), 1, repoList, null);
            if (this.initDestinationRepository(repository, toInit)) {
                return repository;
            }
        }
        catch (ProvisionException repository) {
            // empty catch block
        }
        IRepository source = null;
        try {
            if (toInit.getFormat() != null) {
                source = mgr.loadRepository(toInit.getFormat(), 0, null);
            }
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        try {
            IRepository result = mgr.createRepository(toInit.getRepoLocation(), toInit.getName() != null ? toInit.getName() : (source != null ? source.getName() : toInit.getRepoLocation().toString()), repositoryType, source != null ? source.getProperties() : null);
            if (toInit.isCompressed() && !result.getProperties().containsKey("p2.compressed")) {
                result.setProperty("p2.compressed", "true");
            }
            return RepositoryHelper.validDestinationRepository((IRepository)result);
        }
        catch (UnsupportedOperationException e) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean initDestinationRepository(IRepository<?> repository, RepositoryDescriptor descriptor) {
        if (repository == null) return false;
        if (!repository.isModifiable()) return false;
        if (descriptor.getName() != null) {
            repository.setProperty("name", descriptor.getName());
        }
        if (repository instanceof ICompositeRepository && !descriptor.isAppend()) {
            ((ICompositeRepository)repository).removeAllChildren();
            return true;
        }
        if (repository instanceof IMetadataRepository) {
            IMetadataRepository metadataRepository = (IMetadataRepository)repository;
            if (!descriptor.isAppend()) {
                metadataRepository.removeAll();
                return true;
            }
        }
        if (!(repository instanceof IArtifactRepository)) return true;
        IArtifactRepository artifactRepository = (IArtifactRepository)repository;
        if (descriptor.isAppend()) return true;
        artifactRepository.removeAll((IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    public IMetadataRepository getCompositeMetadataRepository() {
        if (this.compositeMetadataRepository == null) {
            this.compositeMetadataRepository = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)this.agent);
            if (this.compositeMetadataRepository != null) {
                for (RepositoryDescriptor repo : this.sourceRepositories) {
                    if (!repo.isMetadata()) continue;
                    this.compositeMetadataRepository.addChild(repo.getRepoLocation());
                }
            }
        }
        return this.compositeMetadataRepository;
    }

    public IArtifactRepository getCompositeArtifactRepository() {
        if (this.compositeArtifactRepository == null) {
            this.compositeArtifactRepository = CompositeArtifactRepository.createMemoryComposite((IProvisioningAgent)this.agent);
            if (this.compositeArtifactRepository != null) {
                for (RepositoryDescriptor repo : this.sourceRepositories) {
                    if (!repo.isArtifact()) continue;
                    this.compositeArtifactRepository.addChild(repo.getRepoLocation());
                }
            }
        }
        return this.compositeArtifactRepository;
    }

    public boolean hasArtifactSources() {
        return !((ICompositeRepository)this.getCompositeArtifactRepository()).getChildren().isEmpty();
    }

    public boolean hasMetadataSources() {
        return !((ICompositeRepository)this.getCompositeMetadataRepository()).getChildren().isEmpty();
    }

    public abstract IStatus run(IProgressMonitor var1) throws ProvisionException;

    public void addDestination(RepositoryDescriptor descriptor) {
        this.destinationRepos.add(descriptor);
    }

    public void addSource(RepositoryDescriptor repo) {
        this.sourceRepositories.add(repo);
    }
}

