/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.dialogs.filteredtree;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PatternFilter
extends ViewerFilter {
    private final Map<Object, Object[]> cache = new HashMap<Object, Object[]>();
    private final Map<Object, Boolean> foundAnyCache = new HashMap<Object, Boolean>();
    private boolean useCache = false;
    private boolean includeLeadingWildcard = false;
    private StringMatcher matcher;
    private boolean useEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];
    private static final Pattern NON_WORD = Pattern.compile("\\W+", 256);

    public PatternFilter() {
    }

    public PatternFilter(boolean includeLeadingWildcard) {
        this.includeLeadingWildcard = includeLeadingWildcard;
    }

    public final Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null && this.useEarlyReturnIfMatcherIsNull) {
            return elements;
        }
        if (!this.useCache) {
            return super.filter(viewer, parent, elements);
        }
        Object[] filtered = this.cache.get(parent);
        if (filtered == null) {
            Boolean foundAny = this.foundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        }
        return filtered;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null) {
            return true;
        }
        if (!this.useCache) {
            return this.computeAnyVisible(viewer, elements);
        }
        Object[] filtered = this.cache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = this.foundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
            this.foundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard) {
        this.includeLeadingWildcard = includeLeadingWildcard;
    }

    public void setPattern(String patternString) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString == null || patternString.isEmpty()) {
            this.matcher = null;
        } else {
            String pattern = patternString + "*";
            if (this.includeLeadingWildcard) {
                pattern = "*" + pattern;
            }
            this.matcher = new StringMatcher(pattern, true, false);
        }
    }

    void clearCaches() {
        this.cache.clear();
        this.foundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.match(string);
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        if (viewer instanceof AbstractTreeViewer && ((AbstractTreeViewer)viewer).getContentProvider() instanceof ITreeContentProvider) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            return children != null && children.length > 0 && this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText;
        CellLabelProvider cellLabelProvider = null;
        if (viewer instanceof ColumnViewer) {
            cellLabelProvider = ((ColumnViewer)viewer).getLabelProvider(0);
        }
        if ((labelText = this.getTextFromLabelProvider((IBaseLabelProvider)cellLabelProvider, element)) == null) {
            IBaseLabelProvider baseLabelProvider = ((StructuredViewer)viewer).getLabelProvider();
            labelText = this.getTextFromLabelProvider(baseLabelProvider, element);
        }
        return this.wordMatches(labelText);
    }

    private String getTextFromLabelProvider(IBaseLabelProvider baseLabelProvider, Object element) {
        DelegatingStyledCellLabelProvider.IStyledLabelProvider styledStringProvider;
        StyledString styledText;
        if (baseLabelProvider == null) {
            return null;
        }
        String labelText = null;
        if (baseLabelProvider instanceof ILabelProvider) {
            labelText = ((ILabelProvider)baseLabelProvider).getText(element);
        } else if (baseLabelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            labelText = ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)baseLabelProvider).getStyledText(element).getString();
        } else if (baseLabelProvider instanceof DelegatingStyledCellLabelProvider && (styledText = (styledStringProvider = ((DelegatingStyledCellLabelProvider)baseLabelProvider).getStyledStringProvider()).getStyledText(element)) != null) {
            labelText = styledText.getString();
        }
        return labelText;
    }

    private String[] getWords(String text) {
        return NON_WORD.split(text, 0);
    }

    protected boolean wordMatches(String text) {
        String[] words;
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] stringArray = words = this.getWords(text);
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.match(word)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }
}

