/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs;

import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.LogService;
import org.eclipse.orion.server.logs.LogServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LogsActivator
implements BundleActivator {
    private static BundleContext context;
    private static LogsActivator instance;
    private ServiceTracker<LogService, ILogService> serviceTracker;

    static BundleContext getContext() {
        return context;
    }

    public static LogsActivator getDefault() {
        return instance;
    }

    public ILogService getLogService() {
        return (ILogService)this.serviceTracker.getService();
    }

    private void registerLogService() {
        boolean enabled = Boolean.parseBoolean(PreferenceHelper.getString((String)"orion.logs.logProviderEnabled"));
        if (!enabled) {
            return;
        }
        context.registerService(ILogService.class.getName(), (Object)new LogService(), null);
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        instance = this;
        this.registerLogService();
        LogServiceTracker customer = new LogServiceTracker(context);
        this.serviceTracker = new ServiceTracker(context, ILogService.class.getName(), (ServiceTrackerCustomizer)customer);
        this.serviceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        instance = null;
        this.serviceTracker.close();
    }
}

