/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSRFPreventionFilter
implements Filter {
    private static final String NONCES_DO_NOT_MATCH = "{0} {1} on behalf of user ''{2}'': CSRF tokens do not match: ''{3}'' does not equal ''{4}''";
    private static final String NO_NONCE_IN_HEADER = "{0} {1} on behalf of user ''{2}'': missing CSRF token in header.";
    private static final String NO_NONCE_IN_COOKIES = "{0} {1} on behalf of user ''{2}'': missing CSRF token in cookies.";
    private static final Logger LOG = LoggerFactory.getLogger(XSRFPreventionFilter.class);
    private static final String XSRF_TOKEN = "x-csrf-token";
    private final Set<String> entryPointList = new HashSet<String>();
    private final Set<String> exceptionList = new HashSet<String>();
    private SecureRandom secureRandom;
    private boolean xsrfPreventionFilterDisabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.entryPointList.add("/login");
        this.exceptionList.add("/login");
        this.exceptionList.add("/login/canaddusers");
        this.exceptionList.add("/login/form");
        this.exceptionList.add("/useremailconfirmation/cansendemails");
        this.secureRandom = new SecureRandom();
        this.secureRandom.nextBytes(new byte[1]);
        String enableCSRF = PreferenceHelper.getString((String)"orion.XSRFPreventionFilterEnabled");
        this.xsrfPreventionFilterDisabled = !Boolean.parseBoolean(enableCSRF);
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        boolean doNonceCheck;
        if (this.xsrfPreventionFilterDisabled) {
            chain.doFilter(req, resp);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String method = request.getMethod();
        String path = request.getServletPath();
        if (request.getPathInfo() != null) {
            path = String.valueOf(path) + request.getPathInfo();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format("Filter called for {0} {1}. ", method, path));
        }
        CookieHandler ch = new CookieHandler(request.getCookies(), XSRF_TOKEN);
        if (this.isEntryPoint(req, path) && !ch.hasNonceCookie()) {
            response.addCookie(new Cookie(XSRF_TOKEN, this.generateNonce(method, path)));
        }
        boolean bl = doNonceCheck = !"get".equalsIgnoreCase(method) && !this.isException(req, path);
        if (doNonceCheck) {
            String requestNonce = request.getHeader(XSRF_TOKEN);
            boolean nonceValid = this.checkNonce(method, path, ch, requestNonce);
            if (!nonceValid) {
                this.logReasonForInvalidNonce(request, method, path, ch, requestNonce);
                this.prepareResponseForInvalidNonce(response);
                return;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format("Skipping nonce check for {0} {1}", method, path));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isEntryPoint(ServletRequest req, String path) {
        if (this.entryPointList.contains(path)) {
            return true;
        }
        return this.entryPointList.contains((String)req.getAttribute("javax.servlet.forward.path_info"));
    }

    private boolean isException(ServletRequest req, String path) {
        if (this.exceptionList.contains(path)) {
            return true;
        }
        return this.exceptionList.contains((String)req.getAttribute("javax.servlet.forward.path_info"));
    }

    public void destroy() {
    }

    private void prepareResponseForInvalidNonce(HttpServletResponse response) throws IOException {
        response.setHeader(XSRF_TOKEN, "required");
        ServerStatus status = new ServerStatus(4, 403, "Access Denied", null);
        response.setContentType("application/json");
        response.setStatus(status.getHttpCode());
        response.getWriter().print(status.toJSON().toString());
    }

    private void logReasonForInvalidNonce(HttpServletRequest request, String method, String path, CookieHandler ch, String requestNonce) {
        if (ch.hasNonceCookie() && requestNonce != null) {
            LOG.error(MessageFormat.format(NONCES_DO_NOT_MATCH, method, path, request.getRemoteUser(), requestNonce, ch.getValue()));
        } else {
            if (!ch.hasNonceCookie()) {
                LOG.error(MessageFormat.format(NO_NONCE_IN_COOKIES, method, path, request.getRemoteUser()));
            }
            if (requestNonce == null) {
                LOG.error(MessageFormat.format(NO_NONCE_IN_HEADER, method, path, request.getRemoteUser()));
            }
        }
    }

    private boolean checkNonce(String method, String path, CookieHandler ch, String requestNonce) {
        boolean nonceValid = false;
        if (ch.hasNonceCookie()) {
            nonceValid = ch.getValue().equals(requestNonce);
        }
        return nonceValid;
    }

    private String generateNonce(String method, String path) {
        byte[] randomBytes = new byte[24];
        this.secureRandom.nextBytes(randomBytes);
        String nonce = Base64.encodeBase64URLSafeString((byte[])randomBytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format("Creating nonce  for {0} {1}: ''{2}''", method, path, nonce));
        }
        return nonce;
    }

    private static class CookieHandler {
        private Cookie cookie;

        public CookieHandler(Cookie[] cookies, String name) {
            if (cookies == null) {
                return;
            }
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie c = cookieArray[n2];
                if (name.equals(c.getName())) {
                    this.cookie = c;
                    break;
                }
                ++n2;
            }
        }

        public String getValue() {
            return this.cookie.getValue();
        }

        public boolean hasNonceCookie() {
            return this.cookie != null;
        }
    }
}

