/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.resources;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.osgi.util.NLS;

public class FileLocker {
    private File lockFile;
    private RandomAccessFile raFile = null;
    private FileLock lock = null;
    private static final boolean locking = Boolean.parseBoolean(PreferenceHelper.getString("orion.file.content.locking", "true"));

    public FileLocker(File toLock) {
        this.lockFile = toLock;
    }

    public synchronized boolean tryLock() throws IOException {
        block10: {
            if (!locking) {
                return true;
            }
            this.lockFile.createNewFile();
            this.raFile = new RandomAccessFile(this.lockFile, "rw");
            try {
                try {
                    this.lock = this.raFile.getChannel().tryLock(0L, 1L, false);
                }
                catch (IOException ioe) {
                    String specificMessage = NLS.bind((String)"An error occurred while locking file \"{0}\": \"{1}\". A common reason is that the file system or Runtime Environment does not support file locking for that location.", (Object[])new Object[]{this.lock, ioe.getMessage()});
                    throw new IOException(specificMessage);
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                    this.lock = null;
                    if (this.lock == null) {
                        IOUtilities.safeClose(this.raFile);
                        this.raFile = null;
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (this.lock == null) {
                    IOUtilities.safeClose(this.raFile);
                    this.raFile = null;
                }
                throw throwable;
            }
            if (this.lock == null) {
                IOUtilities.safeClose(this.raFile);
                this.raFile = null;
            }
        }
        return this.lock != null;
    }

    public synchronized void lock() throws IOException {
        if (!locking) {
            return;
        }
        this.lockFile.createNewFile();
        this.raFile = new RandomAccessFile(this.lockFile, "rw");
        boolean locked = false;
        try {
            try {
                do {
                    try {
                        this.lock = this.raFile.getChannel().lock(0L, 1L, false);
                        locked = true;
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {
                        Thread.sleep(1L);
                    }
                } while (!locked);
            }
            catch (InterruptedException e1) {
                String specificMessage = NLS.bind((String)"An error occurred while locking file \"{0}\": \"{1}\". A common reason is that the file system or Runtime Environment does not support file locking for that location.", (Object[])new Object[]{this.lock, e1.getMessage()});
                this.lock = null;
                throw new IOException(specificMessage);
            }
            catch (IOException ioe) {
                String specificMessage = NLS.bind((String)"An error occurred while locking file \"{0}\": \"{1}\". A common reason is that the file system or Runtime Environment does not support file locking for that location.", (Object[])new Object[]{this.lock, ioe.getMessage()});
                this.lock = null;
                throw new IOException(specificMessage);
            }
        }
        finally {
            if (this.lock == null) {
                IOUtilities.safeClose(this.raFile);
                this.raFile = null;
            }
        }
    }

    public synchronized boolean isValid() {
        return !locking || this.lock != null && this.lock.isValid();
    }

    public synchronized void release() {
        if (!locking) {
            return;
        }
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {}
        }
        if (this.raFile != null) {
            IOUtilities.safeClose(this.raFile);
        }
        this.lock = null;
        this.raFile = null;
    }
}

