/*******************************************************************************
 * @license
 * Copyright (c) 2013, 2016 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0
 * (http://www.eclipse.org/legal/epl-v10.html), and the Eclipse Distribution
 * License v1.0 (http://www.eclipse.org/org/documents/edl-v10.html).
 *
 * Contributors:  IBM Corporation - initial API and implementation
 ******************************************************************************/
/*eslint-env browser, amd*/
define([
	'orion/util'
], function(util) {
	var defaults = {
		autoSave: util.isElectron ? false : true,
		autoSaveVisible: true,
		autoSaveLocalVisible: true,
		autoSaveTimeout: 250,
		autoSaveTimeoutVisible: true,
		themeVisible: true,
		themeLocalVisible: true,
		fontSizeVisible: true,
		fontSizeLocalVisible: true,
		autoLoad: true,
		autoLoadVisible: true,
		saveDiffs: true,
		saveDiffsVisible: true,
		contentAssistAutoTrigger: true,
		contentAssistAutoTriggerVisible: true,
		showOccurrences: true,
		showOccurrencesVisible: true,
		autoPairParentheses: true,
		autoPairParenthesesVisible: true,
		autoPairBraces: true,
		autoPairBracesVisible: true,
		autoPairSquareBrackets: true,
		autoPairSquareBracketsVisible: true,
		autoPairAngleBrackets: false,
		autoPairAngleBracketsVisible: true,
		autoPairQuotations: true,
		autoPairQuotationsVisible: true,
		autoCompleteComments: true,
		autoCompleteCommentsVisible: true,
		smartIndentation: true,
		smartIndentationVisible: true,
		trimTrailingWhiteSpace: false,
		trimTrailingWhiteSpaceVisible: true,
		formatOnSave: false,
		formatOnSaveVisible: true,
		tabSize: 4,
		tabSizeVisible: true,
		expandTab: false,
		expandTabVisible: true,
		scrollAnimation: true,
		scrollAnimationVisible: true,
		scrollAnimationTimeout: 300,
		scrollAnimationTimeoutVisible: true,
		annotationRuler: true,
		annotationRulerVisible: true,
		lineNumberRuler: true,
		lineNumberRulerVisible: true,
		foldingRuler: true,
		foldingRulerVisible: true,
		overviewRuler: true,
		overviewRulerVisible: true,
		zoomRuler: false,
		zoomRulerVisible: true,
		zoomRulerLocalVisible: true,
		showWhitespaces: false,
		showWhitespacesVisible: true,
		wordWrap: false,
		wordWrapVisible: true,
		showMargin: false,
		showMarginVisible: true,
		marginOffset: 80,
		marginOffsetVisible: true,
		keyBindings: "Default",
		keyBindingsVisible: true,
		keyBindingsLocalVisible: true,
		diffService: false,
		diffServiceVisible: false,
				
		showCurrentSearchAnnotation: true,
		showMatchingSearchAnnotation: true,
		showReadOccurrenceAnnotation: true,
		showWriteOcurrenceAnnotation: true,
		showErrorAnnotation: true,
		showWarningAnnotation: true,
		showInfoAnnotation: true,
		showTaskAnnotation: true,
		showBookmarkAnnotation: true,
		showMatchingBracketAnnotation: true,
		showCurrentBracketAnnotation: true,
		showCurrentLineAnnotation: true,
		showOverviewCurrentSearchAnnotation: true,
		showOverviewMatchingSearchAnnotation: true,
		showOverviewReadOccurrenceAnnotation: true,
		showOverviewWriteOcurrenceAnnotation: true,
		showOverviewErrorAnnotation: true,
		showOverviewWarningAnnotation: true,
		showOverviewInfoAnnotation: true,
		showOverviewTaskAnnotation: true,
		showOverviewBookmarkAnnotation: true,
		showOverviewMatchingBracketAnnotation: true,
		showOverviewCurrentBracketAnnotation: true,
		showOverviewCurrentLineAnnotation: true,
		showTextCurrentSearchAnnotation: true,
		showTextMatchingSearchAnnotation: true,
		showTextReadOccurrenceAnnotation: true,
		showTextWriteOcurrenceAnnotation: true,
		showTextErrorAnnotation: true,
		showTextWarningAnnotation: true,
		showTextInfoAnnotation: true,
		showTextTaskAnnotation: true,
		showTextBookmarkAnnotation: true,
		showTextMatchingBracketAnnotation: true,
		showTextCurrentBracketAnnotation: true,
		showTextCurrentLineAnnotation: true,

		showCurrentSearchAnnotationVisible: true,
		showMatchingSearchAnnotationVisible: true,
		showReadOccurrenceAnnotationVisible: true,
		showWriteOcurrenceAnnotationVisible: true,
		showErrorAnnotationVisible: true,
		showWarningAnnotationVisible: true,
		showInfoAnnotationVisible: true,
		showTaskAnnotationVisible: true,
		showWarningAnnotationLocalVisible: true,
		showInfoAnnotationLocalVisible: true,
		showTaskAnnotationLocalVisible: true,
		showBookmarkAnnotationVisible: true,
		showMatchingBracketAnnotationVisible: true,
		showCurrentBracketAnnotationVisible: true,
		showCurrentLineAnnotationVisible: true,
		showOverviewCurrentSearchAnnotationVisible: true,
		showOverviewMatchingSearchAnnotationVisible: true,
		showOverviewReadOccurrenceAnnotationVisible: true,
		showOverviewWriteOcurrenceAnnotationVisible: true,
		showOverviewErrorAnnotationVisible: true,
		showOverviewWarningAnnotationVisible: true,
		showOverviewInfoAnnotationVisible: true,
		showOverviewTaskAnnotationVisible: true,
		showOverviewBookmarkAnnotationVisible: true,
		showOverviewMatchingBracketAnnotationVisible: true,
		showOverviewCurrentBracketAnnotationVisible: true,
		showOverviewCurrentLineAnnotationVisible: true,
		showTextCurrentSearchAnnotationVisible: true,
		showTextMatchingSearchAnnotationVisible: true,
		showTextReadOccurrenceAnnotationVisible: true,
		showTextWriteOcurrenceAnnotationVisible: true,
		showTextErrorAnnotationVisible: true,
		showTextWarningAnnotationVisible: true,
		showTextInfoAnnotationVisible: true,
		showTextTaskAnnotationVisible: true,
		showTextBookmarkAnnotationVisible: true,
		showTextMatchingBracketAnnotationVisible: true,
		showTextCurrentBracketAnnotationVisible: true,
		showTextCurrentLineAnnotationVisible: true,
	};
	return { defaults: defaults };
});
