/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.rcptt.launching.ext.VmInstallMetaData;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.ScenarioRunnable;
import org.eclipse.rcptt.runner.util.AutLaunchFail;
import org.eclipse.rcptt.runner.util.AutThread;
import org.eclipse.rcptt.runner.util.TargetPlatformChecker;

public class AUTsManager {
    final List<AutThread> autThreads = new ArrayList<AutThread>();
    final AtomicInteger autCounter = new AtomicInteger(0);
    private final RunnerConfiguration conf;
    private final TargetPlatformChecker tpc;
    private Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            try {
                AUTsManager.this.shutdownAUTs();
            }
            catch (CoreException e) {
                HeadlessRunnerPlugin.log(e.getStatus());
            }
        }
    };
    private Optional<VmInstallMetaData> autVM = null;

    public AUTsManager(RunnerConfiguration conf, TargetPlatformChecker tpc) {
        this.conf = conf;
        this.tpc = tpc;
        if (conf.shudownListenerPort > 0) {
            this.createShutdownListener(conf.shudownListenerPort);
        }
    }

    public boolean isClean() {
        return this.autThreads.isEmpty();
    }

    public void launchAutsAndStartTheirThreads(List<ScenarioRunnable> runnables) throws AutLaunchFail {
        int i = 0;
        while (i < this.conf.autCount) {
            if (runnables.isEmpty()) break;
            AutThread t = new AutThread(runnables, this, this.conf, this.tpc);
            int a = 0;
            while (true) {
                try {
                    t.launchAut();
                }
                catch (RuntimeException e) {
                    if (a > 10) {
                        throw new AutLaunchFail("AUT launch failed after 10 tries.", e);
                    }
                    System.out.println("Failed to launch AUT:" + e.getMessage());
                    HeadlessRunnerPlugin.getDefault().info("Failed to launch AUT:" + e.getMessage());
                    ++a;
                    continue;
                }
                break;
            }
            this.autThreads.add(t);
            ++i;
        }
        for (AutThread t : this.autThreads) {
            t.start();
        }
    }

    public void initShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void removeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    private void createShutdownListener(final int port) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_5 = null;
                    try (ServerSocket serverSocket = new ServerSocket(port);){
                        Throwable throwable2 = null;
                        Object var5_9 = null;
                        try {
                            Socket ignored = serverSocket.accept();
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    AUTsManager.this.shutdownAUTs();
                }
                catch (CoreException e) {
                    HeadlessRunnerPlugin.log(e.getStatus());
                }
                Runtime.getRuntime().exit(0);
            }
        }.start();
    }

    void shutdownAUTs() throws CoreException {
        System.out.println("Process terminated. Shut down AUTs");
        MultiStatus status = new MultiStatus("org.eclipse.rcptt.runner", 0, "Failed to shutdown AUTs", null);
        for (AutThread thread : this.autThreads) {
            try {
                thread.shutdown();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CoreException e) {
                status.add((IStatus)new MultiStatus("org.eclipse.rcptt.runner", 0, new IStatus[]{e.getStatus()}, "Aut " + String.valueOf(thread), null));
            }
        }
        this.autThreads.clear();
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    public Optional<VmInstallMetaData> getAutVm() throws CoreException {
        if (this.autVM != null) {
            return this.autVM;
        }
        if (this.conf.javaVM != null) {
            this.autVM = Optional.of(VmInstallMetaData.register((Path)Path.of(this.conf.javaVM, new String[0])));
            return this.autVM;
        }
        if (this.conf.executionEnvironment != null) {
            Optional<VmInstallMetaData> result = Optional.ofNullable(JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(this.conf.executionEnvironment)).flatMap(e -> this.suitableVm((IExecutionEnvironment)e)).flatMap(VmInstallMetaData::adapt);
            if (result.isEmpty()) {
                throw new CoreException(Status.error((String)("Can't find an installed JVM strictly compatible with execution environment " + this.conf.executionEnvironment)));
            }
            this.autVM = result;
            return this.autVM;
        }
        this.autVM = this.addJvmFromIniFile();
        return this.autVM;
    }

    private Optional<IVMInstall> suitableVm(IExecutionEnvironment e) {
        IVMInstall result = e.getDefaultVM();
        if (result != null) {
            return Optional.of(result);
        }
        return Arrays.stream(e.getCompatibleVMs()).filter(arg_0 -> ((IExecutionEnvironment)e).isStrictlyCompatible(arg_0)).findFirst();
    }

    private Optional<VmInstallMetaData> addJvmFromIniFile() throws CoreException {
        Path vmFromIni = this.tpc.getTargetPlatform().getJavaHome().orElse(null);
        if (vmFromIni == null) {
            return Optional.empty();
        }
        System.out.println("Trying to use VM from application's ini file: " + String.valueOf(vmFromIni));
        return Optional.of(VmInstallMetaData.register((Path)vmFromIni));
    }
}

