/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileResource
implements Resource {
    private final IFile file;
    private String extra;

    public FileResource(IFile file) {
        this.file = file;
    }

    public long lastModified() {
        return this.file.getLocalTimeStamp();
    }

    public InputStream openInputStream() throws Exception {
        return this.file.getContents(true);
    }

    public void write(OutputStream out) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = this.openInputStream();){
            stream.transferTo(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void close() throws IOException {
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getExtra() {
        return this.extra;
    }

    public long size() throws Exception {
        IFileInfo fetchInfo;
        IFileStore store;
        URI location = this.file.getLocationURI();
        if (location != null && (store = EFS.getStore((URI)location)) != null && (fetchInfo = store.fetchInfo()).exists()) {
            return fetchInfo.getLength();
        }
        return -1L;
    }

    public synchronized ByteBuffer buffer() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream stream = this.openInputStream();){
            return ByteBuffer.wrap(stream.readAllBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void addResources(Jar jar, IContainer container, Predicate<IResource> filter) throws CoreException {
        FileResource.addResources(jar, container, container.getProjectRelativePath().toString(), filter);
    }

    private static void addResources(Jar jar, IContainer container, String prefix, Predicate<IResource> filter) throws CoreException {
        if (container == null || !container.exists()) {
            return;
        }
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (filter == null || filter.test(resource)) {
                if (resource instanceof IFile) {
                    IPath projectRelativePath = resource.getProjectRelativePath();
                    String relativePath = projectRelativePath.toString();
                    String base = relativePath.substring(prefix.length());
                    if (base.startsWith("/")) {
                        base = base.substring(1);
                    }
                    jar.putResource(base, (Resource)new FileResource((IFile)resource));
                }
                if (resource instanceof IContainer) {
                    FileResource.addResources(jar, (IContainer)resource, prefix, filter);
                }
            }
            ++n2;
        }
    }
}

