/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.compare;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.Q7ResourceInfo;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.swt.graphics.Image;

public class ScenarioStructureCreator
implements IStructureCreator {
    public static final String STRUCTURE_COMPARE_TITLE = "Test Case Structure Compare";
    public static final String CONTENT_TYPE_SCENARIO = "Test Case";
    public static final String CONTENT_TYPE_NAME = "Name";
    public static final String CONTENT_TYPE_TAGS = "Tags";
    public static final String CONTENT_TYPE_EXTERNALREF = "External References";
    public static final String CONTENT_TYPE_DESCRIPTION = "Description";
    public static final String CONTENT_TYPE_SCRIPT = "Script";
    public static final String TYPE_ECL = "ecl";
    private final String fTitle;

    public ScenarioStructureCreator() {
        this(STRUCTURE_COMPARE_TITLE);
    }

    public ScenarioStructureCreator(String title) {
        this.fTitle = title;
    }

    public String getName() {
        return this.fTitle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStructureComparator getStructure(Object input) {
        if (!(input instanceof IStreamContentAccessor)) return null;
        IStreamContentAccessor sca = (IStreamContentAccessor)input;
        try {
            String scenarioContent = Utilities.readString((IStreamContentAccessor)sca);
            InputStream is = sca.getContents();
            try {
                byte[] content = FileUtil.getStreamContent((InputStream)is);
                Q7ResourceInfo info = new Q7ResourceInfo("--- RCPTT testcase ---", URI.createURI((String)"__compare__"));
                IPersistenceModel model = PersistenceManager.getInstance().getModel(content, info.getResource());
                if (model == null) {
                    return null;
                }
                try {
                    info.load(null);
                }
                catch (ModelException e) {
                    RcpttPlugin.log((Throwable)e);
                    return null;
                }
                Scenario sc = (Scenario)info.getNamedElement();
                ScenarioRoot root = new ScenarioRoot("");
                ScenarioRoot scenario = root.createScenarioContainer(CONTENT_TYPE_SCENARIO);
                scenario.setStringContents(scenarioContent);
                ScenarioPart name = scenario.createPartContainer(CONTENT_TYPE_NAME);
                name.setStringContents(sc.getName());
                ScenarioPart tags = scenario.createPartContainer(CONTENT_TYPE_TAGS);
                tags.setStringContents(sc.getTags());
                ScenarioPart extRef = scenario.createPartContainer(CONTENT_TYPE_EXTERNALREF);
                extRef.setStringContents(sc.getExternalReference());
                ScenarioPart desc = scenario.createPartContainer(CONTENT_TYPE_DESCRIPTION);
                desc.setStringContents(sc.getDescription());
                ScenarioPart script = scenario.createPartContainer(CONTENT_TYPE_SCRIPT);
                script.setStringContents(Scenarios.getScriptContent((Scenario)sc));
                return root;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IStructureComparator locate(Object path, Object input) {
        return null;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof ScenarioPart) {
            return ((ScenarioPart)node).getStringContents();
        }
        return null;
    }

    public void save(IStructureComparator node, Object input) {
        Assert.isTrue((boolean)false);
    }

    static class ScenarioPart
    extends ScenarioResource
    implements IStreamContentAccessor {
        private String fContents;

        ScenarioPart(String name) {
            super(name);
        }

        public String getType() {
            if (ScenarioStructureCreator.CONTENT_TYPE_SCRIPT.equals(this.getName())) {
                return ScenarioStructureCreator.TYPE_ECL;
            }
            return "txt";
        }

        public Object[] getChildren() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.fContents.getBytes(StandardCharsets.UTF_8));
        }

        String getStringContents() {
            return this.fContents;
        }

        void setStringContents(String contents) {
            this.fContents = contents;
            if (this.fContents == null) {
                this.fContents = "";
            }
        }
    }

    static abstract class ScenarioResource
    implements IStructureComparator,
    ITypedElement {
        private final String fName;

        ScenarioResource(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public Image getImage() {
            if (ScenarioStructureCreator.CONTENT_TYPE_SCENARIO.equals(this.getName())) {
                return Images.getImage((String)"icons/scenario.gif");
            }
            if (ScenarioStructureCreator.CONTENT_TYPE_SCRIPT.equals(this.getName())) {
                return Images.getImage((String)"icons/panel/scenario.gif");
            }
            return CompareUI.getImage((String)this.getType());
        }

        public boolean equals(Object other) {
            if (other instanceof ITypedElement) {
                return this.fName.equals(((ITypedElement)other).getName());
            }
            return super.equals(other);
        }

        public int hashCode() {
            return this.fName.hashCode();
        }
    }

    static class ScenarioRoot
    extends ScenarioPart {
        private final HashMap<String, ScenarioPart> fChildren = new HashMap(10);

        ScenarioRoot(String name) {
            super(name);
        }

        @Override
        public String getType() {
            if (ScenarioStructureCreator.CONTENT_TYPE_SCENARIO.equals(this.getName())) {
                return "txt";
            }
            return "FOLDER";
        }

        @Override
        public Object[] getChildren() {
            Object[] children = new Object[this.fChildren.size()];
            Iterator<ScenarioPart> iter = this.fChildren.values().iterator();
            int i = 0;
            while (iter.hasNext()) {
                children[i] = iter.next();
                ++i;
            }
            return children;
        }

        ScenarioRoot createScenarioContainer(String name) {
            ScenarioRoot scenario = new ScenarioRoot(name);
            this.fChildren.put(name, scenario);
            return scenario;
        }

        ScenarioPart createPartContainer(String type) {
            ScenarioPart part = new ScenarioPart(type);
            this.fChildren.put(type, part);
            return part;
        }
    }
}

