/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.APIUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class MathUtil {
    private MathUtil() {
    }

    public static boolean mathIsPoT(int value) {
        return Integer.bitCount(value) == 1;
    }

    public static int mathRoundPoT(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static boolean mathHasZeroByte(int value) {
        return (value - 0x1010101 & ~value & 0x80808080) != 0;
    }

    public static boolean mathHasZeroByte(long value) {
        return (value - 0x101010101010101L & (value ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) != 0L;
    }

    public static boolean mathHasZeroShort(int value) {
        return (value - 65537 & ~value & 0x80008000) != 0;
    }

    public static boolean mathHasZeroShort(long value) {
        return (value - 0x1000100010001L & (value ^ 0xFFFFFFFFFFFFFFFFL) & 0x8000800080008000L) != 0L;
    }

    public static long mathMultiplyHighU64(long x, long y) {
        long result = Math.multiplyHigh(x, y);
        result += y & x >> 63;
        return result += x & y >> 63;
    }

    public static long mathMultiplyHighS64(long x, long y) {
        return Math.multiplyHigh(x, y);
    }

    public static long mathDivideUnsigned(long dividend, long divisor) {
        return Long.divideUnsigned(dividend, divisor);
    }

    public static long mathRemainderUnsigned(long dividend, long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    static {
        APIUtil.apiLog("Java 11 multiplyHigh enabled");
        APIUtil.apiLog("Java 17 divideUnsigned/remainderUnsigned enabled");
    }
}

