/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public class ProjectionIterator
extends ConvertingIteration<BindingSet, BindingSet> {
    private final BiConsumer<MutableBindingSet, BindingSet> projector;
    private final Supplier<MutableBindingSet> maker;

    public ProjectionIterator(Projection projection, CloseableIteration<BindingSet> iter, BindingSet parentBindings, QueryEvaluationContext context) throws QueryEvaluationException {
        super(iter);
        ProjectionElemList projectionElemList = projection.getProjectionElemList();
        boolean isOuterProjection = this.determineOuterProjection((QueryModelNode)projection);
        boolean includeAllParentBindings = !isOuterProjection;
        BindingSetMapper[] array = (BindingSetMapper[])projectionElemList.getElements().stream().map(pe -> {
            String projectionName = pe.getProjectionAlias().orElse(pe.getName());
            return new BindingSetMapper(context.getValue(pe.getName()), context.setBinding(projectionName));
        }).toArray(BindingSetMapper[]::new);
        BiConsumer<MutableBindingSet, BindingSet> consumer = includeAllParentBindings ? (resultBindings, sourceBindings) -> {
            for (BindingSetMapper bindingSetMapper : array) {
                Value targetValue = bindingSetMapper.valueWithSourceName.apply((BindingSet)sourceBindings);
                if (targetValue == null) continue;
                bindingSetMapper.setTarget.accept(targetValue, (MutableBindingSet)resultBindings);
            }
        } : (resultBindings, sourceBindings) -> {
            for (BindingSetMapper bindingSetMapper : array) {
                Value targetValue = bindingSetMapper.valueWithSourceName.apply((BindingSet)sourceBindings);
                if (targetValue == null) {
                    targetValue = bindingSetMapper.valueWithSourceName.apply(parentBindings);
                }
                if (targetValue == null) continue;
                bindingSetMapper.setTarget.accept(targetValue, (MutableBindingSet)resultBindings);
            }
        };
        if (projectionElemList.getElements().isEmpty()) {
            consumer = (resultBindings, sourceBindings) -> {};
        }
        this.maker = includeAllParentBindings ? () -> context.createBindingSet(parentBindings) : context::createBindingSet;
        this.projector = consumer;
    }

    private BiConsumer<MutableBindingSet, BindingSet> andThen(BiConsumer<MutableBindingSet, BindingSet> consumer, BiConsumer<MutableBindingSet, BindingSet> next) {
        if (consumer == null) {
            return next;
        }
        return consumer.andThen(next);
    }

    private boolean determineOuterProjection(QueryModelNode ancestor) {
        while (ancestor.getParentNode() != null) {
            if (!((ancestor = ancestor.getParentNode()) instanceof Projection) && !(ancestor instanceof MultiProjection)) continue;
            return false;
        }
        return true;
    }

    protected BindingSet convert(BindingSet sourceBindings) throws QueryEvaluationException {
        MutableBindingSet qbs = this.maker.get();
        this.projector.accept(qbs, sourceBindings);
        return qbs;
    }

    public static BindingSet project(ProjectionElemList projElemList, BindingSet sourceBindings, BindingSet parentBindings) {
        return ProjectionIterator.project(projElemList, sourceBindings, parentBindings, false);
    }

    public static BindingSet project(ProjectionElemList projElemList, BindingSet sourceBindings, BindingSet parentBindings, boolean includeAllParentBindings) {
        QueryBindingSet resultBindings = ProjectionIterator.makeNewQueryBindings(parentBindings, includeAllParentBindings);
        for (ProjectionElem pe : projElemList.getElements()) {
            Value targetValue = sourceBindings.getValue(pe.getName());
            if (!includeAllParentBindings && targetValue == null) {
                targetValue = parentBindings.getValue(pe.getName());
            }
            if (targetValue == null) continue;
            resultBindings.setBinding(pe.getProjectionAlias().orElse(pe.getName()), targetValue);
        }
        return resultBindings;
    }

    private static QueryBindingSet makeNewQueryBindings(BindingSet parentBindings, boolean includeAllParentBindings) {
        QueryBindingSet resultBindings = new QueryBindingSet();
        if (includeAllParentBindings) {
            resultBindings.addAll(parentBindings);
        }
        return resultBindings;
    }

    private static class BindingSetMapper {
        Function<BindingSet, Value> valueWithSourceName;
        BiConsumer<Value, MutableBindingSet> setTarget;

        public BindingSetMapper(Function<BindingSet, Value> valueWithSourceName, BiConsumer<Value, MutableBindingSet> setTarget) {
            this.valueWithSourceName = valueWithSourceName;
            this.setTarget = setTarget;
        }

        public Function<BindingSet, Value> getValueWithSourceName() {
            return this.valueWithSourceName;
        }

        public BiConsumer<Value, MutableBindingSet> getSetTarget() {
            return this.setTarget;
        }
    }
}

