/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.Exportable;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.paths.AlternativePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.InversePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.OneOrMorePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SequencePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.ZeroOrMorePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.ZeroOrOnePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Path
implements Identifiable,
Exportable,
Targetable {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    Resource id;

    public Path(Resource id) {
        this.id = id;
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    public static Path buildPath(ShapeSource shapeSource, Resource id) {
        if (id == null) {
            return null;
        }
        if (id.isBNode()) {
            List collect = shapeSource.getAllStatements(id).filter(statement -> !statement.getPredicate().equals(RDF.TYPE)).collect(Collectors.toList());
            Path ret = null;
            for (Statement statement2 : collect) {
                IRI pathType = statement2.getPredicate();
                switch (pathType.toString()) {
                    case "http://www.w3.org/ns/shacl#inversePath": {
                        if (ret != null) {
                            logger.error("Multiple path types not supported! {}", (Object)Arrays.toString(collect.toArray()));
                        }
                        ret = new InversePath(id, (Resource)statement2.getObject(), shapeSource);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#alternativePath": {
                        if (ret != null) {
                            logger.error("Multiple path types not supported! {}", (Object)Arrays.toString(collect.toArray()));
                        }
                        ret = new AlternativePath(id, (Resource)statement2.getObject(), shapeSource);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#zeroOrMorePath": {
                        if (ret != null) {
                            logger.error("Multiple path types not supported! {}", (Object)Arrays.toString(collect.toArray()));
                        }
                        ret = new ZeroOrMorePath(id, (Resource)statement2.getObject(), shapeSource);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#oneOrMorePath": {
                        if (ret != null) {
                            logger.error("Multiple path types not supported! {}", (Object)Arrays.toString(collect.toArray()));
                        }
                        ret = new OneOrMorePath(id, (Resource)statement2.getObject(), shapeSource);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#zeroOrOnePath": {
                        if (ret != null) {
                            logger.error("Multiple path types not supported! {}", (Object)Arrays.toString(collect.toArray()));
                        }
                        ret = new ZeroOrOnePath(id, (Resource)statement2.getObject(), shapeSource);
                        break;
                    }
                    case "http://www.w3.org/1999/02/22-rdf-syntax-ns#first": {
                        if (ret != null) {
                            logger.error("Multiple path types not supported! {}", (Object)Arrays.toString(collect.toArray()));
                        }
                        ret = new SequencePath(id, shapeSource);
                        break;
                    }
                }
            }
            if (ret != null) {
                return ret;
            }
            if (collect.size() == 1) {
                throw new ShaclUnsupportedException("Unknown path type: " + String.valueOf(collect.get(0)));
            }
            throw new ShaclUnsupportedException("Unknown path type: " + Arrays.toString(collect.toArray()));
        }
        return new SimplePath((IRI)id);
    }

    public abstract PlanNode getAllAdded(ConnectionsGroup var1, Resource[] var2, PlanNodeWrapper var3);

    public abstract PlanNode getAnyAdded(ConnectionsGroup var1, Resource[] var2, PlanNodeWrapper var3);

    public String getVariablePrefix(StatementMatcher.Variable subject, StatementMatcher.Variable object) {
        String className = this.getClass().getSimpleName();
        return subject.getName() + "_" + (object != null ? object.getName() : "null") + "_" + className + "_";
    }

    public abstract boolean isSupported();

    public abstract String toSparqlPathString();

    @Override
    public final Set<Namespace> getNamespaces() {
        return Set.of();
    }
}

