/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.CanProduceValidationReport;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ReduceTargets;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class ClosedConstraintComponent
extends AbstractConstraintComponent
implements CanProduceValidationReport {
    private final List<IRI> paths;
    private final List<IRI> ignoredProperties;
    private final Resource ignoredPropertiesHead;
    private final HashSet<IRI> allAllowedPredicates;
    private final Shape shape;
    public boolean produceValidationReports;

    public ClosedConstraintComponent(ShapeSource shapeSource, List<Resource> property, Resource ignoredPropertiesHead, Shape shape) {
        this.paths = property.stream().flatMap(r -> shapeSource.getObjects((Resource)r, ShapeSource.Predicates.PATH).map(o -> (Resource)o).map(path -> Path.buildPath(shapeSource, path)).filter(p -> p instanceof SimplePath).map(p -> (IRI)p.getId())).collect(Collectors.toList());
        if (ignoredPropertiesHead != null) {
            this.ignoredPropertiesHead = ignoredPropertiesHead;
            this.ignoredProperties = ShaclAstLists.toList(shapeSource, ignoredPropertiesHead, IRI.class);
        } else {
            this.ignoredProperties = Collections.emptyList();
            this.ignoredPropertiesHead = null;
        }
        HashSet<IRI> allAllowedPredicates = new HashSet<IRI>(this.paths);
        allAllowedPredicates.addAll(this.ignoredProperties);
        this.allAllowedPredicates = allAllowedPredicates;
        this.shape = shape;
    }

    public ClosedConstraintComponent(ClosedConstraintComponent closedConstraintComponent) {
        this.paths = closedConstraintComponent.paths;
        this.ignoredProperties = closedConstraintComponent.ignoredProperties;
        this.ignoredPropertiesHead = closedConstraintComponent.ignoredPropertiesHead;
        this.allAllowedPredicates = closedConstraintComponent.allAllowedPredicates;
        this.shape = closedConstraintComponent.shape;
        this.produceValidationReports = closedConstraintComponent.produceValidationReports;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        if (!this.ignoredProperties.isEmpty()) {
            model.add(subject, SHACL.IGNORED_PROPERTIES, (Value)this.ignoredPropertiesHead, new Resource[0]);
            if (!model.contains(this.ignoredPropertiesHead, null, null, new Resource[0])) {
                ShaclAstLists.listToRdf(this.ignoredProperties, this.ignoredPropertiesHead, model);
            }
        }
        model.add(subject, SHACL.CLOSED, (Value)Values.literal((boolean)true), new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.ClosedConstraintComponent;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNode targetNodePlanNode;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode addedTargets;
            Path path = this.getTargetChain().getPath().get();
            if (overrideTargetNode != null) {
                addedTargets = effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            } else {
                BufferedSplitter addedTargetsBufferedSplitter = BufferedSplitter.getInstance(effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null));
                addedTargets = addedTargetsBufferedSplitter.getPlanNode();
                PlanNode addedByPath = path.getAllAdded(connectionsGroup, validationSettings.getDataGraph(), null);
                addedByPath = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), Unique.getInstance(new TrimToTarget(addedByPath, connectionsGroup), false, connectionsGroup));
                addedByPath = new ReduceTargets(addedByPath, addedTargetsBufferedSplitter.getPlanNode(), connectionsGroup);
                addedByPath = effectiveTarget.extend(addedByPath, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
                PlanNode addedByValue = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, null, null, validationSettings.getDataGraph(), UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), statement -> !this.allAllowedPredicates.contains(statement.getPredicate()), connectionsGroup.isIncludeInferredStatements());
                addedByValue = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(addedByValue, connectionsGroup, validationSettings.getDataGraph(), ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                addedByValue = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), addedByValue);
                addedTargets = UnionNode.getInstance(connectionsGroup, addedTargets, new TrimToTarget(new ShiftToPropertyShape(addedByValue, connectionsGroup), connectionsGroup));
                addedTargets = UnionNode.getInstance(connectionsGroup, addedByPath, addedTargets);
                addedTargets = Unique.getInstance(addedTargets, false, connectionsGroup);
            }
            BulkedExternalInnerJoin falseNode = new BulkedExternalInnerJoin(addedTargets, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), false, null, BulkedExternalInnerJoin.getMapper("a", "c", scope, validationSettings.getDataGraph()), connectionsGroup, AbstractBulkJoinPlanNode.DEFAULT_VARS);
            StatementMatcher.Variable<Value> subjectVariable = stableRandomVariableProvider.next();
            StatementMatcher.Variable<Value> predicateVariable = stableRandomVariableProvider.next();
            StatementMatcher.Variable<Value> objectVariable = stableRandomVariableProvider.next();
            SparqlFragment bgp = SparqlFragment.bgp(List.of(), subjectVariable.asSparqlVariable() + " " + predicateVariable.asSparqlVariable() + " " + objectVariable.asSparqlVariable() + ".", List.of());
            String notInSparqlFilter = "FILTER( " + predicateVariable.asSparqlVariable() + " NOT IN( " + this.allAllowedPredicates.stream().map(p -> "<" + p.toString() + ">").collect(Collectors.joining(", ")) + " ) )";
            SparqlFragment sparqlFragmentFilter = SparqlFragment.bgp(List.of(), notInSparqlFilter, List.of());
            SparqlFragment sparqlFragment = SparqlFragment.join(List.of(bgp, sparqlFragmentFilter));
            PlanNode falseNode1 = new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), falseNode, sparqlFragment, subjectVariable, ValidationTuple::getValue, (validationTuple, b) -> {
                if (this.produceValidationReports) {
                    return validationTuple.addValidationResult(t -> {
                        ValidationResult validationResult = new ValidationResult(t.getActiveTarget(), b.getValue(objectVariable.getName()), this.shape, this, this.shape.getSeverity(), ConstraintComponent.Scope.nodeShape, t.getContexts(), this.shape.getContexts());
                        validationResult.setPathIri(b.getValue(predicateVariable.getName()));
                        return validationResult;
                    });
                }
                return validationTuple;
            }, connectionsGroup).getTrueNode(UnBufferedPlanNode.class);
            return falseNode1;
        }
        assert (scope == ConstraintComponent.Scope.nodeShape);
        if (overrideTargetNode != null) {
            targetNodePlanNode = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
        } else {
            PlanNode addedTargets = effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
            UnorderedSelect unorderedSelect = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, null, null, validationSettings.getDataGraph(), UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), statement -> !this.allAllowedPredicates.contains(statement.getPredicate()), connectionsGroup.isIncludeInferredStatements());
            ReduceTargets notValuesIn = new ReduceTargets(unorderedSelect, addedTargets, connectionsGroup);
            PlanNode unique = Unique.getInstance(notValuesIn, false, connectionsGroup);
            PlanNode targetFilter = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), unique);
            PlanNode extend = effectiveTarget.extend(targetFilter, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
            targetNodePlanNode = UnionNode.getInstance(connectionsGroup, extend, effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null));
        }
        StatementMatcher.Variable<Value> predicateVariable = stableRandomVariableProvider.next();
        SparqlFragment bgp = SparqlFragment.bgp(List.of(), "?a " + predicateVariable.asSparqlVariable() + " ?c.", List.of());
        String notInSparqlFilter = "FILTER( " + predicateVariable.asSparqlVariable() + " NOT IN( " + this.allAllowedPredicates.stream().map(p -> "<" + p.toString() + ">").collect(Collectors.joining(", ")) + " ) )";
        SparqlFragment sparqlFragmentFilter = SparqlFragment.bgp(List.of(), notInSparqlFilter, List.of());
        SparqlFragment sparqlFragment = SparqlFragment.join(List.of(bgp, sparqlFragmentFilter));
        BulkedExternalInnerJoin bulkedExternalInnerJoin = new BulkedExternalInnerJoin(Unique.getInstance(targetNodePlanNode, false, connectionsGroup), connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), sparqlFragment, false, null, b -> {
            ValidationTuple validationTuple = new ValidationTuple(b.getValue("a"), b.getValue("c"), ConstraintComponent.Scope.propertyShape, true, validationSettings.getDataGraph());
            if (this.produceValidationReports) {
                validationTuple = validationTuple.addValidationResult(t -> {
                    ValidationResult validationResult = new ValidationResult(t.getActiveTarget(), t.getValue(), this.shape, this, this.shape.getSeverity(), ConstraintComponent.Scope.nodeShape, t.getContexts(), this.shape.getContexts());
                    validationResult.setPathIri(b.getValue(predicateVariable.getName()));
                    return validationResult;
                });
            }
            return validationTuple;
        }, connectionsGroup, List.of(AbstractBulkJoinPlanNode.DEFAULT_VARS.get(0), AbstractBulkJoinPlanNode.DEFAULT_VARS.get(1), predicateVariable));
        return bulkedExternalInnerJoin;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        switch (scope) {
            case none: {
                throw new IllegalStateException();
            }
            case nodeShape: {
                BufferedSplitter targets = BufferedSplitter.getInstance(effectiveTarget.getPlanNode(connectionsGroup, dataGraph, scope, false, null));
                PlanNode statementsNotMatchingPredicateList = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, null, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), statement -> !this.allAllowedPredicates.contains(statement.getPredicate()), connectionsGroup.isIncludeInferredStatements());
                statementsNotMatchingPredicateList = new ReduceTargets(statementsNotMatchingPredicateList, targets.getPlanNode(), connectionsGroup);
                statementsNotMatchingPredicateList = effectiveTarget.getTargetFilter(connectionsGroup, dataGraph, statementsNotMatchingPredicateList);
                if (connectionsGroup.getStats().hasRemoved()) {
                    PlanNode removed = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, null, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), statement -> !this.allAllowedPredicates.contains(statement.getPredicate()), connectionsGroup.isIncludeInferredStatements());
                    removed = new ReduceTargets(removed, targets.getPlanNode(), connectionsGroup);
                    removed = effectiveTarget.getTargetFilter(connectionsGroup, dataGraph, removed);
                    statementsNotMatchingPredicateList = UnionNode.getInstance(connectionsGroup, statementsNotMatchingPredicateList, removed);
                }
                PlanNode unique = Unique.getInstance(statementsNotMatchingPredicateList, false, connectionsGroup);
                PlanNode extend = effectiveTarget.extend(unique, connectionsGroup, dataGraph, scope, EffectiveTarget.Extend.left, false, null);
                return extend;
            }
            case propertyShape: {
                Path path = this.getTargetChain().getPath().get();
                BufferedSplitter addedTargetsBufferedSplitter = BufferedSplitter.getInstance(effectiveTarget.getPlanNode(connectionsGroup, dataGraph, scope, false, null));
                PlanNode addedTargets = addedTargetsBufferedSplitter.getPlanNode();
                PlanNode addedByPath = path.getAllAdded(connectionsGroup, dataGraph, null);
                addedByPath = effectiveTarget.getTargetFilter(connectionsGroup, dataGraph, Unique.getInstance(new TrimToTarget(addedByPath, connectionsGroup), false, connectionsGroup));
                addedByPath = new ReduceTargets(addedByPath, addedTargetsBufferedSplitter.getPlanNode(), connectionsGroup);
                addedByPath = effectiveTarget.extend(addedByPath, connectionsGroup, dataGraph, scope, EffectiveTarget.Extend.left, false, null);
                PlanNode addedByValue = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, null, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), statement -> !this.allAllowedPredicates.contains(statement.getPredicate()), connectionsGroup.isIncludeInferredStatements());
                UnorderedSelect removedByValue = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, null, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), statement -> !this.allAllowedPredicates.contains(statement.getPredicate()), connectionsGroup.isIncludeInferredStatements());
                addedByValue = UnionNode.getInstance(connectionsGroup, addedByValue, removedByValue);
                addedByValue = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(addedByValue, connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                addedByValue = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, addedByValue);
                addedTargets = UnionNode.getInstance(connectionsGroup, addedTargets, new TrimToTarget(new ShiftToPropertyShape(addedByValue, connectionsGroup), connectionsGroup));
                addedTargets = UnionNode.getInstance(connectionsGroup, addedByPath, addedTargets);
                addedTargets = Unique.getInstance(addedTargets, false, connectionsGroup);
                return addedTargets;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.Variable<String> value;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        final StatementMatcher.Variable<Value> predicateVariable = stableRandomVariableProvider.next();
        final StatementMatcher.Variable<Value> objectVariable = stableRandomVariableProvider.next();
        if (scope == ConstraintComponent.Scope.nodeShape) {
            value = null;
            StatementMatcher.Variable<Value> target = effectiveTarget.getTargetVar();
            query = (String)query + "\n" + this.getFilter(target, predicateVariable, objectVariable);
        } else {
            value = new StatementMatcher.Variable<String>("value");
            SparqlFragment sparqlFragment = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new);
            String pathQuery = sparqlFragment.getFragment();
            query = (String)query + "\n" + pathQuery;
            query = (String)query + "\n" + this.getFilter(value, predicateVariable, objectVariable);
        }
        List<StatementMatcher.Variable<Value>> allTargetVariables = effectiveTarget.getAllTargetVariables();
        ValidationQuery validationQuery = new ValidationQuery(this.getTargetChain().getNamespaces(), (String)query, allTargetVariables, value, scope, this, null, null);
        if (this.produceValidationReports) {
            validationQuery = validationQuery.withShape(this.shape).withSeverity(this.shape.getSeverity());
            validationQuery.makeCurrentStateValidationReport();
            validationQuery.setValidationResultGenerator(List.of(predicateVariable, objectVariable), new ValidationQuery.ValidationResultGenerator(){

                @Override
                public Function<ValidationTuple, ValidationResult> getValidationTupleValidationResultFunction(ValidationQuery validationQuery, Resource[] shapesGraphs, BindingSet bindings) {
                    Function<ValidationTuple, ValidationResult> validationResultFunction = t -> {
                        ValidationResult validationResult = new ValidationResult(t.getActiveTarget(), bindings.getValue(objectVariable.getName()), validationQuery.getShape(), validationQuery.getConstraintComponent_validationReport(), validationQuery.getSeverity(), t.getScope(), t.getContexts(), shapesGraphs);
                        validationResult.setPathIri(bindings.getValue(predicateVariable.getName()));
                        return validationResult;
                    };
                    return validationResultFunction;
                }
            });
        }
        return validationQuery;
    }

    private String getFilter(StatementMatcher.Variable<Value> target, StatementMatcher.Variable<Value> predicateVariable, StatementMatcher.Variable<Value> objectVariable) {
        SparqlFragment bgp = SparqlFragment.bgp(List.of(), target.asSparqlVariable() + " " + predicateVariable.asSparqlVariable() + " " + objectVariable.asSparqlVariable() + ".", List.of());
        String notInSparqlFilter = "FILTER( " + predicateVariable.asSparqlVariable() + " NOT IN( " + this.allAllowedPredicates.stream().map(p -> "<" + p.toString() + ">").collect(Collectors.joining(", ")) + " ) )";
        SparqlFragment sparqlFragmentFilter = SparqlFragment.bgp(List.of(), notInSparqlFilter, List.of());
        SparqlFragment sparqlFragment = SparqlFragment.join(List.of(bgp, sparqlFragmentFilter));
        return sparqlFragment.getFragment();
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.SPARQL;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return true;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new ClosedConstraintComponent(this);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    @Override
    public boolean equals(ConstraintComponent o, IdentityHashMap<Shape, Shape> kvIdentityHashMap) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClosedConstraintComponent that = (ClosedConstraintComponent)o;
        if (!Objects.equals(this.paths, that.paths)) {
            return false;
        }
        return Objects.equals(this.ignoredProperties, that.ignoredProperties);
    }

    @Override
    public int hashCode(IdentityHashMap<Shape, Boolean> identityHashMap) {
        int result = this.paths != null ? this.paths.hashCode() : 0;
        result = 31 * result + (this.ignoredProperties != null ? this.ignoredProperties.hashCode() : 0);
        return result;
    }

    @Override
    public void setProducesValidationReport(boolean producesValidationReport) {
        this.produceValidationReports = producesValidationReport;
    }

    @Override
    public boolean producesValidationReport() {
        return this.produceValidationReports;
    }
}

