/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks.diagnostics;

import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;

@InternalUseOnly
public interface LockMonitoring<T extends Lock> {
    public static final int INITIAL_WAIT_TO_COLLECT = 10000;

    public Lock getLock() throws InterruptedException;

    public Lock tryLock();

    default public Lock getLock(String alias) throws InterruptedException {
        return this.getLock();
    }

    public T unsafeInnerLock(Lock var1);

    default public void runCleanup() {
    }

    default public boolean requiresManualCleanup() {
        return false;
    }

    public static <T extends Lock> LockMonitoring<T> wrap(Lock.ExtendedSupplier<T> supplier) {
        return new Wrapper<T>(supplier);
    }

    public Lock register(T var1);

    public void unregister(Lock var1);

    public static class Wrapper<T extends Lock>
    implements LockMonitoring<T> {
        private final Lock.ExtendedSupplier<T> supplier;

        public Wrapper(Lock.ExtendedSupplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Lock getLock() throws InterruptedException {
            return this.supplier.getLock();
        }

        @Override
        public Lock tryLock() {
            return this.supplier.tryLock();
        }

        @Override
        public T unsafeInnerLock(Lock lock) {
            return (T)lock;
        }

        @Override
        public void unregister(Lock lock) {
        }

        @Override
        public Lock register(Lock lock) {
            return lock;
        }
    }
}

