/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.namespaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class NamespacesController
extends AbstractController {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public NamespacesController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reqMethod = request.getMethod();
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET namespace list");
            return this.getExportNamespacesResult(request, response);
        }
        if ("HEAD".equals(reqMethod)) {
            this.logger.info("HEAD namespace list");
            return this.getExportNamespacesResult(request, response);
        }
        if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE namespaces");
            return this.getClearNamespacesResult(request, response);
        }
        throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
    }

    private ModelAndView getExportNamespacesResult(HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException, ServerHTTPException {
        boolean headersOnly = "HEAD".equals(request.getMethod());
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (!headersOnly) {
            List<String> columnNames = Arrays.asList("prefix", "namespace");
            ArrayList<ListBindingSet> namespaces = new ArrayList<ListBindingSet>();
            try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
                ValueFactory vf = repositoryCon.getValueFactory();
                try (RepositoryResult<Namespace> iter = repositoryCon.getNamespaces();){
                    while (iter.hasNext()) {
                        Namespace ns = (Namespace)iter.next();
                        Literal prefix = vf.createLiteral(ns.getPrefix());
                        Literal namespace = vf.createLiteral(ns.getName());
                        ListBindingSet bindingSet = new ListBindingSet(columnNames, prefix, namespace);
                        namespaces.add(bindingSet);
                    }
                }
                catch (RepositoryException e) {
                    throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
                }
            }
            model.put("queryResult", new IteratingTupleQueryResult(columnNames, namespaces));
        }
        TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, TupleQueryResultWriterRegistry.getInstance());
        model.put("filenameHint", "namespaces");
        model.put("headersOnly", headersOnly);
        model.put("factory", factory);
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }

    private ModelAndView getClearNamespacesResult(HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException, ClientHTTPException {
        try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
            try {
                repositoryCon.clearNamespaces();
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
            }
            ModelAndView modelAndView = new ModelAndView((View)EmptySuccessView.getInstance());
            return modelAndView;
        }
    }
}

