/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.wizards.pages;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ldt.core.internal.grammar.LuaGrammarManager;
import org.eclipse.ldt.ui.internal.grammar.GrammarContentProvider;
import org.eclipse.ldt.ui.wizards.pages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class GrammarGroup {
    private ComboViewer availableGrammarComboViewer;
    private Button customGrammarRadio;
    private Button defaultGrammarRadio;
    private String grammar;
    private SelectionListener grammarChoiceListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GrammarGroup.this.availableGrammarComboViewer.getCombo().setEnabled(GrammarGroup.this.customGrammarRadio.getSelection());
            GrammarGroup.this.defaultGrammarLabel.setEnabled(GrammarGroup.this.defaultGrammarRadio.getSelection());
        }
    };
    private Label defaultGrammarLabel;

    public GrammarGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.GrammarGroup_group_name);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        this.defaultGrammarRadio = new Button((Composite)group, 16);
        this.defaultGrammarRadio.setText(Messages.GrammarGroup_defaultgrammar);
        this.defaultGrammarRadio.addSelectionListener(this.grammarChoiceListener);
        this.defaultGrammarLabel = new Label((Composite)group, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.defaultGrammarLabel);
        this.customGrammarRadio = new Button((Composite)group, 16);
        this.customGrammarRadio.setText(Messages.GrammarGroup_customgrammar);
        this.customGrammarRadio.addSelectionListener(this.grammarChoiceListener);
        this.availableGrammarComboViewer = new ComboViewer((Composite)group, 2056);
        this.availableGrammarComboViewer.setContentProvider((IContentProvider)new GrammarContentProvider());
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo(this.availableGrammarComboViewer.getControl());
        this.initializeGroup();
    }

    public String getSelectedGrammar() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GrammarGroup.this.grammar = null;
                if (GrammarGroup.this.customGrammarRadio != null && GrammarGroup.this.availableGrammarComboViewer != null && GrammarGroup.this.defaultGrammarLabel != null) {
                    if (GrammarGroup.this.customGrammarRadio.getSelection()) {
                        Object firstElement;
                        ISelection selection = GrammarGroup.this.availableGrammarComboViewer.getSelection();
                        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof String) {
                            GrammarGroup.this.grammar = (String)firstElement;
                        }
                    } else {
                        GrammarGroup.this.grammar = GrammarGroup.this.defaultGrammarLabel.getText();
                    }
                }
            }
        });
        return this.grammar;
    }

    private void initializeGroup() {
        if (this.availableGrammarComboViewer == null || this.availableGrammarComboViewer.getControl().isDisposed()) {
            return;
        }
        if (this.defaultGrammarRadio == null || this.defaultGrammarRadio.isDisposed()) {
            return;
        }
        List availableGrammars = LuaGrammarManager.getAvailableGrammars();
        this.availableGrammarComboViewer.setInput((Object)availableGrammars);
        this.availableGrammarComboViewer.setSelection((ISelection)new StructuredSelection((Object)LuaGrammarManager.getDefaultGrammar().getName()));
        this.defaultGrammarRadio.setSelection(true);
        this.availableGrammarComboViewer.getControl().setEnabled(false);
    }

    public void setDefaultGrammar(final String defaultGrammar) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GrammarGroup.this.defaultGrammarLabel.setText(defaultGrammar);
            }
        });
    }
}

