/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.diagram.editor.FunctionUtil;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModelUtil;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramTextCellEditor;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class NodeDirectEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private double cachedZoom = -1.0;
    private Font scaledFont;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            NodeDirectEditManager.this.updateScaledFont(newZoom);
        }
    };
    private Label label;
    protected SapphireDiagramEditor diagramEditor;
    protected TextPart textPart;
    protected Value<?> property;
    protected IFigure textFigure;
    protected IFigure parentFigure;
    private String initValue;
    private boolean committed = false;

    public NodeDirectEditManager(GraphicalEditPart source, TextPart textPart, CellEditorLocator locator, Label label) {
        super(source, null, locator);
        this.textPart = textPart;
        this.label = label;
        ShapeEditPart shapeEditPart = (ShapeEditPart)source;
        DiagramNodeEditPart nodeEditPart = shapeEditPart.getNodeEditPart();
        ShapePresentation shapePresentation = ShapeModelUtil.getChildShapePresentation(nodeEditPart.getCastedModel().getShapePresentation(), (ShapePart)textPart);
        this.textFigure = shapePresentation.getFigure();
        this.parentFigure = shapePresentation.getParentFigure();
        this.diagramEditor = ((ShapeEditPart)source).getConfigurationManager().getDiagramEditor();
        this.property = FunctionUtil.getFunctionProperty((Element)this.textPart.getLocalModelElement(), (FunctionResult)this.textPart.getContentFunction());
    }

    protected void bringDown() {
        if (!this.committed && this.isDirty() && this.getCellEditor() instanceof TextCellEditor) {
            Text text = (Text)this.getCellEditor().getControl();
            text.setText(this.initValue);
            this.internalCommit();
        }
        this.diagramEditor.setDirectEditingActive(false);
        ZoomManager zoomMgr = (ZoomManager)this.diagramEditor.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.removeZoomListener(this.zoomListener);
        }
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
        super.bringDown();
        this.disposeScaledFont();
        this.label.setVisible(true);
    }

    public void show() {
        this.diagramEditor.setDirectEditingActive(true);
        super.show();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new DiagramTextCellEditor(this.textPart, composite, 0x1000000);
    }

    private void disposeScaledFont() {
        if (this.scaledFont != null) {
            this.scaledFont.dispose();
            this.scaledFont = null;
        }
    }

    protected void initCellEditor() {
        this.initValue = this.property.text();
        if (this.initValue == null) {
            this.initValue = this.textPart.getContent();
        }
        this.getCellEditor().setValue((Object)this.initValue);
        this.initCellEditorPresentation();
    }

    protected DirectEditRequest createDirectEditRequest() {
        DirectEditRequest req = super.createDirectEditRequest();
        HashMap<String, TextPart> extendedData = new HashMap<String, TextPart>();
        extendedData.put("TEXTPART", this.textPart);
        req.setExtendedData(extendedData);
        return req;
    }

    protected void initCellEditorPresentation() {
        this.label.setVisible(false);
        ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            this.cachedZoom = -1.0;
            this.updateScaledFont(zoomMgr.getZoom());
            zoomMgr.addZoomListener(this.zoomListener);
        } else {
            this.getCellEditor().getControl().setFont(this.label.getFont());
        }
        this.actionBars = this.diagramEditor.getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    protected void handleValueChanged() {
        this.internalCommit();
        String cellText = (String)this.getCellEditor().getValue();
        if (cellText == null || cellText.isEmpty()) {
            ((TextFigure)this.textFigure).setText(" ");
        }
        this.label.setVisible(false);
        super.handleValueChanged();
    }

    protected void commit() {
        this.committed = true;
        super.commit();
        ((TextFigure)this.textFigure).setText(this.textPart.getContent());
    }

    public TextPart getTextPart() {
        return this.textPart;
    }

    private void internalCommit() {
        CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
        stack.execute(this.getEditPart().getCommand((Request)this.getDirectEditRequest()));
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void updateScaledFont(double zoom) {
        if (this.cachedZoom == zoom || this.getCellEditor() == null) {
            return;
        }
        Font font = this.label.getFont();
        this.disposeScaledFont();
        this.cachedZoom = zoom;
        if (zoom == 1.0) {
            this.getCellEditor().getControl().setFont(font);
        } else {
            FontData fd = font.getFontData()[0];
            fd.setHeight((int)((double)fd.getHeight() * zoom));
            this.scaledFont = new Font(null, fd);
            this.getCellEditor().getControl().setFont(this.scaledFont);
        }
    }
}

