/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.sapphire.ui.swt.gef.commands.CreateBendPointCommand;
import org.eclipse.sapphire.ui.swt.gef.commands.DeleteBendPointCommand;
import org.eclipse.sapphire.ui.swt.gef.commands.MoveBendPointCommand;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramBendpointCreationHandle;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramBendpointMoveHandle;

public class DiagramConnectionBendpointEditPolicy
extends BendpointEditPolicy {
    private static final List NULL_CONSTRAINT = new ArrayList();
    private Map<Shape, Integer> shapeToLineStyle = new HashMap<Shape, Integer>();

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
        if (connectionEditPart.getSource() == connectionEditPart.getTarget()) {
            return null;
        }
        CreateBendPointCommand com = new CreateBendPointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setDiagramConnectionModel((DiagramConnectionModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
        if (connectionEditPart.getSource() == connectionEditPart.getTarget()) {
            return null;
        }
        MoveBendPointCommand com = new MoveBendPointCommand();
        Point p = request.getLocation();
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
        com.setDiagramConnectionModel((DiagramConnectionModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
        if (connectionEditPart.getSource() == connectionEditPart.getTarget()) {
            return null;
        }
        DeleteBendPointCommand com = new DeleteBendPointCommand();
        Point p = request.getLocation();
        com.setLocation(p);
        com.setDiagramConnectionModel((DiagramConnectionModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected List createSelectionHandles() {
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
        if (connectionEditPart.getSource() == connectionEditPart.getTarget()) {
            return Collections.EMPTY_LIST;
        }
        boolean automaticallyBending = this.isAutomaticallyBending();
        List list = automaticallyBending ? this.createHandlesForAutomaticBendpoints() : this.createHandlesForUserBendpoints();
        return list;
    }

    private List createHandlesForAutomaticBendpoints() {
        ArrayList<DiagramBendpointCreationHandle> list = new ArrayList<DiagramBendpointCreationHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new DiagramBendpointCreationHandle(connEP, 0, i));
            ++i;
        }
        return list;
    }

    private List createHandlesForUserBendpoints() {
        ArrayList<Object> list = new ArrayList<Object>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        List bendPoints = (List)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = NULL_CONSTRAINT;
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            list.add((Object)new DiagramBendpointCreationHandle(connEP, bendPointIndex, i));
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                list.add((Object)new DiagramBendpointMoveHandle(connEP, bendPointIndex, i + 1));
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    private boolean isAutomaticallyBending() {
        List constraint = (List)this.getConnection().getRoutingConstraint();
        PointList points = this.getConnection().getPoints();
        return points.size() > 2 && (constraint == null || constraint.isEmpty());
    }

    protected void addSelectionHandles() {
        super.addSelectionHandles();
        this.showHighlight();
    }

    protected void removeSelectionHandles() {
        super.removeSelectionHandles();
        this.removeHighlight();
    }

    protected void showHighlight() {
        this.removeHighlight();
        int newLineStyle = 2;
        this.shapeToLineStyle.put(this.getConnectionFigure(), this.getConnectionFigure().getLineStyle());
        this.getConnectionFigure().setLineStyle(newLineStyle);
    }

    protected void removeHighlight() {
        Set<Shape> lineStyleShapes = this.shapeToLineStyle.keySet();
        for (Shape lineStyleShape : lineStyleShapes) {
            int lineStyle = this.shapeToLineStyle.get(lineStyleShape);
            lineStyleShape.setLineStyle(lineStyle);
        }
        this.shapeToLineStyle.clear();
    }

    private Shape getConnectionFigure() {
        return (Shape)((GraphicalEditPart)this.getHost()).getFigure();
    }
}

