/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import org.eclipse.draw2d.IFigure;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeUpdateEvent;
import org.eclipse.sapphire.ui.swt.gef.figures.SapphireImageFigure;
import org.eclipse.sapphire.ui.swt.gef.figures.SmoothImageFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ImagePresentation
extends ShapePresentation {
    private Listener shapeUpdateListener = new FilteredListener<ShapeUpdateEvent>(){

        protected void handleTypedEvent(ShapeUpdateEvent event) {
            ImagePresentation.this.refresh();
        }
    };

    public ImagePresentation(DiagramPresentation parent, ImagePart imagePart, DiagramResourceCache resourceCache) {
        super(parent, (ShapePart)imagePart, resourceCache);
        this.part().attach(this.shapeUpdateListener);
    }

    private void refresh() {
        if (this.getFigure() != null) {
            DiagramNodePart nodePart = (DiagramNodePart)this.part().nearest(DiagramNodePart.class);
            ImageData data = this.getImage();
            if (data != null) {
                ((SapphireImageFigure)this.getFigure()).setImage(nodePart.getSwtResourceCache().image(data));
            }
        }
    }

    public ImagePart part() {
        return (ImagePart)super.part();
    }

    public ImageData getImage() {
        return this.part().getImage();
    }

    @Override
    public void render() {
        SmoothImageFigure figure = null;
        if (this.visible()) {
            DiagramNodePart nodePart = (DiagramNodePart)this.part().nearest(DiagramNodePart.class);
            ImageData data = this.getImage();
            figure = data != null ? new SapphireImageFigure(this, nodePart.getSwtResourceCache().image(data)) : new SmoothImageFigure();
        }
        this.setFigure((IFigure)figure);
    }

    @Override
    public void dispose() {
        this.part().detach(this.shapeUpdateListener);
    }
}

